/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIException;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.preferences.formatter.AlreadyExistsDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.CreateProfileDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.RenameProfileDialog;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CodingStyleConfigurationBlock {
    private static final String PREF_LASTLOADPATH = "org.eclipse.jdt.ui.codeformatter.loadpath";
    private static final String PREF_LASTSAVEPATH = "org.eclipse.jdt.ui.codeformatter.savepath";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private static final int XML_VERSION = 1;
    protected static final String STORE_FILE = "code_formatter_profiles.xml";
    private static final String previewText = "/**\n* A sample source file for the code formatter preview\n*/\n\npackage mypackage; import java.util.LinkedList; public class MyIntStack {private final LinkedList fStack;public MyIntStack(){fStack= new LinkedList();}public int pop(){return ((Integer)fStack.removeFirst()).intValue();}public void push(int elem){fStack.addFirst(new Integer(elem));}public boolean isEmpty() {return fStack.isEmpty();}}";
    protected Composite fComposite;
    protected Combo fProfileCombo;
    protected Button fEditButton;
    protected Button fRenameButton;
    protected Button fDeleteButton;
    protected Button fNewButton;
    protected Button fLoadButton;
    protected Button fSaveButton;
    protected final ProfileManager fProfileManager;
    protected final JavaPreview fJavaPreview;
    private PixelConverter fPixConv;

    public CodingStyleConfigurationBlock() {
        ArrayList profiles = null;
        try {
            profiles = this.readProfilesFromFile(CodingStyleConfigurationBlock.getStoreFile());
        }
        catch (Exception e) {
            JavaPlugin.log(e);
        }
        if (profiles == null) {
            profiles = new ArrayList();
        }
        this.fProfileManager = new ProfileManager(profiles);
        ProfileManager.Profile selected = this.fProfileManager.getSelected();
        this.fJavaPreview = new JavaPreview(selected.getSettings());
        this.fJavaPreview.setPreviewText(previewText);
        new XMLFileUpdater();
    }

    public Control createContents(Composite parent) {
        this.fPixConv = new PixelConverter((Control)parent);
        this.fComposite = this.createComposite(parent, 5, false);
        this.createLabel(this.fComposite, "Sele&ct a profile:", 5);
        this.fProfileCombo = CodingStyleConfigurationBlock.createProfileCombo(this.fComposite, 2, this.fPixConv.convertWidthInCharsToPixels(20));
        this.fEditButton = CodingStyleConfigurationBlock.createButton(this.fComposite, "&Edit...", 32);
        this.fRenameButton = CodingStyleConfigurationBlock.createButton(this.fComposite, "Re&name...", 32);
        this.fDeleteButton = CodingStyleConfigurationBlock.createButton(this.fComposite, "&Remove", 32);
        Composite group = this.createComposite(this.fComposite, 4, false);
        GridData groupData = new GridData(256);
        groupData.horizontalSpan = 5;
        group.setLayoutData((Object)groupData);
        this.fNewButton = CodingStyleConfigurationBlock.createButton(group, "&New...", 32);
        ((GridData)this.createLabel((Composite)group, (String)"", (int)1).getLayoutData()).grabExcessHorizontalSpace = true;
        this.fLoadButton = CodingStyleConfigurationBlock.createButton(group, "Loa&d...", 128);
        this.fSaveButton = CodingStyleConfigurationBlock.createButton(group, "Sa&ve...", 128);
        this.createLabel(this.fComposite, "Prev&iew:", 5);
        this.configurePreview(this.fComposite, 5);
        new ButtonController();
        new ProfileComboController();
        new PreviewController();
        return this.fComposite;
    }

    private static Button createButton(Composite composite, String text, int style) {
        Button button = new Button(composite, 8);
        button.setText(text);
        GridData gd = new GridData(style);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        gd.heightHint = SWTUtil.getButtonHeightHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private static Combo createProfileCombo(Composite composite, int span, int widthHint) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private Label createLabel(Composite composite, String text, int numColumns) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = numColumns;
        gd.widthHint = 0;
        Label label = new Label(composite, 64);
        label.setText(text);
        label.setLayoutData((Object)gd);
        return label;
    }

    private Composite createComposite(Composite parent, int numColumns, boolean margins) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(numColumns, false);
        if (margins) {
            layout.marginHeight = this.fPixConv.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.fPixConv.convertHorizontalDLUsToPixels(7);
        } else {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        layout.horizontalSpacing = this.fPixConv.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.fPixConv.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void configurePreview(Composite composite, int numColumns) {
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.widthHint = 0;
        gd.heightHint = 0;
        Control control = this.fJavaPreview.createContents(composite);
        control.setLayoutData((Object)gd);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JavaPlugin.getDefault().getPreferenceStore();
    }

    public void performOk() {
        this.fProfileManager.commitChanges();
    }

    public Collection readProfilesFromFile(File file) throws CoreException, IOException {
        Collection collection;
        block7: {
            if (!file.exists()) {
                return null;
            }
            FileReader reader = new FileReader(file);
            if (reader == null) {
                return null;
            }
            try {
                collection = this.readProfilesFromStream(reader);
                Object var3_4 = null;
                if (reader == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var3_5 = null;
                    if (reader == null) break block8;
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
        return collection;
    }

    private Collection readProfilesFromStream(Reader reader) throws CoreException {
        Element cpElement;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
        }
        catch (SAXException e) {
            throw CodingStyleConfigurationBlock.createException(e, "Problems reading profiles from XML");
        }
        catch (ParserConfigurationException e) {
            throw CodingStyleConfigurationBlock.createException(e, "Problems reading profiles from XML");
        }
        catch (IOException e) {
            throw CodingStyleConfigurationBlock.createException(e, "Problems reading profiles from XML");
        }
        if (cpElement == null) {
            return null;
        }
        if (!cpElement.getNodeName().equalsIgnoreCase(XML_NODE_ROOT)) {
            return null;
        }
        NodeList list = cpElement.getChildNodes();
        int length = list.getLength();
        ArrayList<ProfileManager.CustomProfile> profiles = new ArrayList<ProfileManager.CustomProfile>();
        int i = 0;
        while (i < length) {
            Element element;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (element = (Element)node).getNodeName().equalsIgnoreCase(XML_NODE_PROFILE)) {
                profiles.add(this.createProfileFromElement(element));
            }
            ++i;
        }
        return profiles;
    }

    private ProfileManager.CustomProfile createProfileFromElement(Element element) {
        Map settings = ProfileManager.getDefaultSettings();
        String name = element.getAttribute(XML_ATTRIBUTE_NAME);
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Element setting;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (setting = (Element)node).getNodeName().equalsIgnoreCase(XML_NODE_SETTING)) {
                String id = setting.getAttribute(XML_ATTRIBUTE_ID);
                String value = setting.getAttribute(XML_ATTRIBUTE_VALUE);
                if (settings.containsKey(id)) {
                    settings.put(id, value);
                }
            }
            ++i;
        }
        return new ProfileManager.CustomProfile(name, settings);
    }

    /*
     * Exception decompiling
     */
    public static void writeProfilesToFile(Collection profiles, File file) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 36->40)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void writeProfilesToStream(Collection profiles, Writer writer) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(XML_NODE_ROOT);
            rootElement.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(1));
            document.appendChild(rootElement);
            Iterator iter = profiles.iterator();
            while (iter.hasNext()) {
                ProfileManager.Profile p = (ProfileManager.Profile)iter.next();
                if (!(p instanceof ProfileManager.CustomProfile)) continue;
                Element profile = CodingStyleConfigurationBlock.createProfileElement((ProfileManager.CustomProfile)p, document);
                rootElement.appendChild(profile);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw CodingStyleConfigurationBlock.createException(e, "Problems serializing the profiles to XML");
        }
        catch (ParserConfigurationException e) {
            throw CodingStyleConfigurationBlock.createException(e, "Problems serializing the profiles to XML");
        }
    }

    private static Element createProfileElement(ProfileManager.CustomProfile profile, Document document) {
        Element element = document.createElement(XML_NODE_PROFILE);
        element.setAttribute(XML_ATTRIBUTE_NAME, profile.getName());
        Iterator keyIter = profile.getSettings().keySet().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String value = (String)profile.getSettings().get(key);
            Element setting = document.createElement(XML_NODE_SETTING);
            setting.setAttribute(XML_ATTRIBUTE_ID, key);
            setting.setAttribute(XML_ATTRIBUTE_VALUE, value);
            element.appendChild(setting);
        }
        return element;
    }

    protected static File getStoreFile() {
        return JavaPlugin.getDefault().getStateLocation().append(STORE_FILE).toFile();
    }

    private static JavaUIException createException(Throwable t, String message) {
        return new JavaUIException(JavaUIStatus.createError(4, message, t));
    }

    private class XMLFileUpdater
    implements Observer {
        private final File fFile = CodingStyleConfigurationBlock.getStoreFile();

        public XMLFileUpdater() {
            CodingStyleConfigurationBlock.this.fProfileManager.addObserver(this);
        }

        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    try {
                        CodingStyleConfigurationBlock.writeProfilesToFile(CodingStyleConfigurationBlock.this.fProfileManager.getSortedProfiles(), this.fFile);
                        break;
                    }
                    catch (Exception x) {
                        JavaPlugin.log(x);
                    }
                }
            }
        }
    }

    private class ProfileComboController
    implements Observer,
    SelectionListener {
        private List fSortedProfiles;

        public ProfileComboController() {
            CodingStyleConfigurationBlock.this.fProfileCombo.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fProfileManager.addObserver(this);
            this.updateProfiles();
            this.updateSelection();
        }

        public void widgetSelected(SelectionEvent e) {
            int index = CodingStyleConfigurationBlock.this.fProfileCombo.getSelectionIndex();
            CodingStyleConfigurationBlock.this.fProfileManager.setSelected((ProfileManager.Profile)this.fSortedProfiles.get(index));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void update(Observable o, Object arg) {
            if (arg == null) {
                return;
            }
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: {
                    this.updateProfiles();
                }
                case 1: {
                    this.updateSelection();
                }
            }
        }

        private void updateProfiles() {
            this.fSortedProfiles = CodingStyleConfigurationBlock.this.fProfileManager.getSortedProfiles();
            CodingStyleConfigurationBlock.this.fProfileCombo.setItems(CodingStyleConfigurationBlock.this.fProfileManager.getSortedNames());
        }

        private void updateSelection() {
            CodingStyleConfigurationBlock.this.fProfileCombo.setText(CodingStyleConfigurationBlock.this.fProfileManager.getSelected().getName());
        }
    }

    private class ButtonController
    implements Observer,
    SelectionListener {
        public ButtonController() {
            CodingStyleConfigurationBlock.this.fProfileManager.addObserver(this);
            CodingStyleConfigurationBlock.this.fNewButton.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fRenameButton.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fEditButton.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fDeleteButton.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fSaveButton.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fLoadButton.addSelectionListener((SelectionListener)this);
            this.update(CodingStyleConfigurationBlock.this.fProfileManager, null);
        }

        public void update(Observable o, Object arg) {
            boolean state = ((ProfileManager)o).getSelected() instanceof ProfileManager.CustomProfile;
            CodingStyleConfigurationBlock.this.fEditButton.setEnabled(state);
            CodingStyleConfigurationBlock.this.fDeleteButton.setEnabled(state);
            CodingStyleConfigurationBlock.this.fSaveButton.setEnabled(state);
            CodingStyleConfigurationBlock.this.fRenameButton.setEnabled(state);
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == CodingStyleConfigurationBlock.this.fEditButton) {
                this.modifyButtonPressed();
            } else if (button == CodingStyleConfigurationBlock.this.fDeleteButton) {
                this.deleteButtonPressed();
            } else if (button == CodingStyleConfigurationBlock.this.fNewButton) {
                this.newButtonPressed();
            } else if (button == CodingStyleConfigurationBlock.this.fLoadButton) {
                this.loadButtonPressed();
            } else if (button == CodingStyleConfigurationBlock.this.fSaveButton) {
                this.saveButtonPressed();
            } else if (button == CodingStyleConfigurationBlock.this.fRenameButton) {
                this.renameButtonPressed();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void renameButtonPressed() {
            if (!(CodingStyleConfigurationBlock.this.fProfileManager.getSelected() instanceof ProfileManager.CustomProfile)) {
                return;
            }
            ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)CodingStyleConfigurationBlock.this.fProfileManager.getSelected();
            RenameProfileDialog renameDialog = new RenameProfileDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), profile);
            renameDialog.open();
        }

        private void modifyButtonPressed() {
            ModifyDialog modifyDialog = new ModifyDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), CodingStyleConfigurationBlock.this.fProfileManager.getSelected());
            modifyDialog.open();
        }

        private void deleteButtonPressed() {
            CodingStyleConfigurationBlock.this.fProfileManager.deleteSelected();
        }

        private void newButtonPressed() {
            CreateProfileDialog p = new CreateProfileDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), CodingStyleConfigurationBlock.this.fProfileManager);
            if (p.open() != 0) {
                return;
            }
            if (!p.openEditDialog()) {
                return;
            }
            ModifyDialog modifyDialog = new ModifyDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), p.getCreatedProfile());
            modifyDialog.open();
        }

        private void saveButtonPressed() {
            String path;
            FileDialog dialog = new FileDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), 8192);
            dialog.setText("Save profile to...");
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = JavaPlugin.getDefault().getDialogSettings().get(CodingStyleConfigurationBlock.PREF_LASTSAVEPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            JavaPlugin.getDefault().getDialogSettings().put(CodingStyleConfigurationBlock.PREF_LASTSAVEPATH, dialog.getFilterPath());
            File file = new File(path);
            ArrayList<ProfileManager.Profile> profiles = new ArrayList<ProfileManager.Profile>();
            profiles.add(CodingStyleConfigurationBlock.this.fProfileManager.getSelected());
            try {
                CodingStyleConfigurationBlock.writeProfilesToFile(profiles, file);
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)CodingStyleConfigurationBlock.this.fComposite.getShell(), (String)"Save profile", (String)"Could not save the profiles.");
            }
        }

        private void loadButtonPressed() {
            AlreadyExistsDialog aeDialog;
            String path;
            FileDialog dialog = new FileDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), 4096);
            dialog.setText("Load profile from...");
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = JavaPlugin.getDefault().getDialogSettings().get(CodingStyleConfigurationBlock.PREF_LASTLOADPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            JavaPlugin.getDefault().getDialogSettings().put(CodingStyleConfigurationBlock.PREF_LASTLOADPATH, dialog.getFilterPath());
            File file = new File(path);
            Collection profiles = null;
            try {
                profiles = CodingStyleConfigurationBlock.this.readProfilesFromFile(file);
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)CodingStyleConfigurationBlock.this.fComposite.getShell(), (String)"Load profile", (String)"Loading failed. Not a valid profile.");
            }
            if (profiles == null || profiles.isEmpty()) {
                return;
            }
            ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)profiles.iterator().next();
            if (CodingStyleConfigurationBlock.this.fProfileManager.containsName(profile.getName()) && (aeDialog = new AlreadyExistsDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), profile, CodingStyleConfigurationBlock.this.fProfileManager)).open() != 0) {
                return;
            }
            CodingStyleConfigurationBlock.this.fProfileManager.addProfile(profile);
        }
    }

    private class PreviewController
    implements Observer {
        public PreviewController() {
            CodingStyleConfigurationBlock.this.fProfileManager.addObserver(this);
            CodingStyleConfigurationBlock.this.fJavaPreview.setWorkingValues(CodingStyleConfigurationBlock.this.fProfileManager.getSelected().getSettings());
            CodingStyleConfigurationBlock.this.fJavaPreview.update();
        }

        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    CodingStyleConfigurationBlock.this.fJavaPreview.setWorkingValues(((ProfileManager)o).getSelected().getSettings());
                    CodingStyleConfigurationBlock.this.fJavaPreview.update();
                }
            }
        }
    }
}

