/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.quickdiff.QuickDiff;
import org.eclipse.ui.texteditor.quickdiff.ReferenceProviderDescriptor;

public class WorkInProgressPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREFIX = "WorkInProgress.";
    public static final String PREF_FORMATTER = "use_new_formatter";
    public static final String PREF_SEARCH_MENU = "small_search_menu";
    private Set fSmartTypingItems = new HashSet();
    private List fCheckBoxes;
    private List fRadioButtons;
    private List fTextControls;
    private org.eclipse.swt.widgets.List fQuickDiffProviderList;
    private String[][] fQuickDiffProviderListModel;
    private Button fSetDefaultButton;

    public WorkInProgressPreferencePage() {
        this.setPreferenceStore(this.getPreferenceStore());
        this.fRadioButtons = new ArrayList();
        this.fCheckBoxes = new ArrayList();
        this.fTextControls = new ArrayList();
        List providers = new QuickDiff().getReferenceProviderDescriptors();
        this.fQuickDiffProviderListModel = this.createQuickDiffReferenceListModel(providers);
    }

    private String[][] createQuickDiffReferenceListModel(List providers) {
        ArrayList<String[]> listModelItems = new ArrayList<String[]>();
        Iterator it = providers.iterator();
        while (it.hasNext()) {
            ReferenceProviderDescriptor provider = (ReferenceProviderDescriptor)it.next();
            String label = provider.getLabel();
            int i = label.indexOf(38);
            while (i >= 0) {
                if (i < label.length()) {
                    label = String.valueOf(label.substring(0, i)) + label.substring(i + 1);
                } else {
                    label.substring(0, i);
                }
                i = label.indexOf(38);
            }
            listModelItems.add(new String[]{provider.getId(), label});
        }
        String[][] items = new String[listModelItems.size()][];
        listModelItems.toArray((T[])items);
        return items;
    }

    private void handleProviderListSelection() {
        int i = this.fQuickDiffProviderList.getSelectionIndex();
        boolean b = this.getPreferenceStore().getString("quickdiff.defaultProvider").equals(this.fQuickDiffProviderListModel[i][0]);
        this.fSetDefaultButton.setEnabled(!b);
    }

    private Button addCheckBox(Composite parent, String label, String key) {
        GridData gd = new GridData(256);
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setData((Object)key);
        button.setLayoutData((Object)gd);
        button.setSelection(this.getPreferenceStore().getBoolean(key));
        this.fCheckBoxes.add(button);
        return button;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"WORK_IN_PROGRESS_PREFERENCE_PAGE");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        Group group = new Group(result, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(PreferencesMessages.getString("WorkInProgress.editor"));
        this.addCheckBox((Composite)group, PreferencesMessages.getString("WorkInProgress.markOccurrences"), "markOccurrences");
        this.createSpacer((Composite)group, 1);
        Label label = new Label((Composite)group, 0);
        label.setText(PreferencesMessages.getString("WorkInProgress.smartTyping.label"));
        Button button = this.addCheckBox((Composite)group, PreferencesMessages.getString("WorkInProgress.smartTyping.smartSemicolon"), "smart_semicolon");
        this.fSmartTypingItems.add(button);
        button = this.addCheckBox((Composite)group, PreferencesMessages.getString("WorkInProgress.smartTyping.smartOpeningBrace"), "smart_opening_brace");
        this.fSmartTypingItems.add(button);
        button = this.addCheckBox((Composite)group, PreferencesMessages.getString("WorkInProgress.smartTyping.smartTab"), "smart_tab");
        this.fSmartTypingItems.add(button);
        group = new Group(result, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(PreferencesMessages.getString("WorkInProgress.quickdiff"));
        Label l = new Label((Composite)group, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        button = this.addCheckBox((Composite)group, PreferencesMessages.getString("WorkInProgress.showQuickDiffPerDefault"), "quickdiff.quickDiff");
        button = this.addCheckBox((Composite)group, PreferencesMessages.getString("WorkInProgress.quickdiff.characterMode"), "quickdiff.characterMode");
        l = new Label((Composite)group, 16384);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label((Composite)group, 16384);
        l.setText(PreferencesMessages.getString("WorkInProgress.quickdiff.referenceprovidertitle"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fQuickDiffProviderList = new org.eclipse.swt.widgets.List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(4);
        this.fQuickDiffProviderList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        this.fSetDefaultButton = new Button(stylesComposite, 8);
        this.fSetDefaultButton.setText(PreferencesMessages.getString("WorkInProgress.quickdiff.setDefault"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fSetDefaultButton.setLayoutData((Object)gd);
        this.fQuickDiffProviderList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WorkInProgressPreferencePage.this.handleProviderListSelection();
            }
        });
        this.fSetDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = WorkInProgressPreferencePage.this.fQuickDiffProviderList.getSelectionIndex();
                int j = 0;
                while (j < WorkInProgressPreferencePage.this.fQuickDiffProviderListModel.length) {
                    if (WorkInProgressPreferencePage.this.getPreferenceStore().getString("quickdiff.defaultProvider").equals(WorkInProgressPreferencePage.this.fQuickDiffProviderListModel[j][0])) {
                        WorkInProgressPreferencePage.this.fQuickDiffProviderList.remove(j);
                        WorkInProgressPreferencePage.this.fQuickDiffProviderList.add(WorkInProgressPreferencePage.this.fQuickDiffProviderListModel[j][1], j);
                    }
                    if (i == j) {
                        WorkInProgressPreferencePage.this.fQuickDiffProviderList.remove(j);
                        WorkInProgressPreferencePage.this.fQuickDiffProviderList.add(String.valueOf(WorkInProgressPreferencePage.this.fQuickDiffProviderListModel[j][1]) + " " + PreferencesMessages.getString("WorkInProgress.quickdiff.defaultlabel"), j);
                    }
                    ++j;
                }
                WorkInProgressPreferencePage.this.fSetDefaultButton.setEnabled(false);
                WorkInProgressPreferencePage.this.fQuickDiffProviderList.setSelection(i);
                WorkInProgressPreferencePage.this.fQuickDiffProviderList.redraw();
                WorkInProgressPreferencePage.this.getPreferenceStore().setValue("quickdiff.defaultProvider", WorkInProgressPreferencePage.this.fQuickDiffProviderListModel[i][0]);
            }
        });
        int i = 0;
        while (i < this.fQuickDiffProviderListModel.length) {
            String sLabel = this.fQuickDiffProviderListModel[i][1];
            if (this.getPreferenceStore().getString("quickdiff.defaultProvider").equals(this.fQuickDiffProviderListModel[i][0])) {
                sLabel = String.valueOf(sLabel) + " " + PreferencesMessages.getString("WorkInProgress.quickdiff.defaultlabel");
            }
            this.fQuickDiffProviderList.add(sLabel);
            ++i;
        }
        this.fQuickDiffProviderList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (WorkInProgressPreferencePage.this.fQuickDiffProviderList != null && !WorkInProgressPreferencePage.this.fQuickDiffProviderList.isDisposed()) {
                    WorkInProgressPreferencePage.this.fQuickDiffProviderList.select(0);
                    WorkInProgressPreferencePage.this.handleProviderListSelection();
                }
            }
        });
        group = new Group(result, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(PreferencesMessages.getString("WorkInProgress.quickassist.group"));
        button = this.addCheckBox((Composite)group, PreferencesMessages.getString("WorkInProgress.quickassist.option"), "org.eclipse.jdt.quickassist.lightbulb");
        group = new Group(result, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(PreferencesMessages.getString("WorkInProgress.formatter"));
        button = this.addCheckBox((Composite)group, PreferencesMessages.getString("WorkInProgress.formatter.option"), PREF_FORMATTER);
        group = new Group(result, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(PreferencesMessages.getString("WorkInProgress.search"));
        button = this.addCheckBox((Composite)group, PreferencesMessages.getString("WorkInProgress.search.small_menu"), PREF_SEARCH_MENU);
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JavaPlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            button.setSelection(store.getDefaultBoolean(key));
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            String[] info = (String[])button.getData();
            button.setSelection(info[1].equals(store.getDefaultString(info[0])));
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            text.setText(store.getDefaultString(key));
            ++i;
        }
        this.handleProviderListSelection();
        super.performDefaults();
    }

    public boolean performOk() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            store.setValue(key, button.getSelection());
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            if (button.getSelection()) {
                String[] info = (String[])button.getData();
                store.setValue(info[0], info[1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            store.setValue(key, text.getText());
            ++i;
        }
        JavaPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("smart_semicolon", false);
        store.setDefault("smart_opening_brace", false);
        store.setDefault("org.eclipse.jdt.quickassist.lightbulb", false);
        store.setDefault(PREF_FORMATTER, false);
        store.setDefault(PREF_SEARCH_MENU, true);
        store.setDefault("markOccurrences", false);
    }
}

