/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class TypeFilterInputDialog
extends StatusDialog {
    private StringButtonDialogField fNameDialogField;
    private List fExistingEntries;

    public TypeFilterInputDialog(Shell parent, List existingEntries) {
        super(parent);
        this.fExistingEntries = existingEntries;
        this.setTitle(PreferencesMessages.getString("TypeFilterInputDialog.title"));
        ImportOrganizeInputAdapter adapter = new ImportOrganizeInputAdapter();
        this.fNameDialogField = new StringButtonDialogField(adapter);
        this.fNameDialogField.setLabelText(PreferencesMessages.getString("TypeFilterInputDialog.message"));
        this.fNameDialogField.setButtonLabel(PreferencesMessages.getString("TypeFilterInputDialog.browse.button"));
        this.fNameDialogField.setDialogFieldListener(adapter);
        this.fNameDialogField.setText("");
    }

    public void setInitialString(String input) {
        Assert.isNotNull((Object)input);
        this.fNameDialogField.setText(input);
    }

    public Object getResult() {
        return this.fNameDialogField.getText();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fNameDialogField}, true, 0, 0);
        int fieldWidthHint = this.convertWidthInCharsToPixels(60);
        LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), fieldWidthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doButtonPressed() {
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        int flags = 7;
        PackageSelectionDialog dialog = new PackageSelectionDialog(this.getShell(), context, flags, scope);
        dialog.setTitle(PreferencesMessages.getString("TypeFilterInputDialog.choosepackage.label"));
        dialog.setMessage(PreferencesMessages.getString("TypeFilterInputDialog.choosepackage.description"));
        dialog.setMultipleSelection(false);
        dialog.setFilter(this.fNameDialogField.getText());
        if (dialog.open() == 0) {
            PackageFragment res = (PackageFragment)dialog.getFirstResult();
            this.fNameDialogField.setText(String.valueOf(res.getElementName()) + ".*");
        }
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fNameDialogField.getText();
        if (newText.length() == 0) {
            status.setError(PreferencesMessages.getString("TypeFilterInputDialog.error.enterName"));
        } else {
            IStatus val = JavaConventions.validatePackageName((String)(newText = newText.replace('*', 'X').replace('?', 'Y')));
            if (val.matches(4)) {
                status.setError(PreferencesMessages.getFormattedString("TypeFilterInputDialog.error.invalidName", val.getMessage()));
            } else if (this.fExistingEntries.contains(newText)) {
                status.setError(PreferencesMessages.getString("TypeFilterInputDialog.error.entryExists"));
            }
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.import_organize_input_dialog_context");
    }

    private class ImportOrganizeInputAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        ImportOrganizeInputAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            TypeFilterInputDialog.this.doValidation();
        }

        public void changeControlPressed(DialogField field) {
            TypeFilterInputDialog.this.doButtonPressed();
        }
    }
}

