/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.template.TemplateVariable;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.template.TemplateVariableProcessor;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.ITextEditor;

public class TemplateEditorSourceViewerConfiguration
extends JavaSourceViewerConfiguration {
    private final TemplateVariableProcessor fProcessor;

    public TemplateEditorSourceViewerConfiguration(JavaTextTools tools, ITextEditor editor, TemplateVariableProcessor processor) {
        super(tools, editor, "___java_partitioning");
        this.fProcessor = processor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IColorManager manager = textTools.getColorManager();
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__java_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__java_character");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__java_singleline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__java_multiline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__java_javadoc");
        assistant.enableAutoInsert(store.getBoolean("content_assist_autoinsert"));
        assistant.enableAutoActivation(store.getBoolean("content_assist_autoactivation"));
        assistant.setAutoActivationDelay(store.getInt("content_assist_autoactivation_delay"));
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        Color background = this.getColor(store, "content_assist_proposals_background", manager);
        assistant.setContextInformationPopupBackground(background);
        assistant.setContextSelectorBackground(background);
        assistant.setProposalSelectorBackground(background);
        Color foreground = this.getColor(store, "content_assist_proposals_foreground", manager);
        assistant.setContextInformationPopupForeground(foreground);
        assistant.setContextSelectorForeground(foreground);
        assistant.setProposalSelectorForeground(foreground);
        return assistant;
    }

    private Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return new TemplateVariableTextHover(this.fProcessor);
    }

    private static class TemplateVariableTextHover
    implements ITextHover {
        private TemplateVariableProcessor fProcessor;

        public TemplateVariableTextHover(TemplateVariableProcessor processor) {
            this.fProcessor = processor;
        }

        public String getHoverInfo(ITextViewer textViewer, IRegion subject) {
            try {
                IDocument doc = textViewer.getDocument();
                int offset = subject.getOffset();
                if (offset >= 2 && "${".equals(doc.get(offset - 2, 2))) {
                    String varName = doc.get(offset, subject.getLength());
                    Iterator iter = this.fProcessor.getContextType().variableIterator();
                    while (iter.hasNext()) {
                        TemplateVariable var = (TemplateVariable)iter.next();
                        if (!varName.equals(var.getName())) continue;
                        return var.getDescription();
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
            return null;
        }

        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            if (textViewer != null) {
                return JavaWordFinder.findWord(textViewer.getDocument(), offset);
            }
            return null;
        }
    }
}

