/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.StringTokenizer;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class MembersOrderPreferenceCache
implements IPropertyChangeListener {
    public static final int TYPE_INDEX = 0;
    public static final int CONSTRUCTORS_INDEX = 1;
    public static final int METHOD_INDEX = 2;
    public static final int FIELDS_INDEX = 3;
    public static final int INIT_INDEX = 4;
    public static final int STATIC_FIELDS_INDEX = 5;
    public static final int STATIC_INIT_INDEX = 6;
    public static final int STATIC_METHODS_INDEX = 7;
    public static final int N_ENTRIES = 8;
    private int[] fOffsets = null;

    public void propertyChange(PropertyChangeEvent event) {
        if ("outlinesortoption".equals(event.getProperty())) {
            this.fOffsets = null;
        }
    }

    public int getIndex(int kind) {
        if (this.fOffsets == null) {
            this.fOffsets = this.getOffsets();
        }
        return this.fOffsets[kind];
    }

    private int[] getOffsets() {
        String key;
        int[] offsets = new int[8];
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean success = this.fillOffsetsFromPreferenceString(store.getString(key = "outlinesortoption"), offsets);
        if (!success) {
            store.setToDefault(key);
            this.fillOffsetsFromPreferenceString(store.getDefaultString(key), offsets);
        }
        return offsets;
    }

    private boolean fillOffsetsFromPreferenceString(String str, int[] offsets) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if ("T".equals(token)) {
                offsets[0] = i++;
                continue;
            }
            if ("M".equals(token)) {
                offsets[2] = i++;
                continue;
            }
            if ("F".equals(token)) {
                offsets[3] = i++;
                continue;
            }
            if ("I".equals(token)) {
                offsets[4] = i++;
                continue;
            }
            if ("SF".equals(token)) {
                offsets[5] = i++;
                continue;
            }
            if ("SI".equals(token)) {
                offsets[6] = i++;
                continue;
            }
            if ("SM".equals(token)) {
                offsets[7] = i++;
                continue;
            }
            if (!"C".equals(token)) continue;
            offsets[1] = i++;
        }
        return i == 8;
    }
}

