/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavadocPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.jdt.ui.preferences.JavadocPreferencePage";
    private StringButtonDialogField fJavadocSelection;
    private Composite fComposite;
    private static final String PREF_JAVADOC_COMMAND = "command";

    public static String getJavaDocCommand() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        String cmd = store.getString(PREF_JAVADOC_COMMAND);
        if (cmd.length() == 0 && store.getDefaultString(PREF_JAVADOC_COMMAND).length() == 0) {
            JavadocPreferencePage.initJavadocCommandDefault(store);
            cmd = store.getString(PREF_JAVADOC_COMMAND);
        }
        return cmd;
    }

    public JavadocPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setTitle(PreferencesMessages.getString("JavadocPreferencePage.title"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.javadoc_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)layout);
        DialogField javaDocCommentLabel = new DialogField();
        javaDocCommentLabel.setLabelText(PreferencesMessages.getString("JavadocPreferencePage.description"));
        javaDocCommentLabel.doFillIntoGrid(this.fComposite, 3);
        LayoutUtil.setWidthHint((Control)javaDocCommentLabel.getLabelControl(null), this.convertWidthInCharsToPixels(80));
        JDocDialogFieldAdapter adapter = new JDocDialogFieldAdapter();
        this.fJavadocSelection = new StringButtonDialogField(adapter);
        this.fJavadocSelection.setDialogFieldListener(adapter);
        this.fJavadocSelection.setLabelText(PreferencesMessages.getString("JavadocPreferencePage.command.label"));
        this.fJavadocSelection.setButtonLabel(PreferencesMessages.getString("JavadocPreferencePage.command.button"));
        this.fJavadocSelection.doFillIntoGrid(this.fComposite, 3);
        LayoutUtil.setHorizontalGrabbing((Control)this.fJavadocSelection.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fJavadocSelection.getTextControl(null), this.convertWidthInCharsToPixels(10));
        this.initFields();
        Dialog.applyDialogFont((Control)this.fComposite);
        return this.fComposite;
    }

    public void init(IWorkbench workbench) {
    }

    private static void initJavadocCommandDefault(IPreferenceStore store) {
        File file = JavadocPreferencePage.findJavaDocCommand();
        if (file != null) {
            store.setDefault(PREF_JAVADOC_COMMAND, file.getPath());
        }
    }

    private static File findJavaDocCommand() {
        File res;
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null && (res = JavadocPreferencePage.getCommand(install)) != null) {
            return res;
        }
        IVMInstallType[] jreTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < jreTypes.length) {
            IVMInstallType jreType = jreTypes[i];
            IVMInstall[] installs = jreType.getVMInstalls();
            int k = 0;
            while (k < installs.length) {
                File res2 = JavadocPreferencePage.getCommand(installs[i]);
                if (res2 != null) {
                    return res2;
                }
                ++k;
            }
            ++i;
        }
        return null;
    }

    private static File getCommand(IVMInstall install) {
        File installLocation = install.getInstallLocation();
        if (installLocation != null) {
            File javaDocCommand = new File(installLocation, "bin/javadoc");
            if (javaDocCommand.isFile()) {
                return javaDocCommand;
            }
            javaDocCommand = new File(installLocation, "bin/javadoc.exe");
            if (javaDocCommand.isFile()) {
                return javaDocCommand;
            }
        }
        return null;
    }

    private void initFields() {
        this.fJavadocSelection.setTextWithoutUpdate(JavadocPreferencePage.getJavaDocCommand());
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue(PREF_JAVADOC_COMMAND, this.fJavadocSelection.getText());
        JavaPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        JavadocPreferencePage.initJavadocCommandDefault(store);
        this.fJavadocSelection.setText(store.getDefaultString(PREF_JAVADOC_COMMAND));
        super.performDefaults();
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String text = this.fJavadocSelection.getText();
        if (text.length() > 0) {
            File file = new File(text);
            if (!file.isFile()) {
                status.setError(PreferencesMessages.getString("JavadocPreferencePage.error.notexists"));
            }
        } else {
            status.setInfo(PreferencesMessages.getString("JavadocPreferencePage.info.notset"));
        }
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    protected void handleFileBrowseButtonPressed(Text text, String[] extensions, String title) {
        String selectedDirectory;
        File path;
        FileDialog dialog = new FileDialog(text.getShell());
        dialog.setText(title);
        dialog.setFilterExtensions(extensions);
        String dirName = text.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            text.setText(selectedDirectory);
        }
    }

    private class JDocDialogFieldAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        JDocDialogFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            JavadocPreferencePage.this.doValidation();
        }

        public void changeControlPressed(DialogField field) {
            JavadocPreferencePage.this.handleFileBrowseButtonPressed(JavadocPreferencePage.this.fJavadocSelection.getTextControl(JavadocPreferencePage.this.fComposite), null, PreferencesMessages.getString("JavadocPreferencePage.browsedialog.title"));
        }
    }
}

