/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class JavadocConfigurationBlock {
    private static final String FILE_IMPORT_MASK = "*.jar;*.zip";
    private static final String ERROR_DIALOG_TITLE = "Error Dialog";
    private StringDialogField fURLField;
    private StringDialogField fArchiveField;
    private StringDialogField fArchivePathField;
    private URL fInitialURL;
    private SelectionButtonDialogField fValidateURLButton;
    private SelectionButtonDialogField fValidateArchiveButton;
    private SelectionButtonDialogField fBrowseFolder;
    private SelectionButtonDialogField fURLRadioButton;
    private SelectionButtonDialogField fArchiveRadioButton;
    private SelectionButtonDialogField fBrowseArchive;
    private SelectionButtonDialogField fBrowseArchivePath;
    private Shell fShell;
    private IStatusChangeListener fContext;
    private IStatus fURLStatus;
    private IStatus fArchiveStatus;
    private IStatus fArchivePathStatus;
    private URL fURLResult;
    private URL fArchiveURLResult;
    boolean fIsForSource;

    public JavadocConfigurationBlock(Shell shell, IStatusChangeListener context, URL initURL, boolean forSource) {
        this.fShell = shell;
        this.fContext = context;
        this.fInitialURL = initURL;
        this.fIsForSource = forSource;
        JDocConfigurationAdapter adapter = new JDocConfigurationAdapter();
        if (!forSource) {
            this.fURLRadioButton = new SelectionButtonDialogField(16);
            this.fURLRadioButton.setDialogFieldListener(adapter);
            this.fURLRadioButton.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.location.type.path.label"));
        }
        this.fURLField = new StringDialogField();
        this.fURLField.setDialogFieldListener(adapter);
        this.fURLField.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.location.path.label"));
        this.fBrowseFolder = new SelectionButtonDialogField(8);
        this.fBrowseFolder.setDialogFieldListener(adapter);
        this.fBrowseFolder.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.browse.button"));
        this.fValidateURLButton = new SelectionButtonDialogField(8);
        this.fValidateURLButton.setDialogFieldListener(adapter);
        this.fValidateURLButton.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.validate.button"));
        if (!forSource) {
            this.fArchiveRadioButton = new SelectionButtonDialogField(16);
            this.fArchiveRadioButton.setDialogFieldListener(adapter);
            this.fArchiveRadioButton.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.location.type.jar.label"));
            this.fArchiveField = new StringDialogField();
            this.fArchiveField.setDialogFieldListener(adapter);
            this.fArchiveField.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.location.jar.label"));
            this.fBrowseArchive = new SelectionButtonDialogField(8);
            this.fBrowseArchive.setDialogFieldListener(adapter);
            this.fBrowseArchive.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.browse.button"));
            this.fArchivePathField = new StringDialogField();
            this.fArchivePathField.setDialogFieldListener(adapter);
            this.fArchivePathField.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.jar.path.label"));
            this.fBrowseArchivePath = new SelectionButtonDialogField(8);
            this.fBrowseArchivePath.setDialogFieldListener(adapter);
            this.fBrowseArchivePath.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.browse.button"));
            this.fValidateArchiveButton = new SelectionButtonDialogField(8);
            this.fValidateArchiveButton.setDialogFieldListener(adapter);
            this.fValidateArchiveButton.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.validate.button"));
        }
        this.fURLStatus = new StatusInfo();
        this.fArchiveStatus = new StatusInfo();
        this.fArchivePathStatus = new StatusInfo();
        this.initializeSelections();
    }

    public Control createContents(Composite parent) {
        this.fShell = parent.getShell();
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite topComp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        topComp.setLayout((Layout)topLayout);
        if (!this.fIsForSource) {
            this.fURLRadioButton.doFillIntoGrid(topComp, 3);
        }
        this.fURLField.doFillIntoGrid(topComp, 2);
        LayoutUtil.setWidthHint((Control)this.fURLField.getTextControl(null), converter.convertWidthInCharsToPixels(50));
        LayoutUtil.setHorizontalGrabbing((Control)this.fURLField.getTextControl(null));
        this.fBrowseFolder.doFillIntoGrid(topComp, 1);
        DialogField.createEmptySpace(topComp, 2);
        this.fValidateURLButton.doFillIntoGrid(topComp, 1);
        if (!this.fIsForSource) {
            this.fArchiveRadioButton.doFillIntoGrid(topComp, 3);
            this.fArchiveField.doFillIntoGrid(topComp, 2);
            LayoutUtil.setWidthHint((Control)this.fArchiveField.getTextControl(null), converter.convertWidthInCharsToPixels(50));
            LayoutUtil.setHorizontalGrabbing((Control)this.fArchiveField.getTextControl(null));
            this.fBrowseArchive.doFillIntoGrid(topComp, 1);
            this.fArchivePathField.doFillIntoGrid(topComp, 2);
            LayoutUtil.setWidthHint((Control)this.fArchivePathField.getTextControl(null), converter.convertWidthInCharsToPixels(50));
            LayoutUtil.setHorizontalGrabbing((Control)this.fArchivePathField.getTextControl(null));
            this.fBrowseArchivePath.doFillIntoGrid(topComp, 1);
            DialogField.createEmptySpace(topComp, 2);
            this.fValidateArchiveButton.doFillIntoGrid(topComp, 1);
            int indent = converter.convertWidthInCharsToPixels(2);
            LayoutUtil.setHorizontalIndent((Control)this.fArchiveField.getLabelControl(null), indent);
            LayoutUtil.setHorizontalIndent((Control)this.fArchivePathField.getLabelControl(null), indent);
            LayoutUtil.setHorizontalIndent((Control)this.fURLField.getLabelControl(null), indent);
            this.fURLRadioButton.attachDialogFields(new DialogField[]{this.fURLField, this.fBrowseFolder, this.fValidateURLButton});
            this.fArchiveRadioButton.attachDialogFields(new DialogField[]{this.fArchiveField, this.fBrowseArchive, this.fArchivePathField, this.fBrowseArchivePath, this.fValidateArchiveButton});
        }
        return topComp;
    }

    private void initializeSelections() {
        String initialValue;
        String string = initialValue = this.fInitialURL != null ? this.fInitialURL.toExternalForm() : "";
        if (this.fIsForSource) {
            this.fURLField.setText(initialValue);
            return;
        }
        String prefix = "jar:file:/";
        boolean isArchive = initialValue.startsWith(prefix);
        this.fURLRadioButton.setSelection(!isArchive);
        this.fArchiveRadioButton.setSelection(isArchive);
        if (isArchive) {
            String jarPath;
            String insidePath = "";
            int excIndex = initialValue.indexOf(33);
            if (excIndex == -1) {
                jarPath = initialValue.substring(prefix.length());
            } else {
                jarPath = initialValue.substring(prefix.length(), excIndex);
                insidePath = initialValue.substring(excIndex + 1);
                if (insidePath.length() > 0 && insidePath.charAt(0) == '/') {
                    insidePath = insidePath.substring(1);
                }
            }
            this.fArchivePathField.setText(insidePath);
            this.fArchiveField.setText(jarPath);
        } else {
            this.fURLField.setText(initialValue);
        }
    }

    public void setFocus() {
        this.fURLField.postSetFocusOnDialogField(this.fShell.getDisplay());
    }

    public void performDefaults() {
        this.initializeSelections();
    }

    public URL getJavadocLocation() {
        if (this.fIsForSource || this.fURLRadioButton.isSelected()) {
            return this.fURLResult;
        }
        return this.fArchiveURLResult;
    }

    private void jdocDialogFieldChanged(DialogField field) {
        if (field == this.fURLField) {
            this.fURLStatus = this.updateURLStatus();
            this.statusChanged();
        } else if (field == this.fArchiveField) {
            this.fArchiveStatus = this.updateArchiveStatus();
            this.statusChanged();
        } else if (field == this.fArchivePathField) {
            this.fArchivePathStatus = this.updateArchivePathStatus();
            this.statusChanged();
        } else if (field == this.fValidateURLButton || field == this.fValidateArchiveButton) {
            EntryValidator validator = new EntryValidator();
            BusyIndicator.showWhile((Display)this.fShell.getDisplay(), (Runnable)validator);
        } else if (field == this.fBrowseFolder) {
            String url = this.chooseJavaDocFolder();
            if (url != null) {
                this.fURLField.setText(url);
            }
        } else if (field == this.fBrowseArchive) {
            String jarPath = this.chooseArchive();
            if (jarPath != null) {
                this.fArchiveField.setText(jarPath);
            }
        } else if (field == this.fBrowseArchivePath) {
            String archivePath = this.chooseArchivePath();
            if (archivePath != null) {
                this.fArchivePathField.setText(archivePath);
            }
        } else if (field == this.fURLRadioButton || field == this.fArchiveRadioButton) {
            this.statusChanged();
        }
    }

    private void statusChanged() {
        boolean isURL = this.fIsForSource || this.fURLRadioButton.isSelected();
        IStatus status = isURL ? this.fURLStatus : StatusUtil.getMoreSevere(this.fArchiveStatus, this.fArchivePathStatus);
        if (!this.fIsForSource) {
            this.fBrowseArchivePath.setEnabled(!isURL && this.fArchiveStatus.isOK() && this.fArchiveField.getText().length() > 0);
        }
        this.fContext.statusChanged(status);
    }

    private String chooseArchivePath() {
        final String[] res = new String[1];
        BusyIndicator.showWhile((Display)this.fShell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                res[0] = JavadocConfigurationBlock.this.internalChooseArchivePath();
            }
        });
        return res[0];
    }

    /*
     * Exception decompiling
     */
    private String internalChooseArchivePath() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [3 : 244->247)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String chooseArchive() {
        FileDialog dialog = new FileDialog(this.fShell, 4096);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        dialog.setText(PreferencesMessages.getString("JavadocConfigurationBlock.zipImportSource.title"));
        String currentSourceString = this.fArchiveField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.fShell, (String)ERROR_DIALOG_TITLE, (String)message);
    }

    private String chooseJavaDocFolder() {
        String initPath = "";
        if (this.fURLResult != null && "file".equals(this.fURLResult.getProtocol())) {
            initPath = new File(this.fURLResult.getFile()).getPath();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.fShell);
        dialog.setText(PreferencesMessages.getString("JavadocConfigurationBlock.javadocFolderDialog.label"));
        dialog.setMessage(PreferencesMessages.getString("JavadocConfigurationBlock.javadocFolderDialog.message"));
        dialog.setFilterPath(initPath);
        String result = dialog.open();
        if (result != null) {
            try {
                URL url = new File(result).toURL();
                return url.toExternalForm();
            }
            catch (MalformedURLException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    private IStatus updateURLStatus() {
        StatusInfo status = new StatusInfo();
        this.fURLResult = null;
        try {
            String jdocLocation = this.fURLField.getText();
            if (jdocLocation.length() == 0) {
                return status;
            }
            if (jdocLocation.length() > 0) {
                URL url = new URL(jdocLocation);
                if ("file".equals(url.getProtocol())) {
                    if (url.getFile() == null) {
                        status.setError(PreferencesMessages.getString("JavadocConfigurationBlock.error.notafolder"));
                        return status;
                    }
                    File dir = new File(url.getFile());
                    if (!dir.isDirectory()) {
                        status.setError(PreferencesMessages.getString("JavadocConfigurationBlock.error.notafolder"));
                        return status;
                    }
                    File packagesFile = new File(dir, "package-list");
                    if (!packagesFile.exists()) {
                        status.setWarning(PreferencesMessages.getString("JavadocConfigurationBlock.warning.packagelistnotfound"));
                    }
                }
                this.fURLResult = url;
            }
        }
        catch (MalformedURLException malformedURLException) {
            status.setError(PreferencesMessages.getString("JavadocConfigurationBlock.MalformedURL.error"));
            return status;
        }
        return status;
    }

    private IStatus updateArchiveStatus() {
        try {
            this.fArchiveURLResult = null;
            StatusInfo status = new StatusInfo();
            String jdocLocation = this.fArchiveField.getText();
            if (jdocLocation.length() > 0) {
                File jarFile = new File(jdocLocation);
                if (jarFile.isDirectory()) {
                    status.setError(PreferencesMessages.getString("JavadocConfigurationBlock.error.notafile"));
                    return status;
                }
                if (!jarFile.exists()) {
                    status.setError(PreferencesMessages.getString("JavadocConfigurationBlock.error.notafile"));
                    return status;
                }
                this.fArchiveURLResult = this.getArchiveURL();
            }
            return status;
        }
        catch (MalformedURLException e) {
            StatusInfo status = new StatusInfo();
            status.setError(e.getMessage());
            return status;
        }
    }

    private IStatus updateArchivePathStatus() {
        try {
            this.fArchiveURLResult = this.getArchiveURL();
        }
        catch (MalformedURLException e) {
            this.fArchiveURLResult = null;
            StatusInfo status = new StatusInfo();
            status.setError(e.getMessage());
            return status;
        }
        return new StatusInfo();
    }

    private URL getArchiveURL() throws MalformedURLException {
        String jarLoc = this.fArchiveField.getText();
        String innerPath = this.fArchivePathField.getText().trim();
        StringBuffer buf = new StringBuffer();
        buf.append("jar:");
        buf.append(new File(jarLoc).toURL().toExternalForm());
        buf.append('!');
        if (innerPath.length() > 0) {
            if (innerPath.charAt(0) != '/') {
                buf.append('/');
            }
            buf.append(innerPath);
        } else {
            buf.append('/');
        }
        return new URL(buf.toString());
    }

    private class EntryValidator
    implements Runnable {
        private String fInvalidMessage = PreferencesMessages.getString("JavadocConfigurationBlock.InvalidLocation.message");
        private String fValidMessage = PreferencesMessages.getString("JavadocConfigurationBlock.ValidLocation.message");
        private String fTitle = PreferencesMessages.getString("JavadocConfigurationBlock.MessageDialog.title");
        private String fUnable = PreferencesMessages.getString("JavadocConfigurationBlock.UnableToValidateLocation.message");

        EntryValidator() {
        }

        public void run() {
            URL location = JavadocConfigurationBlock.this.getJavadocLocation();
            if (location == null) {
                MessageDialog.openInformation((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
                return;
            }
            try {
                String protocol = location.getProtocol();
                if (protocol.equals("http") || protocol.equals("jar")) {
                    this.validateURL(location);
                } else if (protocol.equals("file")) {
                    this.validateFile(location);
                } else {
                    MessageDialog.openInformation((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fUnable);
                }
            }
            catch (MalformedURLException malformedURLException) {
                MessageDialog.openInformation((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fUnable);
            }
        }

        public void spawnInBrowser(URL url) {
            OpenBrowserUtil.open(url, JavadocConfigurationBlock.this.fShell.getDisplay(), this.fTitle);
        }

        private void validateFile(URL location) throws MalformedURLException {
            File packageList;
            File indexFile;
            File folder = new File(location.getFile());
            if (folder.isDirectory() && (indexFile = new File(folder, "index.html")).isFile() && (packageList = new File(folder, "package-list")).exists()) {
                if (MessageDialog.openConfirm((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fValidMessage)) {
                    this.spawnInBrowser(indexFile.toURL());
                }
                return;
            }
            MessageDialog.openInformation((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void validateURL(URL location) throws MalformedURLException {
            InputStream in2;
            block14: {
                Path path = new Path(location.toExternalForm());
                IPath index = path.append("index.html");
                IPath packagelist = path.append("package-list");
                URL indexURL = new URL(index.toString());
                URL packagelistURL = new URL(packagelist.toString());
                InputStream in1 = null;
                in2 = null;
                try {
                    try {
                        in1 = indexURL.openConnection().getInputStream();
                        in2 = packagelistURL.openConnection().getInputStream();
                        if (MessageDialog.openConfirm((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fValidMessage)) {
                            this.spawnInBrowser(indexURL);
                        }
                    }
                    catch (IOException iOException) {
                        MessageDialog.openInformation((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (in1 != null) {
                        try {
                            in1.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (in2 == null) throw throwable;
                    try {
                        in2.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var9_11 = null;
                    if (in1 == null) break block14;
                }
                try {}
                catch (IOException iOException) {}
                in1.close();
            }
            if (in2 == null) return;
            try {}
            catch (IOException iOException) {
                return;
            }
            in2.close();
        }
    }

    private class JDocConfigurationAdapter
    implements IDialogFieldListener {
        JDocConfigurationAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            JavadocConfigurationBlock.this.jdocDialogFieldChanged(field);
        }
    }

    private static class ZipDialogContentProvider
    implements ITreeContentProvider {
        private ZipFileStructureProvider fProvider;

        public ZipDialogContentProvider(ZipFileStructureProvider provider) {
            this.fProvider = provider;
        }

        public Object findElement(IPath path) {
            String[] segments = path.segments();
            ZipEntry elem = this.fProvider.getRoot();
            int i = 0;
            while (i < segments.length && elem != null) {
                List list = this.fProvider.getChildren((Object)elem);
                String name = segments[i];
                elem = null;
                int k = 0;
                while (k < list.size()) {
                    Object curr = list.get(k);
                    if (this.fProvider.isFolder(curr) && name.equals(this.fProvider.getLabel(curr))) {
                        elem = curr;
                        break;
                    }
                    ++k;
                }
                ++i;
            }
            return elem;
        }

        private Object recursiveFind(Object element, String name) {
            if (name.equals(this.fProvider.getLabel(element))) {
                return element;
            }
            List list = this.fProvider.getChildren(element);
            if (list != null) {
                int k = 0;
                while (k < list.size()) {
                    Object res = this.recursiveFind(list.get(k), name);
                    if (res != null) {
                        return res;
                    }
                    ++k;
                }
            }
            return null;
        }

        public Object findFileByName(String name) {
            return this.recursiveFind(this.fProvider.getRoot(), name);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            if (element.equals(this.fProvider.getRoot())) {
                return null;
            }
            Path path = new Path(this.fProvider.getFullPath(element));
            if (path.segmentCount() > 0) {
                return this.findElement(path.removeLastSegments(1));
            }
            return this.fProvider.getRoot();
        }

        public boolean hasChildren(Object element) {
            List list = this.fProvider.getChildren(element);
            if (list != null) {
                int i = 0;
                while (i < list.size()) {
                    if (this.fProvider.isFolder(list.get(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public Object[] getChildren(Object element) {
            List list = this.fProvider.getChildren(element);
            ArrayList res = new ArrayList();
            if (list != null) {
                int i = 0;
                while (i < list.size()) {
                    Object curr = list.get(i);
                    if (this.fProvider.isFolder(curr)) {
                        res.add(curr);
                    }
                    ++i;
                }
            }
            return res.toArray();
        }

        public Object[] getElements(Object element) {
            return new Object[]{this.fProvider.getRoot()};
        }

        public void dispose() {
        }
    }

    private static class ZipDialogLabelProvider
    extends LabelProvider {
        private final Image IMG_JAR = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_obj.gif");
        private final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private ZipFileStructureProvider fProvider;

        public ZipDialogLabelProvider(ZipFileStructureProvider provider) {
            this.fProvider = provider;
        }

        public Image getImage(Object element) {
            if (element == this.fProvider.getRoot()) {
                return this.IMG_JAR;
            }
            return this.IMG_FOLDER;
        }

        public String getText(Object element) {
            if (element == this.fProvider.getRoot()) {
                return this.fProvider.getZipFile().getName();
            }
            return this.fProvider.getLabel(element);
        }
    }

    private static class ZipDialogValidator
    implements ISelectionStatusValidator {
        public IStatus validate(Object[] selection) {
            String message = "";
            return new StatusInfo(1, message);
        }
    }
}

