/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaBasePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String OPEN_TYPE_HIERARCHY = "org.eclipse.jdt.ui.openTypeHierarchy";
    private static final String OPEN_TYPE_HIERARCHY_IN_PERSPECTIVE = "perspective";
    private static final String OPEN_TYPE_HIERARCHY_IN_VIEW_PART = "viewPart";
    private static final String DOUBLE_CLICK = "packageview.doubleclick";
    private static final String DOUBLE_CLICK_GOES_INTO = "packageview.gointo";
    private static final String DOUBLE_CLICK_EXPANDS = "packageview.doubleclick.expands";
    private static final String UPDATE_JAVA_VIEWS = "JavaUI.update";
    private static final String UPDATE_ON_SAVE = "JavaUI.update.onSave";
    private static final String UPDATE_WHILE_EDITING = "JavaUI.update.whileEditing";
    private ArrayList fCheckBoxes;
    private ArrayList fRadioButtons;
    private ArrayList fTextControls;

    public JavaBasePreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.getString("JavaBasePreferencePage.description"));
        this.fRadioButtons = new ArrayList();
        this.fCheckBoxes = new ArrayList();
        this.fTextControls = new ArrayList();
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.java_base_preference_page_context");
    }

    private Button addRadioButton(Composite parent, String label, String key, String value) {
        GridData gd = new GridData(256);
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, value});
        button.setLayoutData((Object)gd);
        button.setSelection(value.equals(this.getPreferenceStore().getString(key)));
        this.fRadioButtons.add(button);
        return button;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        Group updateGroup = new Group(result, 0);
        updateGroup.setLayout((Layout)new GridLayout());
        updateGroup.setLayoutData((Object)new GridData(768));
        updateGroup.setText(PreferencesMessages.getString("JavaBasePreferencePage.updateJavaViews"));
        this.addRadioButton((Composite)updateGroup, PreferencesMessages.getString("JavaBasePreferencePage.onSave"), UPDATE_JAVA_VIEWS, UPDATE_ON_SAVE);
        this.addRadioButton((Composite)updateGroup, PreferencesMessages.getString("JavaBasePreferencePage.whileEditing"), UPDATE_JAVA_VIEWS, UPDATE_WHILE_EDITING);
        String noteTitle = PreferencesMessages.getString("JavaBasePreferencePage.note");
        String noteMessage = PreferencesMessages.getString("JavaBasePreferencePage.notice.outliner");
        Composite noteControl = this.createNoteComposite(JFaceResources.getDialogFont(), (Composite)updateGroup, noteTitle, noteMessage);
        GridData gd = new GridData(768);
        noteControl.setLayoutData((Object)gd);
        Group doubleClickGroup = new Group(result, 0);
        doubleClickGroup.setLayout((Layout)new GridLayout());
        doubleClickGroup.setLayoutData((Object)new GridData(768));
        doubleClickGroup.setText(PreferencesMessages.getString("JavaBasePreferencePage.doubleclick.action"));
        this.addRadioButton((Composite)doubleClickGroup, PreferencesMessages.getString("JavaBasePreferencePage.doubleclick.gointo"), DOUBLE_CLICK, DOUBLE_CLICK_GOES_INTO);
        this.addRadioButton((Composite)doubleClickGroup, PreferencesMessages.getString("JavaBasePreferencePage.doubleclick.expand"), DOUBLE_CLICK, DOUBLE_CLICK_EXPANDS);
        Group typeHierarchyGroup = new Group(result, 0);
        typeHierarchyGroup.setLayout((Layout)new GridLayout());
        typeHierarchyGroup.setLayoutData((Object)new GridData(768));
        typeHierarchyGroup.setText(PreferencesMessages.getString("JavaBasePreferencePage.openTypeHierarchy"));
        this.addRadioButton((Composite)typeHierarchyGroup, PreferencesMessages.getString("JavaBasePreferencePage.inPerspective"), OPEN_TYPE_HIERARCHY, OPEN_TYPE_HIERARCHY_IN_PERSPECTIVE);
        this.addRadioButton((Composite)typeHierarchyGroup, PreferencesMessages.getString("JavaBasePreferencePage.inView"), OPEN_TYPE_HIERARCHY, OPEN_TYPE_HIERARCHY_IN_VIEW_PART);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void performDefaults() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            button.setSelection(store.getDefaultBoolean(key));
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            String[] info = (String[])button.getData();
            button.setSelection(info[1].equals(store.getDefaultString(info[0])));
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            text.setText(store.getDefaultString(key));
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            store.setValue(key, button.getSelection());
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            if (button.getSelection()) {
                String[] info = (String[])button.getData();
                store.setValue(info[0], info[1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            store.setValue(key, text.getText());
            ++i;
        }
        JavaPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }
}

