/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.template.CodeTemplates;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateSet;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.preferences.EditTemplateDialog;
import org.eclipse.jdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.TemplateEditorSourceViewerConfiguration;
import org.eclipse.jdt.internal.ui.text.template.TemplateVariableProcessor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CodeTemplateBlock {
    private static final int IDX_EDIT = 0;
    private static final int IDX_IMPORT = 2;
    private static final int IDX_EXPORT = 3;
    private static final int IDX_EXPORTALL = 4;
    protected static final Object COMMENT_NODE = PreferencesMessages.getString("CodeTemplateBlock.templates.comment.node");
    protected static final Object CODE_NODE = PreferencesMessages.getString("CodeTemplateBlock.templates.code.node");
    private static final String PREF_JAVADOC_STUBS = "org.eclipse.jdt.ui.javadoc";
    private TreeListDialogField fCodeTemplateTree;
    private SelectionButtonDialogField fCreateJavaDocComments;
    protected CodeTemplates fTemplates = CodeTemplates.getInstance();
    private PixelConverter fPixelConverter;
    private SourceViewer fPatternViewer;
    private Control fSWTWidget;
    private TemplateVariableProcessor fTemplateProcessor = new TemplateVariableProcessor();

    public CodeTemplateBlock() {
        CodeTemplateAdapter adapter = new CodeTemplateAdapter(this.fTemplates);
        String[] stringArray = new String[5];
        stringArray[0] = PreferencesMessages.getString("CodeTemplateBlock.templates.edit.button");
        stringArray[2] = PreferencesMessages.getString("CodeTemplateBlock.templates.import.button");
        stringArray[3] = PreferencesMessages.getString("CodeTemplateBlock.templates.export.button");
        stringArray[4] = PreferencesMessages.getString("CodeTemplateBlock.templates.exportall.button");
        String[] buttonLabels = stringArray;
        this.fCodeTemplateTree = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CodeTemplateLabelProvider());
        this.fCodeTemplateTree.setDialogFieldListener(adapter);
        this.fCodeTemplateTree.setLabelText(PreferencesMessages.getString("CodeTemplateBlock.templates.label"));
        this.fCodeTemplateTree.enableButton(3, false);
        this.fCodeTemplateTree.enableButton(0, false);
        this.fCodeTemplateTree.addElement(COMMENT_NODE);
        this.fCodeTemplateTree.addElement(CODE_NODE);
        this.fCreateJavaDocComments = new SelectionButtonDialogField(96);
        this.fCreateJavaDocComments.setLabelText(PreferencesMessages.getString("CodeTemplateBlock.createcomment.label"));
        this.fCreateJavaDocComments.setSelection(PreferenceConstants.getPreferenceStore().getBoolean(PREF_JAVADOC_STUBS));
        this.fCodeTemplateTree.selectFirstElement();
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fCodeTemplateTree.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fCodeTemplateTree.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fCodeTemplateTree.getTreeControl(null));
        this.fPatternViewer = this.createViewer(composite, 2);
        this.fCreateJavaDocComments.doFillIntoGrid(composite, 2);
        DialogField label = new DialogField();
        label.setLabelText(PreferencesMessages.getString("CodeTemplateBlock.createcomment.description"));
        label.doFillIntoGrid(composite, 2);
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private SourceViewer createViewer(Composite parent, int nColumns) {
        Label label = new Label(parent, 0);
        label.setText(PreferencesMessages.getString("CodeTemplateBlock.preview"));
        GridData data = new GridData();
        data.horizontalSpan = nColumns;
        label.setLayoutData((Object)data);
        JavaSourceViewer viewer = new JavaSourceViewer(parent, null, null, false, 2816);
        Document document = new Document();
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        viewer.configure(new TemplateEditorSourceViewerConfiguration(tools, null, this.fTemplateProcessor));
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater(viewer, tools);
        Control control = viewer.getControl();
        data = new GridData(1296);
        data.horizontalSpan = nColumns;
        data.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected Template[] getTemplateOfCategory(boolean isComment) {
        ArrayList<Template> res = new ArrayList<Template>();
        Template[] templates = this.fTemplates.getTemplates();
        int i = 0;
        while (i < templates.length) {
            Template curr = templates[i];
            if (isComment == curr.getName().endsWith("comment")) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new Template[res.size()]);
    }

    protected static boolean canEdit(List selected) {
        return selected.size() == 1 && selected.get(0) instanceof Template;
    }

    protected void updateSourceViewerInput(List selection) {
        if (this.fPatternViewer == null || this.fPatternViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (selection.size() == 1 && selection.get(0) instanceof Template) {
            Template template = (Template)selection.get(0);
            ContextType type = ContextTypeRegistry.getInstance().getContextType(template.getContextTypeName());
            this.fTemplateProcessor.setContextType(type);
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void doButtonPressed(int buttonIndex, List selected) {
        if (buttonIndex == 0) {
            this.edit((Template)selected.get(0));
        } else if (buttonIndex == 3) {
            this.export(selected);
        } else if (buttonIndex == 4) {
            this.exportAll();
        } else if (buttonIndex == 2) {
            this.import_();
        }
    }

    private void edit(Template template) {
        Template newTemplate = new Template(template);
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), newTemplate, true, false, new String[0]);
        if (dialog.open() == 0) {
            template.setDescription(newTemplate.getDescription());
            template.setPattern(newTemplate.getPattern());
            this.fCodeTemplateTree.refresh(template);
            this.fCodeTemplateTree.selectElements((ISelection)new StructuredSelection((Object)template));
        }
    }

    private void import_() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(PreferencesMessages.getString("CodeTemplateBlock.import.title"));
        dialog.setFilterExtensions(new String[]{PreferencesMessages.getString("CodeTemplateBlock.import.extension")});
        String path = dialog.open();
        if (path != null) {
            try {
                this.fTemplates.addFromFile(new File(path), false);
            }
            catch (CoreException e) {
                this.openReadErrorDialog(e);
            }
            this.fCodeTemplateTree.refresh();
        }
    }

    private void exportAll() {
        this.export(this.fTemplates);
    }

    private void export(List selected) {
        TemplateSet templateSet = new TemplateSet(this.fTemplates.getTemplateTag());
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof Template) {
                this.addToTemplateSet(templateSet, (Template)curr);
            } else {
                Template[] templates = this.getTemplateOfCategory(curr == COMMENT_NODE);
                int k = 0;
                while (k < templates.length) {
                    this.addToTemplateSet(templateSet, templates[k]);
                    ++k;
                }
            }
            ++i;
        }
        this.export(templateSet);
    }

    private void addToTemplateSet(TemplateSet set, Template template) {
        if (set.getFirstTemplate(template.getName()) == null) {
            set.add(template);
        }
    }

    private void export(TemplateSet templateSet) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(PreferencesMessages.getFormattedString("CodeTemplateBlock.export.title", String.valueOf(templateSet.getTemplates().length)));
        dialog.setFilterExtensions(new String[]{PreferencesMessages.getString("CodeTemplateBlock.export.extension")});
        dialog.setFileName(PreferencesMessages.getString("CodeTemplateBlock.export.filename"));
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            String title = PreferencesMessages.getString("CodeTemplateBlock.export.error.title");
            String message = PreferencesMessages.getFormattedString("CodeTemplateBlock.export.error.hidden", file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String title = PreferencesMessages.getString("CodeTemplateBlock.export.error.title");
            String message = PreferencesMessages.getFormattedString("CodeTemplateBlock.export.error.canNotWrite", file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            try {
                templateSet.saveToFile(file);
            }
            catch (CoreException e) {
                if (e.getStatus().getException() instanceof FileNotFoundException) {
                    String title = PreferencesMessages.getString("CodeTemplateBlock.export.error.title");
                    String message = PreferencesMessages.getFormattedString("CodeTemplateBlock.export.error.fileNotFound", e.getStatus().getException().getLocalizedMessage());
                    MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                    return;
                }
                JavaPlugin.log(e);
                this.openWriteErrorDialog(e);
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferencesMessages.getString("CodeTemplateBlock.export.exists.title"), (String)PreferencesMessages.getFormattedString("CodeTemplateBlock.export.exists.message", file.getAbsolutePath()));
    }

    public void performDefaults() {
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        this.fCreateJavaDocComments.setSelection(prefs.getDefaultBoolean(PREF_JAVADOC_STUBS));
        try {
            this.fTemplates.restoreDefaults();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            this.openReadErrorDialog(e);
        }
        this.fCodeTemplateTree.refresh();
    }

    public boolean performOk(boolean enabled) {
        IPreferenceStore prefs = PreferenceConstants.getPreferenceStore();
        prefs.setValue(PREF_JAVADOC_STUBS, this.fCreateJavaDocComments.isSelected());
        JavaPlugin.getDefault().savePluginPreferences();
        try {
            this.fTemplates.save();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            this.openWriteErrorDialog(e);
        }
        return true;
    }

    public void performCancel() {
        try {
            this.fTemplates.reset();
        }
        catch (CoreException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void openReadErrorDialog(CoreException e) {
        String title = PreferencesMessages.getString("CodeTemplateBlock.error.read.title");
        if (e.getStatus().getCode() == 10005) {
            String message = e.getStatus().getException().getLocalizedMessage();
            message = message != null ? PreferencesMessages.getFormattedString("CodeTemplateBlock.error.parse.message", message) : PreferencesMessages.getString("CodeTemplateBlock.error.read.message");
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else {
            String message = PreferencesMessages.getString("CodeTemplateBlock.error.read.message");
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
    }

    private void openWriteErrorDialog(CoreException e) {
        String title = PreferencesMessages.getString("CodeTemplateBlock.error.write.title");
        String message = PreferencesMessages.getString("CodeTemplateBlock.error.write.message");
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    private class CodeTemplateAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] NO_CHILDREN = new Object[0];

        public CodeTemplateAdapter(CodeTemplates templates) {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            CodeTemplateBlock.this.doButtonPressed(index, field.getSelectedElements());
        }

        public void selectionChanged(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            field.enableButton(0, CodeTemplateBlock.canEdit(selected));
            field.enableButton(3, !selected.isEmpty());
            CodeTemplateBlock.this.updateSourceViewerInput(selected);
        }

        public void doubleClicked(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            if (CodeTemplateBlock.canEdit(selected)) {
                CodeTemplateBlock.this.doButtonPressed(0, selected);
            }
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element == COMMENT_NODE || element == CODE_NODE) {
                return CodeTemplateBlock.this.getTemplateOfCategory(element == COMMENT_NODE);
            }
            return this.NO_CHILDREN;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof Template) {
                Template template = (Template)element;
                if (template.getName().endsWith("comment")) {
                    return COMMENT_NODE;
                }
                return CODE_NODE;
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element == COMMENT_NODE || element == CODE_NODE;
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }
    }

    private static class CodeTemplateLabelProvider
    extends LabelProvider {
        CodeTemplateLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element == COMMENT_NODE || element == CODE_NODE) {
                return (String)element;
            }
            Template template = (Template)element;
            String name = template.getName();
            if ("catchblock".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.catchblock.label");
            }
            if ("methodbody".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.methodstub.label");
            }
            if ("constructorbody".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.constructorstub.label");
            }
            if ("getterbody".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.getterstub.label");
            }
            if ("setterbody".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.setterstub.label");
            }
            if ("newtype".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.newtype.label");
            }
            if ("typecomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.typecomment.label");
            }
            if ("fieldcomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.fieldcomment.label");
            }
            if ("methodcomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.methodcomment.label");
            }
            if ("overridecomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.overridecomment.label");
            }
            if ("constructorcomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.constructorcomment.label");
            }
            if ("gettercomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.gettercomment.label");
            }
            if ("settercomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.settercomment.label");
            }
            return template.getDescription();
        }
    }
}

