/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.CodeFormatterConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.CodingStyleConfigurationBlock;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.PageBook;

public class CodeFormatterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IStatusChangeListener {
    private CodeFormatterConfigurationBlock fOldConfigurationBlock;
    private CodingStyleConfigurationBlock fNewConfigurationBlock;
    private PageBook fPagebook;
    private Control fControlNew;
    private Control fControlOld;

    public CodeFormatterPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.getString("CodeFormatterPreferencePage.description"));
        this.setTitle(PreferencesMessages.getString("CodeFormatterPreferencePage.title"));
        this.fOldConfigurationBlock = new CodeFormatterConfigurationBlock(this, null);
        this.fNewConfigurationBlock = new CodingStyleConfigurationBlock();
    }

    private boolean useNewFormatter() {
        return this.getPreferenceStore().getBoolean("use_new_formatter");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateVisibility();
        }
        super.setVisible(visible);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.codeformatter_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        this.fPagebook = new PageBook(parent, 0);
        this.fControlNew = this.fNewConfigurationBlock.createContents((Composite)this.fPagebook);
        this.fControlOld = this.fOldConfigurationBlock.createContents((Composite)this.fPagebook);
        this.updateVisibility();
        Dialog.applyDialogFont((Control)this.fControlNew);
        Dialog.applyDialogFont((Control)this.fControlOld);
        return this.fPagebook;
    }

    private void updateVisibility() {
        if (this.useNewFormatter()) {
            this.fPagebook.showPage(this.fControlNew);
        } else {
            this.fPagebook.showPage(this.fControlOld);
        }
    }

    public boolean performOk() {
        if (this.useNewFormatter()) {
            this.fNewConfigurationBlock.performOk();
            return true;
        }
        if (!this.fOldConfigurationBlock.performOk(true)) {
            return false;
        }
        return super.performOk();
    }

    protected void performDefaults() {
        if (!this.useNewFormatter()) {
            this.fOldConfigurationBlock.performDefaults();
        }
        super.performDefaults();
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }
}

