/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension2;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CodeFormatterConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String PREF_NEWLINE_OPENING_BRACES = "org.eclipse.jdt.core.formatter.newline.openingBrace";
    private static final String PREF_NEWLINE_CONTROL_STATEMENT = "org.eclipse.jdt.core.formatter.newline.controlStatement";
    private static final String PREF_NEWLINE_CLEAR_ALL = "org.eclipse.jdt.core.formatter.newline.clearAll";
    private static final String PREF_NEWLINE_ELSE_IF = "org.eclipse.jdt.core.formatter.newline.elseIf";
    private static final String PREF_NEWLINE_EMPTY_BLOCK = "org.eclipse.jdt.core.formatter.newline.emptyBlock";
    private static final String PREF_CODE_SPLIT = "org.eclipse.jdt.core.formatter.lineSplit";
    private static final String PREF_STYLE_COMPACT_ASSIGNEMENT = "org.eclipse.jdt.core.formatter.style.assignment";
    private static final String PREF_TAB_CHAR = "org.eclipse.jdt.core.formatter.tabulation.char";
    private static final String PREF_TAB_SIZE = "org.eclipse.jdt.core.formatter.tabulation.size";
    private static final String PREF_SPACE_CASTEXPRESSION = "org.eclipse.jdt.core.formatter.space.castexpression";
    private static final String PREF_COMMENT_FORMATSOURCE = "comment_format_source_code";
    private static final String PREF_COMMENT_INDENTPARAMDESC = "comment_indent_parameter_description";
    private static final String PREF_COMMENT_FORMATHEADER = "comment_format_header";
    private static final String PREF_COMMENT_INDENTROOTTAGS = "comment_indent_root_tags";
    private static final String PREF_COMMENT_FORMAT = "comment_format_comments";
    private static final String PREF_COMMENT_NEWLINEPARAM = "comment_new_line_for_parameter";
    private static final String PREF_COMMENT_SEPARATEROOTTAGS = "comment_separate_root_tags";
    private static final String PREF_COMMENT_CLEARBLANKLINES = "comment_clear_blank_lines";
    private static final String PREF_COMMENT_LINELENGTH = "comment_line_length";
    private static final String PREF_COMMENT_FORMATHTML = "comment_format_html";
    private static final String INSERT = "insert";
    private static final String DO_NOT_INSERT = "do not insert";
    private static final String COMPACT = "compact";
    private static final String NORMAL = "normal";
    private static final String TAB = "tab";
    private static final String SPACE = "space";
    private static final String CLEAR_ALL = "clear all";
    private static final String PRESERVE_ONE = "preserve one";
    private IDocument fPreviewDocument;
    private Text fTabSizeTextBox;
    private String fPreviewText;
    private SourceViewer fSourceViewer;
    private SourceViewerConfiguration fViewerConfiguration;
    private JavaTextTools fTextTools = JavaPlugin.getDefault().getJavaTextTools();
    private PixelConverter fPixelConverter;
    private IStatus fCodeLengthStatus;
    private IStatus fCommentLengthStatus;
    private IStatus fTabSizeStatus;

    public CodeFormatterConfigurationBlock(IStatusChangeListener context, IJavaProject project) {
        super(context, project);
        this.fViewerConfiguration = new JavaSourceViewerConfiguration(this.fTextTools, null, "___java_partitioning");
        this.fPreviewText = this.loadPreviewFile("CodeFormatterPreviewCode.txt");
        this.fPreviewDocument = new Document(this.fPreviewText);
        this.fTextTools.setupJavaDocumentPartitioner(this.fPreviewDocument, "___java_partitioning");
        this.fCodeLengthStatus = new StatusInfo();
        this.fCommentLengthStatus = new StatusInfo();
        this.fTabSizeStatus = new StatusInfo();
    }

    protected String[] getAllKeys() {
        return new String[]{PREF_NEWLINE_OPENING_BRACES, PREF_NEWLINE_CONTROL_STATEMENT, PREF_NEWLINE_CLEAR_ALL, PREF_NEWLINE_ELSE_IF, PREF_NEWLINE_EMPTY_BLOCK, PREF_CODE_SPLIT, PREF_STYLE_COMPACT_ASSIGNEMENT, PREF_TAB_CHAR, PREF_TAB_SIZE, PREF_SPACE_CASTEXPRESSION};
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        int textWidth = this.fPixelConverter.convertWidthInCharsToPixels(6);
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        String[] insertNotInsert = new String[]{INSERT, DO_NOT_INSERT};
        layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite newlineComposite = new Composite((Composite)folder, 0);
        newlineComposite.setLayout((Layout)layout);
        String label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_opening_braces.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_OPENING_BRACES, insertNotInsert, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_control_statement.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_CONTROL_STATEMENT, insertNotInsert, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_clear_lines");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_CLEAR_ALL, new String[]{CLEAR_ALL, PRESERVE_ONE}, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_else_if.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_ELSE_IF, insertNotInsert, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_empty_block.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_EMPTY_BLOCK, insertNotInsert, 0);
        layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite lineSplittingComposite = new Composite((Composite)folder, 0);
        lineSplittingComposite.setLayout((Layout)layout);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.split_code.label");
        this.addTextField(lineSplittingComposite, label, PREF_CODE_SPLIT, 0, textWidth);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.split_comment.label");
        this.addTextField(lineSplittingComposite, label, PREF_COMMENT_LINELENGTH, 0, textWidth);
        layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite styleComposite = new Composite((Composite)folder, 0);
        styleComposite.setLayout((Layout)layout);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.style_compact_assignement.label");
        this.addCheckBox(styleComposite, label, PREF_STYLE_COMPACT_ASSIGNEMENT, new String[]{COMPACT, NORMAL}, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.style_space_castexpression.label");
        this.addCheckBox(styleComposite, label, PREF_SPACE_CASTEXPRESSION, insertNotInsert, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.tab_char.label");
        this.addCheckBox(styleComposite, label, PREF_TAB_CHAR, new String[]{TAB, SPACE}, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.tab_size.label");
        this.fTabSizeTextBox = this.addTextField(styleComposite, label, PREF_TAB_SIZE, 0, textWidth);
        this.fTabSizeTextBox.setTextLimit(3);
        layout = new GridLayout();
        layout.numColumns = 1;
        Composite commentComposite = new Composite((Composite)folder, 0);
        commentComposite.setLayout((Layout)layout);
        String[] trueFalse = new String[]{"true", "false"};
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.comment_format.label");
        Button master = this.addCheckBox(commentComposite, label, PREF_COMMENT_FORMAT, trueFalse, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.comment_formatheader.label");
        Button slave = this.addCheckBox(commentComposite, label, PREF_COMMENT_FORMATHEADER, trueFalse, 20);
        CodeFormatterConfigurationBlock.createSelectionDependency(master, (Control)slave);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.comment_formathtml.label");
        slave = this.addCheckBox(commentComposite, label, PREF_COMMENT_FORMATHTML, trueFalse, 20);
        CodeFormatterConfigurationBlock.createSelectionDependency(master, (Control)slave);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.comment_formatsource.label");
        slave = this.addCheckBox(commentComposite, label, PREF_COMMENT_FORMATSOURCE, trueFalse, 20);
        CodeFormatterConfigurationBlock.createSelectionDependency(master, (Control)slave);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_clear_lines");
        slave = this.addCheckBox(commentComposite, label, PREF_COMMENT_CLEARBLANKLINES, trueFalse, 20);
        CodeFormatterConfigurationBlock.createSelectionDependency(master, (Control)slave);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.comment_separateroottags.label");
        slave = this.addCheckBox(commentComposite, label, PREF_COMMENT_SEPARATEROOTTAGS, trueFalse, 20);
        CodeFormatterConfigurationBlock.createSelectionDependency(master, (Control)slave);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.comment_newlineparam.label");
        slave = this.addCheckBox(commentComposite, label, PREF_COMMENT_NEWLINEPARAM, trueFalse, 20);
        CodeFormatterConfigurationBlock.createSelectionDependency(master, (Control)slave);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.comment_indentroottags.label");
        Button indentRootTags = this.addCheckBox(commentComposite, label, PREF_COMMENT_INDENTROOTTAGS, trueFalse, 20);
        CodeFormatterConfigurationBlock.createSelectionDependency(master, (Control)indentRootTags);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.comment_indentparamdesc.label");
        slave = this.addCheckBox(commentComposite, label, PREF_COMMENT_INDENTPARAMDESC, trueFalse, 20);
        CodeFormatterConfigurationBlock.createEnableDependency(master, indentRootTags, (Control)slave);
        TabItem item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CodeFormatterPreferencePage.tab.newline.tabtitle"));
        item.setControl((Control)newlineComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CodeFormatterPreferencePage.tab.linesplit.tabtitle"));
        item.setControl((Control)lineSplittingComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CodeFormatterPreferencePage.tab.style.tabtitle"));
        item.setControl((Control)styleComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CodeFormatterPreferencePage.tab.comment.tabtitle"));
        item.setControl((Control)commentComposite);
        this.fSourceViewer = this.createPreview(composite);
        this.updatePreview();
        return composite;
    }

    private static void createEnableDependency(final Button chief, final Button master, final Control slave) {
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection() && chief.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        chief.addSelectionListener(listener);
        master.addSelectionListener(listener);
        slave.setEnabled(master.getSelection() && chief.getSelection());
    }

    private static void createSelectionDependency(final Button master, final Control slave) {
        master.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        slave.setEnabled(master.getSelection());
    }

    private SourceViewer createPreview(Composite parent) {
        JavaSourceViewer previewViewer = new JavaSourceViewer(parent, null, null, false, 2824);
        previewViewer.configure(this.fViewerConfiguration);
        previewViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        new JavaSourcePreviewerUpdater(previewViewer, this.fTextTools);
        previewViewer.getTextWidget().setTabs(CodeFormatterConfigurationBlock.getPositiveIntValue((String)this.fWorkingValues.get(PREF_TAB_SIZE), 0));
        previewViewer.setDocument(this.fPreviewDocument);
        Control control = previewViewer.getControl();
        GridData gdata = new GridData(1808);
        gdata.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(30);
        gdata.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(12);
        control.setLayoutData((Object)gdata);
        return previewViewer;
    }

    protected void validateSettings(String changedKey, String newValue) {
        String lineNumber;
        if (changedKey == null || PREF_CODE_SPLIT.equals(changedKey)) {
            lineNumber = (String)this.fWorkingValues.get(PREF_CODE_SPLIT);
            this.fCodeLengthStatus = this.validatePositiveNumber(lineNumber, 4);
        }
        if (changedKey == null || PREF_COMMENT_LINELENGTH.equals(changedKey)) {
            lineNumber = (String)this.fWorkingValues.get(PREF_COMMENT_LINELENGTH);
            this.fCommentLengthStatus = this.validatePositiveNumber(lineNumber, 4);
        }
        if (changedKey == null || PREF_TAB_SIZE.equals(changedKey)) {
            String tabSize = (String)this.fWorkingValues.get(PREF_TAB_SIZE);
            this.fTabSizeStatus = this.validatePositiveNumber(tabSize, 0);
            int oldTabSize = this.fSourceViewer.getTextWidget().getTabs();
            if (this.fTabSizeStatus.matches(4)) {
                this.fWorkingValues.put(PREF_TAB_SIZE, String.valueOf(oldTabSize));
            } else {
                this.fSourceViewer.getTextWidget().setTabs(CodeFormatterConfigurationBlock.getPositiveIntValue(tabSize, 0));
            }
        }
        IStatus status = StatusUtil.getMostSevere(new IStatus[]{this.fCodeLengthStatus, this.fCommentLengthStatus, this.fTabSizeStatus});
        this.fContext.statusChanged(status);
        if (!status.matches(4)) {
            this.updatePreview();
        }
    }

    /*
     * Exception decompiling
     */
    private String loadPreviewFile(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 118->121)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updatePreview() {
        this.fSourceViewer.setRedraw(false);
        Point selection = this.fSourceViewer.getSelectedRange();
        this.fPreviewDocument.set(this.fPreviewText);
        CommentFormattingContext context = new CommentFormattingContext();
        try {
            IContentFormatter formatter = this.fViewerConfiguration.getContentFormatter((ISourceViewer)this.fSourceViewer);
            if (formatter instanceof IContentFormatterExtension2) {
                IContentFormatterExtension2 extension = (IContentFormatterExtension2)formatter;
                context.setProperty("formatting.context.preferences", this.fWorkingValues);
                context.setProperty("formatting.context.document", true);
                extension.format(this.fPreviewDocument, (IFormattingContext)context);
            } else {
                formatter.format(this.fPreviewDocument, (IRegion)new Region(0, this.fPreviewDocument.getLength()));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fSourceViewer.setSelectedRange(selection.x, selection.y);
            context.dispose();
            this.fSourceViewer.setRedraw(true);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.fSourceViewer.setSelectedRange(selection.x, selection.y);
        context.dispose();
        this.fSourceViewer.setRedraw(true);
    }

    private IStatus validatePositiveNumber(String number, int threshold) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.getString("CodeFormatterPreferencePage.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < threshold) {
                    status.setError(PreferencesMessages.getFormattedString("CodeFormatterPreferencePage.invalid_input", number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(PreferencesMessages.getFormattedString("CodeFormatterPreferencePage.invalid_input", number));
            }
        }
        return status;
    }

    private static int getPositiveIntValue(String string, int dflt) {
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return dflt;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    protected Map getDefaultOptions() {
        Map map = super.getDefaultOptions();
        CommentFormattingContext context = new CommentFormattingContext();
        context.storeToMap(PreferenceConstants.getPreferenceStore(), map, true);
        return map;
    }

    protected Map getOptions(boolean inheritJavaCoreOptions) {
        Map map = super.getOptions(inheritJavaCoreOptions);
        CommentFormattingContext context = new CommentFormattingContext();
        context.storeToMap(PreferenceConstants.getPreferenceStore(), map, false);
        return map;
    }

    public boolean performOk(boolean enabled) {
        if (super.performOk(enabled)) {
            CommentFormattingContext context = new CommentFormattingContext();
            context.mapToStore(this.fWorkingValues, PreferenceConstants.getPreferenceStore());
            return true;
        }
        return false;
    }
}

