/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuildPathsPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private static final String PAGE_SETTINGS = "BuildPathsPropertyPage";
    private static final String INDEX = "pageIndex";
    private BuildPathsBlock fBuildPathsBlock;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IProject project = this.getProject();
        Control result = project == null || !this.isJavaProject(project) ? this.createWithoutJava(parent) : (!project.isOpen() ? this.createForClosedProject(parent) : this.createWithJava(parent, project));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.build_path_property_page_context");
    }

    private IDialogSettings getSettings() {
        IDialogSettings javaSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = javaSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = javaSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 3);
        }
        return pageSettings;
    }

    private Control createWithJava(Composite parent, IProject project) {
        this.fBuildPathsBlock = new BuildPathsBlock(this, this.getSettings().getInt(INDEX));
        this.fBuildPathsBlock.init(JavaCore.create((IProject)project), null, null);
        return this.fBuildPathsBlock.createControl(parent);
    }

    private Control createWithoutJava(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.getString("BuildPathsPropertyPage.no_java_project.message"));
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.getString("BuildPathsPropertyPage.closed_project.message"));
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable != null) {
            IJavaElement elem;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.IJavaElement;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((elem = (IJavaElement)adaptable.getAdapter((Class)clazz)) instanceof IJavaProject) {
                return ((IJavaProject)elem).getProject();
            }
        }
        return null;
    }

    private boolean isJavaProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fBuildPathsBlock != null) {
            this.getSettings().put(INDEX, this.fBuildPathsBlock.getPageIndex());
            Shell shell = this.getControl().getShell();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        BuildPathsPropertyPage.this.fBuildPathsBlock.configureJavaProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
            try {
                new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e) {
                String title = PreferencesMessages.getString("BuildPathsPropertyPage.error.title");
                String message = PreferencesMessages.getString("BuildPathsPropertyPage.error.message");
                ExceptionHandler.handle(e, shell, title, message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public boolean performCancel() {
        if (this.fBuildPathsBlock != null) {
            this.getSettings().put(INDEX, this.fBuildPathsBlock.getPageIndex());
        }
        return super.performCancel();
    }
}

