/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.filebuffers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitAnnotationModelEvent;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.ISavePolicy;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.filebuffers.JavaStorageDocumentProvider;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.java.IProblemRequestorExtension;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class CompilationUnitDocumentProvider2
extends TextFileDocumentProvider
implements ICompilationUnitDocumentProvider {
    private static final String HANDLE_TEMPORARY_PROBLEMS = "handleTemporaryProblems";
    private boolean fIsAboutToSave = false;
    private ISavePolicy fSavePolicy;
    private IPropertyChangeListener fPropertyListener;
    private GlobalAnnotationModelListener fGlobalAnnotationModelListener;

    public CompilationUnitDocumentProvider2() {
        this.setParentDocumentProvider((IDocumentProvider)new TextFileDocumentProvider((IDocumentProvider)new JavaStorageDocumentProvider()));
        this.fGlobalAnnotationModelListener = new GlobalAnnotationModelListener();
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (CompilationUnitDocumentProvider2.HANDLE_TEMPORARY_PROBLEMS.equals(event.getProperty())) {
                    CompilationUnitDocumentProvider2.this.enableHandlingTemporaryProblems();
                }
            }
        };
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
    }

    protected ICompilationUnit createCompilationUnit(IFile file) {
        IJavaElement element = JavaCore.create((IFile)file);
        if (element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new CompilationUnitInfo();
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new CompilationUnitAnnotationModel((IResource)file);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        if (!(element instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput input = (IFileEditorInput)element;
        ICompilationUnit original = this.createCompilationUnit(input.getFile());
        if (original == null) {
            return null;
        }
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof CompilationUnitInfo)) {
            return null;
        }
        CompilationUnitInfo cuInfo = (CompilationUnitInfo)info;
        IProblemRequestor requestor = cuInfo.fModel instanceof IProblemRequestor ? (IProblemRequestor)cuInfo.fModel : null;
        original.becomeWorkingCopy(requestor, this.getProgressMonitor());
        cuInfo.fCopy = original;
        if (cuInfo.fModel instanceof CompilationUnitAnnotationModel) {
            CompilationUnitAnnotationModel model = (CompilationUnitAnnotationModel)cuInfo.fModel;
            model.setCompilationUnit(cuInfo.fCopy);
        }
        if (cuInfo.fModel != null) {
            cuInfo.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
        }
        if (requestor instanceof IProblemRequestorExtension) {
            IProblemRequestorExtension extension = (IProblemRequestorExtension)requestor;
            extension.setIsActive(this.isHandlingTemporaryProblems());
        }
        return cuInfo;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof CompilationUnitInfo) {
            CompilationUnitInfo cuInfo = (CompilationUnitInfo)info;
            try {
                cuInfo.fCopy.discardWorkingCopy();
            }
            catch (JavaModelException x) {
                this.handleCoreException((CoreException)((Object)x), x.getMessage());
            }
            if (cuInfo.fModel != null) {
                cuInfo.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
            }
        }
        super.disposeFileInfo(element, info);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitWorkingCopy(IProgressMonitor monitor, Object element, CompilationUnitInfo info, boolean overwrite) throws CoreException {
        IResource r;
        IMarker[] markers;
        ICompilationUnit unit;
        ICompilationUnit iCompilationUnit = info.fCopy;
        synchronized (iCompilationUnit) {
            info.fCopy.reconcile();
        }
        IDocument document = info.fTextFileBuffer.getDocument();
        ICompilationUnit original = (ICompilationUnit)info.fCopy.getOriginalElement();
        IResource resource = original.getResource();
        Assert.isTrue((boolean)(resource instanceof IFile));
        if (!resource.exists()) {
            this.createFileFromDocument(monitor, (IFile)resource, document);
            return;
        }
        if (this.fSavePolicy != null) {
            this.fSavePolicy.preSave(info.fCopy);
        }
        try {
            try {
                this.fIsAboutToSave = true;
                info.fCopy.commitWorkingCopy(overwrite, monitor);
            }
            catch (CoreException x) {
                this.fireElementStateChangeFailed(element);
                throw x;
            }
            catch (RuntimeException x) {
                this.fireElementStateChangeFailed(element);
                throw x;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.fIsAboutToSave = false;
            throw throwable;
        }
        {
            Object var9_14 = null;
            this.fIsAboutToSave = false;
        }
        if (info.fModel instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
            model.updateMarkers(document);
        }
        if (this.fSavePolicy != null && (unit = this.fSavePolicy.postSave(original)) != null && info.fModel instanceof AbstractMarkerAnnotationModel && (markers = (r = unit.getResource()).findMarkers("org.eclipse.core.resources.marker", true, 0)) != null && markers.length > 0) {
            AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
            int i = 0;
            while (i < markers.length) {
                model.updateMarker(markers[i], document, null);
                ++i;
            }
        }
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object element, IDocument document, final boolean overwrite) throws CoreException {
        final TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof CompilationUnitInfo) {
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    CompilationUnitDocumentProvider2.this.commitWorkingCopy(monitor, element, (CompilationUnitInfo)info, overwrite);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (info.fElement instanceof IFileEditorInput) {
                        return ResourcesPlugin.getWorkspace().getRoot();
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected boolean isHandlingTemporaryProblems() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(HANDLE_TEMPORARY_PROBLEMS);
    }

    protected void enableHandlingTemporaryProblems() {
        boolean enable = this.isHandlingTemporaryProblems();
        Iterator iter = this.getFileInfosIterator();
        while (iter.hasNext()) {
            TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)iter.next();
            if (!(info.fModel instanceof IProblemRequestorExtension)) continue;
            IProblemRequestorExtension extension = (IProblemRequestorExtension)info.fModel;
            extension.setIsActive(enable);
        }
    }

    public void setSavePolicy(ISavePolicy savePolicy) {
        this.fSavePolicy = savePolicy;
    }

    public void addGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.addListener(listener);
    }

    public void removeGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.removeListener(listener);
    }

    public ICompilationUnit getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof CompilationUnitInfo) {
            CompilationUnitInfo info = (CompilationUnitInfo)fileInfo;
            return info.fCopy;
        }
        return null;
    }

    public void shutdown() {
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
        Iterator e = this.getConnectedElementsIterator();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
    }

    public void saveDocumentContent(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        super.saveDocument(monitor, element, document, overwrite);
    }

    public ILineTracker createLineTracker(Object element) {
        return new DefaultLineTracker();
    }

    protected static class CompilationUnitInfo
    extends TextFileDocumentProvider.FileInfo {
        public ICompilationUnit fCopy;

        protected CompilationUnitInfo() {
        }
    }

    protected static class ProblemAnnotation
    extends Annotation
    implements IJavaAnnotation,
    IAnnotationPresentation {
        private static Image fgQuickFixImage;
        private static Image fgQuickFixErrorImage;
        private static boolean fgQuickFixImagesInitialized;
        private ICompilationUnit fCompilationUnit;
        private List fOverlaids;
        private IProblem fProblem;
        private Image fImage;
        private boolean fQuickFixImagesInitialized = false;

        static {
            fgQuickFixImagesInitialized = false;
        }

        public ProblemAnnotation(IProblem problem, ICompilationUnit cu) {
            this.fProblem = problem;
            this.fCompilationUnit = cu;
            if (536871362 == this.fProblem.getID()) {
                this.setType("org.eclipse.ui.workbench.texteditor.task");
                this.setLayer(2);
            } else if (this.fProblem.isWarning()) {
                this.setType("org.eclipse.jdt.ui.warning");
                this.setLayer(5);
            } else if (this.fProblem.isError()) {
                this.setType("org.eclipse.jdt.ui.error");
                this.setLayer(6);
            } else {
                this.setType("org.eclipse.jdt.ui.info");
                this.setLayer(4);
            }
        }

        private void initializeImages() {
            if (!this.fQuickFixImagesInitialized) {
                if (this.isProblem() && this.indicateQuixFixableProblems() && JavaCorrectionProcessor.hasCorrections(this)) {
                    if (!fgQuickFixImagesInitialized) {
                        fgQuickFixImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_warning_obj.gif");
                        fgQuickFixErrorImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_error_obj.gif");
                        fgQuickFixImagesInitialized = true;
                    }
                    this.fImage = "org.eclipse.jdt.ui.error".equals(this.getType()) ? fgQuickFixErrorImage : fgQuickFixImage;
                }
                this.fQuickFixImagesInitialized = true;
            }
        }

        private boolean indicateQuixFixableProblems() {
            return PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.ShowTemporaryProblem");
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            this.initializeImages();
            if (this.fImage != null) {
                Annotation.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
            }
        }

        public Image getImage(Display display) {
            this.initializeImages();
            return this.fImage;
        }

        public String getText() {
            return this.fProblem.getMessage();
        }

        public String[] getArguments() {
            return this.isProblem() ? this.fProblem.getArguments() : null;
        }

        public int getId() {
            return this.fProblem.getID();
        }

        public boolean isProblem() {
            String type = this.getType();
            return "org.eclipse.jdt.ui.warning".equals(type) || "org.eclipse.jdt.ui.error".equals(type);
        }

        public boolean hasOverlay() {
            return false;
        }

        public IJavaAnnotation getOverlay() {
            return null;
        }

        public void addOverlaid(IJavaAnnotation annotation) {
            if (this.fOverlaids == null) {
                this.fOverlaids = new ArrayList(1);
            }
            this.fOverlaids.add(annotation);
        }

        public void removeOverlaid(IJavaAnnotation annotation) {
            if (this.fOverlaids != null) {
                this.fOverlaids.remove(annotation);
                if (this.fOverlaids.size() == 0) {
                    this.fOverlaids = null;
                }
            }
        }

        public Iterator getOverlaidIterator() {
            if (this.fOverlaids != null) {
                return this.fOverlaids.iterator();
            }
            return null;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fCompilationUnit;
        }
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }

    protected static class CompilationUnitAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor,
    IProblemRequestorExtension {
        private ICompilationUnit fCompilationUnit;
        private List fCollectedProblems;
        private List fGeneratedAnnotations;
        private IProgressMonitor fProgressMonitor;
        private boolean fIsActive = false;
        private ReverseMap fReverseMap = new ReverseMap();
        private List fPreviouslyOverlaid = null;
        private List fCurrentlyOverlaid = new ArrayList();
        private boolean fIncludesProblemAnnotationChanges = false;

        public CompilationUnitAnnotationModel(IResource resource) {
            super(resource);
        }

        public void setCompilationUnit(ICompilationUnit unit) {
            this.fCompilationUnit = unit;
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
            String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
            if (markerType != null && markerType.startsWith("org.eclipse.jdt")) {
                return new JavaMarkerAnnotation(marker);
            }
            return super.createMarkerAnnotation(marker);
        }

        protected AnnotationModelEvent createAnnotationModelEvent() {
            return new CompilationUnitAnnotationModelEvent((IAnnotationModel)this, this.getResource());
        }

        protected Position createPositionFromProblem(IProblem problem) {
            int start = problem.getSourceStart();
            if (start < 0) {
                return null;
            }
            int length = problem.getSourceEnd() - problem.getSourceStart() + 1;
            if (length < 0) {
                return null;
            }
            return new Position(start, length);
        }

        protected void update(IMarkerDelta[] markerDeltas) {
            block4: {
                super.update(markerDeltas);
                if (this.fIncludesProblemAnnotationChanges) {
                    try {
                        if (this.fCompilationUnit != null) {
                            this.fCompilationUnit.reconcile(true, null);
                        }
                    }
                    catch (JavaModelException ex) {
                        if (ex.isDoesNotExist()) break block4;
                        this.handleCoreException((CoreException)((Object)ex), ex.getMessage());
                    }
                }
            }
        }

        public void beginReporting() {
            this.fCollectedProblems = this.fCompilationUnit != null && this.fCompilationUnit.getJavaProject().isOnClasspath((IJavaElement)this.fCompilationUnit) ? new ArrayList() : null;
        }

        public void acceptProblem(IProblem problem) {
            if (this.isActive()) {
                this.fCollectedProblems.add(problem);
            }
        }

        public void endReporting() {
            if (!this.isActive()) {
                return;
            }
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return;
            }
            boolean isCanceled = false;
            boolean temporaryProblemsChanged = false;
            Map map = this.fAnnotations;
            synchronized (map) {
                this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
                this.fCurrentlyOverlaid = new ArrayList();
                if (this.fGeneratedAnnotations.size() > 0) {
                    temporaryProblemsChanged = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (this.fCollectedProblems != null && this.fCollectedProblems.size() > 0) {
                    Iterator e = this.fCollectedProblems.iterator();
                    while (e.hasNext()) {
                        IProblem problem = (IProblem)e.next();
                        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                            isCanceled = true;
                            break;
                        }
                        Position position = this.createPositionFromProblem(problem);
                        if (position == null) continue;
                        try {
                            ProblemAnnotation annotation = new ProblemAnnotation(problem, this.fCompilationUnit);
                            this.overlayMarkers(position, annotation);
                            this.addAnnotation(annotation, position, false);
                            this.fGeneratedAnnotations.add(annotation);
                            temporaryProblemsChanged = true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    this.fCollectedProblems.clear();
                }
                this.removeMarkerOverlays(isCanceled);
                this.fPreviouslyOverlaid.clear();
                this.fPreviouslyOverlaid = null;
            }
            if (temporaryProblemsChanged) {
                this.fireModelChanged();
            }
        }

        private void removeMarkerOverlays(boolean isCanceled) {
            if (isCanceled) {
                this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
            } else if (this.fPreviouslyOverlaid != null) {
                Iterator e = this.fPreviouslyOverlaid.iterator();
                while (e.hasNext()) {
                    JavaMarkerAnnotation annotation = (JavaMarkerAnnotation)e.next();
                    annotation.setOverlay(null);
                }
            }
        }

        private void setOverlay(Object value, ProblemAnnotation problemAnnotation) {
            JavaMarkerAnnotation annotation;
            if (value instanceof JavaMarkerAnnotation && (annotation = (JavaMarkerAnnotation)value).isProblem()) {
                annotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(annotation);
                this.fCurrentlyOverlaid.add(annotation);
            }
        }

        private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
            Object value = this.getAnnotations(position);
            if (value instanceof List) {
                List list = (List)value;
                Iterator e = list.iterator();
                while (e.hasNext()) {
                    this.setOverlay(e.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(value, problemAnnotation);
            }
        }

        private void startCollectingProblems() {
            this.fCollectedProblems = new ArrayList();
            this.fGeneratedAnnotations = new ArrayList();
        }

        private void stopCollectingProblems() {
            if (this.fGeneratedAnnotations != null) {
                this.removeAnnotations(this.fGeneratedAnnotations, true, true);
                this.fGeneratedAnnotations.clear();
            }
            this.fCollectedProblems = null;
            this.fGeneratedAnnotations = null;
        }

        protected void fireModelChanged(AnnotationModelEvent event) {
            if (event instanceof CompilationUnitAnnotationModelEvent) {
                CompilationUnitAnnotationModelEvent e = (CompilationUnitAnnotationModelEvent)event;
                this.fIncludesProblemAnnotationChanges = e.includesProblemMarkerAnnotationChanges();
            }
            super.fireModelChanged(event);
        }

        public boolean isActive() {
            return this.fIsActive && this.fCollectedProblems != null;
        }

        public void setProgressMonitor(IProgressMonitor monitor) {
            this.fProgressMonitor = monitor;
        }

        public void setIsActive(boolean isActive) {
            if (this.fIsActive != isActive) {
                this.fIsActive = isActive;
                if (this.fIsActive) {
                    this.startCollectingProblems();
                } else {
                    this.stopCollectingProblems();
                }
            }
        }

        private Object getAnnotations(Position position) {
            return this.fReverseMap.get(position);
        }

        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
            super.addAnnotation(annotation, position, fireModelChanged);
            Object cached = this.fReverseMap.get(position);
            if (cached == null) {
                this.fReverseMap.put(position, annotation);
            } else if (cached instanceof List) {
                List list = (List)cached;
                list.add(annotation);
            } else if (cached instanceof Annotation) {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(cached);
                list.add(annotation);
                this.fReverseMap.put(position, list);
            }
        }

        protected void removeAllAnnotations(boolean fireModelChanged) {
            super.removeAllAnnotations(fireModelChanged);
            this.fReverseMap.clear();
        }

        protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
            Position position = this.getPosition(annotation);
            Object cached = this.fReverseMap.get(position);
            if (cached instanceof List) {
                List list = (List)cached;
                list.remove(annotation);
                if (list.size() == 1) {
                    this.fReverseMap.put(position, list.get(0));
                    list.clear();
                }
            } else if (cached instanceof Annotation) {
                this.fReverseMap.remove(position);
            }
            super.removeAnnotation(annotation, fireModelChanged);
        }
    }

    protected static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ListenerList fListenerList = new ListenerList();

        public void modelChanged(IAnnotationModel model) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IAnnotationModelListener)listeners[i]).modelChanged(model);
                ++i;
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                Object curr = listeners[i];
                if (curr instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)curr).modelChanged(event);
                }
                ++i;
            }
        }

        public void addListener(IAnnotationModelListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public void removeListener(IAnnotationModelListener listener) {
            this.fListenerList.remove((Object)listener);
        }
    }
}

