/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;

public class JavaTextSelection
extends TextSelection {
    private IJavaElement fElement;
    private IJavaElement[] fResolvedElements;
    private boolean fEnclosingElementRequested;
    private IJavaElement fEnclosingElement;
    private boolean fPartialASTRequested;
    private CompilationUnit fPartialAST;
    private boolean fNodesRequested;
    private ASTNode[] fSelectedNodes;
    private ASTNode fCoveringNode;
    private boolean fInMethodBodyRequested;
    private boolean fInMethodBody;
    private boolean fInInitializeRequested;
    private boolean fInInitializer;

    public JavaTextSelection(IJavaElement element, IDocument document, int offset, int length) {
        super(document, offset, length);
        this.fElement = element;
    }

    public IJavaElement[] resolveElementAtOffset() throws JavaModelException {
        if (this.fResolvedElements != null) {
            return this.fResolvedElements;
        }
        this.fResolvedElements = SelectionConverter.codeResolve(this.fElement, (ITextSelection)this);
        return this.fResolvedElements;
    }

    public IJavaElement resolveEnclosingElement() throws JavaModelException {
        if (this.fEnclosingElementRequested) {
            return this.fEnclosingElement;
        }
        this.fEnclosingElementRequested = true;
        this.fEnclosingElement = SelectionConverter.resolveEnclosingElement(this.fElement, (ITextSelection)this);
        return this.fEnclosingElement;
    }

    public CompilationUnit resolvePartialAstAtOffset() {
        if (this.fPartialASTRequested) {
            return this.fPartialAST;
        }
        this.fPartialASTRequested = true;
        if (!(this.fElement instanceof ICompilationUnit)) {
            return null;
        }
        this.fPartialAST = AST.parsePartialCompilationUnit((ICompilationUnit)((ICompilationUnit)this.fElement), (int)this.getOffset(), (boolean)true);
        return this.fPartialAST;
    }

    public ASTNode[] resolveSelectedNodes() {
        if (this.fNodesRequested) {
            return this.fSelectedNodes;
        }
        this.fNodesRequested = true;
        CompilationUnit root = this.resolvePartialAstAtOffset();
        if (root == null) {
            return null;
        }
        Selection ds = Selection.createFromStartLength(this.getOffset(), this.getLength());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(ds, false);
        root.accept((ASTVisitor)analyzer);
        this.fSelectedNodes = analyzer.getSelectedNodes();
        this.fCoveringNode = analyzer.getLastCoveringNode();
        return this.fSelectedNodes;
    }

    public ASTNode resolveCoveringNode() {
        if (this.fNodesRequested) {
            return this.fCoveringNode;
        }
        this.resolveSelectedNodes();
        return this.fCoveringNode;
    }

    /*
     * Unable to fully structure code
     */
    public boolean resolveInMethodBody() {
        block4: {
            if (this.fInMethodBodyRequested) {
                return this.fInMethodBody;
            }
            this.fInMethodBodyRequested = true;
            this.resolveSelectedNodes();
            node = this.getStartNode();
            if (node != null) ** GOTO lbl18
            this.fInMethodBody = true;
            break block4;
lbl-1000:
            // 1 sources

            {
                nodeType = node.getNodeType();
                if (nodeType == 8 && node.getParent() instanceof BodyDeclaration) {
                    this.fInMethodBody = node.getParent().getNodeType() == 31;
                    break;
                }
                if (nodeType == 1) {
                    this.fInMethodBody = false;
                    break;
                }
                node = node.getParent();
lbl18:
                // 2 sources

                ** while (node != null)
            }
        }
        return this.fInMethodBody;
    }

    /*
     * Unable to fully structure code
     */
    public boolean resolveInInitializer() {
        block4: {
            if (this.fInInitializeRequested) {
                return this.fInInitializer;
            }
            this.fInInitializeRequested = true;
            this.resolveSelectedNodes();
            node = this.getStartNode();
            if (node != null) ** GOTO lbl18
            this.fInInitializer = true;
            break block4;
lbl-1000:
            // 1 sources

            {
                nodeType = node.getNodeType();
                if (nodeType == 8 && node.getParent() instanceof BodyDeclaration) {
                    this.fInInitializer = node.getParent().getNodeType() == 28;
                    break;
                }
                if (nodeType == 1) {
                    this.fInInitializer = false;
                    break;
                }
                node = node.getParent();
lbl18:
                // 2 sources

                ** while (node != null)
            }
        }
        return this.fInInitializer;
    }

    private ASTNode getStartNode() {
        if (this.fSelectedNodes != null && this.fSelectedNodes.length > 0) {
            return this.fSelectedNodes[0];
        }
        return this.fCoveringNode;
    }
}

