/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistLightBulbUpdater;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;

public class JavaSelectMarkerRulerAction
extends SelectMarkerRulerAction {
    private ITextEditor fTextEditor;
    private Position fPosition;
    static /* synthetic */ Class class$0;

    public JavaSelectMarkerRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix, editor, ruler);
        this.fTextEditor = editor;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.java_select_marker_ruler_action");
    }

    public void run() {
        if (this.fPosition != null) {
            ITextOperationTarget operation;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.jface.text.ITextOperationTarget;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((operation = (ITextOperationTarget)this.fTextEditor.getAdapter((Class)clazz)) != null && operation.canDoOperation(50)) {
                this.fTextEditor.selectAndReveal(this.fPosition.getOffset(), this.fPosition.getLength());
                operation.doOperation(50);
                return;
            }
            return;
        }
        super.run();
    }

    public void update() {
        if (!(this.fTextEditor instanceof ITextEditorExtension) || ((ITextEditorExtension)this.fTextEditor).isEditorInputReadOnly()) {
            this.fPosition = null;
            super.update();
            return;
        }
        this.fPosition = this.getJavaAnnotationPosition();
        if (this.fPosition != null) {
            this.setEnabled(true);
        } else {
            super.update();
        }
    }

    private Position getJavaAnnotationPosition() {
        Position position;
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IDocument document = this.getDocument();
        if (model == null) {
            return null;
        }
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        boolean hasAssistLightbulb = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.quickassist.lightbulb");
        Annotation assistAnnotation = null;
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            if (annotation instanceof IJavaAnnotation) {
                Position position2;
                IJavaAnnotation javaAnnotation = (IJavaAnnotation)annotation;
                if (javaAnnotation.isMarkedDeleted() || !this.includesRulerLine(position2 = model.getPosition(annotation), document) || !JavaCorrectionProcessor.hasCorrections(javaAnnotation)) continue;
                return position2;
            }
            if (!hasAssistLightbulb || !(annotation instanceof QuickAssistLightBulbUpdater.AssistAnnotation)) continue;
            assistAnnotation = annotation;
        }
        if (assistAnnotation != null && this.includesRulerLine(position = model.getPosition(assistAnnotation), document)) {
            return position;
        }
        return null;
    }

    private ICompilationUnit getCompilationUnit() {
        IFile file;
        IJavaElement element;
        IEditorInput input = this.fTextEditor.getEditorInput();
        if (input instanceof IFileEditorInput && (element = JavaCore.create((IFile)(file = ((IFileEditorInput)input).getFile()))) instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }
}

