/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class JavaEditorErrorTickUpdater
implements IProblemChangedListener {
    private JavaEditor fJavaEditor;
    private JavaUILabelProvider fLabelProvider;
    static /* synthetic */ Class class$0;

    public JavaEditorErrorTickUpdater(JavaEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fJavaEditor = editor;
        this.fLabelProvider = new JavaUILabelProvider(0, 2);
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        JavaPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (isMarkerChange) {
            return;
        }
        IEditorInput input = this.fJavaEditor.getEditorInput();
        if (input != null) {
            IJavaElement jelement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.IJavaElement;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jelement = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
                IResource resource = jelement.getResource();
                int i = 0;
                while (i < changedResources.length) {
                    if (changedResources[i].equals((Object)resource)) {
                        this.updateEditorImage(jelement);
                    }
                    ++i;
                }
            }
        }
    }

    public void updateEditorImage(IJavaElement jelement) {
        Image titleImage = this.fJavaEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = this.fLabelProvider.getImage(jelement);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.fJavaEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    JavaEditorErrorTickUpdater.this.fJavaEditor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        JavaPlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }
}

