/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.IResourceLocator;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileMarkerAnnotationModel;
import org.eclipse.jdt.internal.ui.javaeditor.ExternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class ClassFileDocumentProvider
extends FileDocumentProvider {
    private List fInputListeners = new ArrayList();
    static /* synthetic */ Class class$0;

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (editorInput instanceof IClassFileEditorInput) {
            IClassFile classFile = ((IClassFileEditorInput)editorInput).getClassFile();
            document.set(classFile.getSource());
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    protected IAnnotationModel createClassFileAnnotationModel(IClassFileEditorInput classFileEditorInput) throws CoreException {
        IResourceLocator locator;
        IResource resource = null;
        IClassFile classFile = classFileEditorInput.getClassFile();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.internal.ui.IResourceLocator;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((locator = (IResourceLocator)classFile.getAdapter((Class)clazz)) != null) {
            resource = locator.getContainingResource(classFile);
        }
        if (resource != null) {
            ClassFileMarkerAnnotationModel model = new ClassFileMarkerAnnotationModel(resource);
            model.setClassFile(classFile);
            return model;
        }
        return null;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
            tools.setupJavaDocumentPartitioner(document, "___java_partitioning");
        }
        return document;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IClassFileEditorInput) {
            IClassFileEditorInput input = (IClassFileEditorInput)element;
            ExternalClassFileEditorInput external = null;
            if (input instanceof ExternalClassFileEditorInput) {
                external = (ExternalClassFileEditorInput)input;
            }
            if (external != null) {
                try {
                    this.refreshFile(external.getFile());
                }
                catch (CoreException x) {
                    this.handleCoreException(x, JavaEditorMessages.getString("ClassFileDocumentProvider.error.createElementInfo"));
                }
            }
            IDocument d = this.createDocument(input);
            IAnnotationModel m = this.createClassFileAnnotationModel(input);
            if (external != null) {
                ClassFileInfo info = new ClassFileInfo(d, m, null);
                info.fModificationStamp = this.computeModificationStamp((IResource)external.getFile());
                info.fEncoding = this.getPersistedEncoding(element);
                return info;
            }
            if (input instanceof InternalClassFileEditorInput) {
                ClassFileSynchronizer s = new ClassFileSynchronizer(input);
                s.install();
                ClassFileInfo info = new ClassFileInfo(d, m, s);
                info.fEncoding = this.getPersistedEncoding(element);
                return info;
            }
        }
        return null;
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        ClassFileInfo classFileInfo = (ClassFileInfo)info;
        if (classFileInfo.fClassFileSynchronizer != null) {
            classFileInfo.fClassFileSynchronizer.uninstall();
            classFileInfo.fClassFileSynchronizer = null;
        }
        super.disposeElementInfo(element, info);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document) throws CoreException {
    }

    public boolean isSynchronized(Object element) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof ClassFileInfo) {
            IResource resource;
            IClassFileEditorInput input = (IClassFileEditorInput)element;
            try {
                resource = input.getClassFile().getUnderlyingResource();
            }
            catch (JavaModelException javaModelException) {
                return true;
            }
            return resource == null || resource.isSynchronized(0);
        }
        return false;
    }

    protected void handleDeleted(IClassFileEditorInput input) {
        this.fireElementDeleted(input);
    }

    protected void fireInputChanged(IClassFileEditorInput input) {
        ArrayList list = new ArrayList(this.fInputListeners);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ((InputChangeListener)i.next()).inputChanged(input);
        }
    }

    public void addInputChangeListener(InputChangeListener listener) {
        this.fInputListeners.add(listener);
    }

    public void removeInputChangeListener(InputChangeListener listener) {
        this.fInputListeners.remove(listener);
    }

    public interface InputChangeListener {
        public void inputChanged(IClassFileEditorInput var1);
    }

    protected class ClassFileSynchronizer
    implements IElementChangedListener {
        protected IClassFileEditorInput fInput;
        protected IPackageFragmentRoot fPackageFragmentRoot;

        public ClassFileSynchronizer(IClassFileEditorInput input) {
            this.fInput = input;
            IJavaElement parent = this.fInput.getClassFile().getParent();
            while (parent != null && !(parent instanceof IPackageFragmentRoot)) {
                parent = parent.getParent();
            }
            this.fPackageFragmentRoot = (IPackageFragmentRoot)parent;
        }

        public void install() {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        }

        public void uninstall() {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }

        public void elementChanged(ElementChangedEvent e) {
            this.check(this.fPackageFragmentRoot, e.getDelta());
        }

        protected boolean check(IPackageFragmentRoot input, IJavaElementDelta delta) {
            IJavaElement element = delta.getElement();
            if (((delta.getKind() & 2) != 0 || (delta.getFlags() & 0x400) != 0) && (element.equals(input.getJavaProject()) || element.equals(input))) {
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            if ((delta.getFlags() & 0x8000) != 0 && input.equals(element)) {
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            if ((delta.getFlags() & 0x80) != 0 && input.equals(element)) {
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            IJavaElementDelta[] subdeltas = delta.getAffectedChildren();
            int i = 0;
            while (i < subdeltas.length) {
                if (this.check(input, subdeltas[i])) {
                    return true;
                }
                ++i;
            }
            if ((delta.getFlags() & 0x2000) != 0 || (delta.getFlags() & 0x1000) != 0) {
                IClassFile file = this.fInput != null ? this.fInput.getClassFile() : null;
                IJavaProject project = input != null ? input.getJavaProject() : null;
                boolean isOnClasspath = false;
                if (file != null && project != null) {
                    isOnClasspath = project.isOnClasspath((IJavaElement)file);
                }
                if (isOnClasspath) {
                    ClassFileDocumentProvider.this.fireInputChanged(this.fInput);
                    return false;
                }
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            return false;
        }
    }

    protected class _FileSynchronizer
    extends FileDocumentProvider.FileSynchronizer {
        public _FileSynchronizer(IFileEditorInput fileEditorInput) {
            super((FileDocumentProvider)ClassFileDocumentProvider.this, fileEditorInput);
        }
    }

    protected class ClassFileInfo
    extends FileDocumentProvider.FileInfo {
        ClassFileSynchronizer fClassFileSynchronizer = null;

        ClassFileInfo(IDocument document, IAnnotationModel model, _FileSynchronizer fileSynchronizer) {
            super((FileDocumentProvider)ClassFileDocumentProvider.this, document, model, (FileDocumentProvider.FileSynchronizer)fileSynchronizer);
        }

        ClassFileInfo(IDocument document, IAnnotationModel model, ClassFileSynchronizer classFileSynchronizer) {
            super((FileDocumentProvider)ClassFileDocumentProvider.this, document, model, null);
            this.fClassFileSynchronizer = classFileSynchronizer;
        }
    }
}

