/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jdt.internal.ui.javaeditor.GotoAnnotationAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.TogglePresentationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class BasicJavaEditorActionContributor
extends BasicTextEditorActionContributor {
    private List fPartListeners = new ArrayList();
    private TogglePresentationAction fTogglePresentation;
    private GotoAnnotationAction fPreviousAnnotation;
    private GotoAnnotationAction fNextAnnotation;
    private RetargetTextEditorAction fGotoMatchingBracket;
    private RetargetTextEditorAction fShowOutline;
    private RetargetTextEditorAction fOpenStructure;
    private RetargetTextEditorAction fOpenHierarchy;
    private RetargetAction fRetargetShowJavaDoc;
    private RetargetTextEditorAction fShowJavaDoc;
    private RetargetTextEditorAction fStructureSelectEnclosingAction;
    private RetargetTextEditorAction fStructureSelectNextAction;
    private RetargetTextEditorAction fStructureSelectPreviousAction;
    private RetargetTextEditorAction fStructureSelectHistoryAction;
    private RetargetTextEditorAction fGotoNextMemberAction;
    private RetargetTextEditorAction fGotoPreviousMemberAction;
    private RetargetTextEditorAction fRemoveOccurrenceAnnotationsAction;

    public BasicJavaEditorActionContributor() {
        ResourceBundle b = JavaEditorMessages.getResourceBundle();
        this.fRetargetShowJavaDoc = new RetargetAction("org.eclipse.jdt.ui.actions.ShowJavaDoc", JavaEditorMessages.getString("ShowJavaDoc.label"));
        this.fRetargetShowJavaDoc.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.javadoc");
        this.markAsPartListener(this.fRetargetShowJavaDoc);
        this.fTogglePresentation = new TogglePresentationAction();
        this.fPreviousAnnotation = new GotoAnnotationAction("PreviousAnnotation.", false);
        this.fNextAnnotation = new GotoAnnotationAction("NextAnnotation.", true);
        this.fGotoMatchingBracket = new RetargetTextEditorAction(b, "GotoMatchingBracket.");
        this.fGotoMatchingBracket.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.matching.bracket");
        this.fShowJavaDoc = new RetargetTextEditorAction(b, "ShowJavaDoc.");
        this.fShowJavaDoc.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.javadoc");
        this.fShowOutline = new RetargetTextEditorAction(JavaEditorMessages.getResourceBundle(), "ShowOutline.");
        this.fShowOutline.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.outline");
        this.fOpenHierarchy = new RetargetTextEditorAction(JavaEditorMessages.getResourceBundle(), "OpenHierarchy.");
        this.fOpenHierarchy.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.hierarchy");
        this.fOpenStructure = new RetargetTextEditorAction(JavaEditorMessages.getResourceBundle(), "OpenStructure.");
        this.fOpenStructure.setActionDefinitionId("org.eclipse.jdt.ui.navigate.java.open.structure");
        this.fStructureSelectEnclosingAction = new RetargetTextEditorAction(b, "StructureSelectEnclosing.");
        this.fStructureSelectEnclosingAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.enclosing");
        this.fStructureSelectNextAction = new RetargetTextEditorAction(b, "StructureSelectNext.");
        this.fStructureSelectNextAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.next");
        this.fStructureSelectPreviousAction = new RetargetTextEditorAction(b, "StructureSelectPrevious.");
        this.fStructureSelectPreviousAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.previous");
        this.fStructureSelectHistoryAction = new RetargetTextEditorAction(b, "StructureSelectHistory.");
        this.fStructureSelectHistoryAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.last");
        this.fGotoNextMemberAction = new RetargetTextEditorAction(b, "GotoNextMember.");
        this.fGotoNextMemberAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.next.member");
        this.fGotoPreviousMemberAction = new RetargetTextEditorAction(b, "GotoPreviousMember.");
        this.fGotoPreviousMemberAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.previous.member");
        this.fRemoveOccurrenceAnnotationsAction = new RetargetTextEditorAction(b, "RemoveOccurrenceAnnotations.");
        this.fRemoveOccurrenceAnnotationsAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.remove.occurrence.annotations");
    }

    protected final void markAsPartListener(RetargetAction action) {
        this.fPartListeners.add(action);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        Iterator e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            page.addPartListener((IPartListener)((RetargetAction)e.next()));
        }
        super.init(bars, page);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", (IAction)this.fNextAnnotation);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", (IAction)this.fPreviousAnnotation);
        bars.setGlobalActionHandler("next", (IAction)this.fNextAnnotation);
        bars.setGlobalActionHandler("previous", (IAction)this.fPreviousAnnotation);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        bars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ShowJavaDoc", (IAction)this.fShowJavaDoc);
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager gotoMenu;
        IMenuManager navigateMenu;
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)new Separator("group.open"));
            editMenu.add((IContributionItem)new Separator("group.generate"));
            editMenu.add((IContributionItem)new Separator("additions"));
            MenuManager structureSelection = new MenuManager(JavaEditorMessages.getString("ExpandSelectionMenu.label"), "expandSelection");
            structureSelection.add((IAction)this.fStructureSelectEnclosingAction);
            structureSelection.add((IAction)this.fStructureSelectNextAction);
            structureSelection.add((IAction)this.fStructureSelectPreviousAction);
            structureSelection.add((IAction)this.fStructureSelectHistoryAction);
            editMenu.appendToGroup("group.open", (IContributionItem)structureSelection);
            editMenu.appendToGroup("group.generate", (IAction)this.fRetargetShowJavaDoc);
        }
        if ((navigateMenu = menu.findMenuUsingPath("navigate")) != null) {
            navigateMenu.appendToGroup("show.ext", (IAction)this.fShowOutline);
            navigateMenu.appendToGroup("show.ext", (IAction)this.fOpenHierarchy);
        }
        if ((gotoMenu = menu.findMenuUsingPath("navigate/goTo")) != null) {
            gotoMenu.add((IContributionItem)new Separator("additions2"));
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoPreviousMemberAction);
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoNextMemberAction);
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoMatchingBracket);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        IActionBars actionBars = this.getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        manager.setMessage(null);
        manager.setErrorMessage(null);
        ITextEditor textEditor = null;
        if (part instanceof ITextEditor) {
            textEditor = (ITextEditor)part;
        }
        this.fTogglePresentation.setEditor(textEditor);
        this.fPreviousAnnotation.setEditor(textEditor);
        this.fNextAnnotation.setEditor(textEditor);
        this.fGotoMatchingBracket.setAction(this.getAction(textEditor, "GotoMatchingBracket"));
        this.fShowJavaDoc.setAction(this.getAction(textEditor, "ShowJavaDoc"));
        this.fShowOutline.setAction(this.getAction(textEditor, "org.eclipse.jdt.ui.edit.text.java.show.outline"));
        this.fOpenHierarchy.setAction(this.getAction(textEditor, "org.eclipse.jdt.ui.edit.text.java.open.hierarchy"));
        this.fOpenStructure.setAction(this.getAction(textEditor, "org.eclipse.jdt.ui.navigate.java.open.structure"));
        this.fStructureSelectEnclosingAction.setAction(this.getAction(textEditor, "SelectEnclosingElement"));
        this.fStructureSelectNextAction.setAction(this.getAction(textEditor, "SelectNextElement"));
        this.fStructureSelectPreviousAction.setAction(this.getAction(textEditor, "SelectPreviousElement"));
        this.fStructureSelectHistoryAction.setAction(this.getAction(textEditor, "RestoreLastSelection"));
        this.fGotoNextMemberAction.setAction(this.getAction(textEditor, "GoToNextMember"));
        this.fGotoPreviousMemberAction.setAction(this.getAction(textEditor, "GoToPreviousMember"));
        this.fRemoveOccurrenceAnnotationsAction.setAction(this.getAction(textEditor, "RemoveOccurrenceAnnotations"));
        if (part instanceof JavaEditor) {
            JavaEditor javaEditor = (JavaEditor)part;
            javaEditor.getActionGroup().fillActionBars(this.getActionBars());
        }
    }

    public void dispose() {
        Iterator e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            this.getPage().removePartListener((IPartListener)((RetargetAction)e.next()));
        }
        this.fPartListeners.clear();
        this.setActiveEditor(null);
        super.dispose();
    }
}

