/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.AddImportsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.IUpdate;

public class AddImportOnSelectionAction
extends Action
implements IUpdate {
    private CompilationUnitEditor fEditor;

    public AddImportOnSelectionAction(CompilationUnitEditor editor) {
        super(JavaEditorMessages.getString("AddImportOnSelection.label"));
        this.setToolTipText(JavaEditorMessages.getString("AddImportOnSelection.tooltip"));
        this.setDescription(JavaEditorMessages.getString("AddImportOnSelection.description"));
        this.fEditor = editor;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.add_imports_on_selection_action_context");
        this.setEnabled(this.getCompilationUnit() != null);
    }

    public void update() {
        this.setEnabled(this.fEditor != null && this.getCompilationUnit() != null);
    }

    private ICompilationUnit getCompilationUnit() {
        IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(this.fEditor.getEditorInput());
    }

    public void run() {
        ICompilationUnit cu = this.getCompilationUnit();
        if (!ElementValidator.checkValidateEdit((IJavaElement)cu, this.getShell(), JavaEditorMessages.getString("AddImportOnSelection.error.title"))) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        if (cu != null) {
            ISelection s = this.fEditor.getSelectionProvider().getSelection();
            IDocument doc = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
            ITextSelection selection = (ITextSelection)s;
            if (doc != null) {
                try {
                    int nameStart = this.getNameStart(doc, selection.getOffset());
                    int nameEnd = this.getNameEnd(doc, selection.getOffset() + selection.getLength());
                    int len = nameEnd - nameStart;
                    String name = doc.get(nameStart, len).trim();
                    String simpleName = Signature.getSimpleName((String)name);
                    String containerName = Signature.getQualifier((String)name);
                    IImportDeclaration existingImport = JavaModelUtil.findImport(cu, simpleName);
                    if (existingImport != null) {
                        if (!existingImport.getElementName().equals(name)) {
                            this.getShell().getDisplay().beep();
                            IStatusLineManager manager = this.getStatusLineManager();
                            if (manager != null) {
                                String message = JavaEditorMessages.getFormattedString("AddImportOnSelection.error.importclash", existingImport.getElementName());
                                manager.setErrorMessage(message);
                            }
                        } else {
                            this.removeQualification(doc, nameStart, containerName);
                        }
                        return;
                    }
                    IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{cu.getJavaProject()});
                    TypeInfo[] types = AddImportOnSelectionAction.findAllTypes(simpleName, searchScope, null);
                    if (types.length == 0) {
                        this.getShell().getDisplay().beep();
                        return;
                    }
                    TypeInfo chosen = this.selectResult(types, containerName, this.getShell());
                    if (chosen == null) {
                        return;
                    }
                    IType type = chosen.resolveType(searchScope);
                    if (type == null) {
                        JavaPlugin.logErrorMessage("AddImportOnSelectionAction: Failed to resolve TypeRef: " + chosen.toString());
                        MessageDialog.openError((Shell)this.getShell(), (String)JavaEditorMessages.getString("AddImportOnSelection.error.title"), (String)JavaEditorMessages.getString("AddImportOnSelection.error.notresolved.message"));
                        return;
                    }
                    this.removeQualification(doc, nameStart, chosen.getTypeContainerName());
                    CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
                    AddImportsOperation op = new AddImportsOperation(cu, new IJavaElement[]{type}, settings, false);
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                    try {
                        dialog.run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op));
                    }
                    catch (InvocationTargetException e) {
                        ExceptionHandler.handle(e, this.getShell(), JavaEditorMessages.getString("AddImportOnSelection.error.title"), null);
                    }
                    catch (InterruptedException interruptedException) {}
                    return;
                }
                catch (CoreException e) {
                    ExceptionHandler.handle(e, this.getShell(), JavaEditorMessages.getString("AddImportOnSelection.error.title"), null);
                }
                catch (BadLocationException e) {
                    JavaPlugin.log(e);
                    MessageDialog.openError((Shell)this.getShell(), (String)JavaEditorMessages.getString("AddImportOnSelection.error.title"), (String)e.getMessage());
                }
            }
        }
    }

    private int getNameStart(IDocument doc, int pos) throws BadLocationException {
        while (pos > 0) {
            char ch = doc.getChar(pos - 1);
            if (!Character.isJavaIdentifierPart(ch) && ch != '.') {
                return pos;
            }
            --pos;
        }
        return pos;
    }

    private int getNameEnd(IDocument doc, int pos) throws BadLocationException {
        if (pos > 0 && Character.isWhitespace(doc.getChar(pos - 1))) {
            return pos;
        }
        int len = doc.getLength();
        while (pos < len) {
            char ch = doc.getChar(pos);
            if (!Character.isJavaIdentifierPart(ch)) {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    private void removeQualification(IDocument doc, int nameStart, String containerName) throws BadLocationException {
        int containerLen = containerName.length();
        int docLen = doc.getLength();
        if (containerLen > 0 && nameStart + containerLen + 1 < docLen) {
            int k = 0;
            while (k < containerLen) {
                if (doc.getChar(nameStart + k) != containerName.charAt(k)) {
                    return;
                }
                ++k;
            }
            if (doc.getChar(nameStart + containerLen) == '.') {
                doc.replace(nameStart, containerLen + 1, "");
            }
        }
    }

    private static TypeInfo[] findAllTypes(String simpleTypeName, IJavaSearchScope searchScope, IProgressMonitor monitor) throws CoreException {
        SearchEngine searchEngine = new SearchEngine();
        ArrayList typeRefsFound = new ArrayList(10);
        TypeInfoRequestor requestor = new TypeInfoRequestor(typeRefsFound);
        searchEngine.searchAllTypeNames(JavaPlugin.getWorkspace(), null, simpleTypeName.toCharArray(), 0, true, 0, searchScope, (ITypeNameRequestor)requestor, 3, monitor);
        return typeRefsFound.toArray(new TypeInfo[typeRefsFound.size()]);
    }

    private Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    private TypeInfo selectResult(TypeInfo[] results, String containerName, Shell shell) {
        int nResults = results.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return results[0];
        }
        if (containerName.length() != 0) {
            int i = 0;
            while (i < nResults) {
                TypeInfo curr = results[i];
                if (containerName.equals(curr.getTypeContainerName())) {
                    return curr;
                }
                ++i;
            }
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new TypeInfoLabelProvider(1));
        dialog.setTitle(JavaEditorMessages.getString("AddImportOnSelection.dialog.title"));
        dialog.setMessage(JavaEditorMessages.getString("AddImportOnSelection.dialog.message"));
        dialog.setElements((Object[])results);
        if (dialog.open() == 0) {
            return (TypeInfo)dialog.getFirstResult();
        }
        return null;
    }

    private IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.fEditor.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }
}

