/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.jarpackager.CheckboxTreeAndListGroup;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocMemberContentProvider;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocProjectContentProvider;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocWizard;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocWizardPage;
import org.eclipse.jdt.internal.ui.preferences.JavadocPreferencePage;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavadocTreeWizardPage
extends JavadocWizardPage {
    private CheckboxTreeAndListGroup fInputGroup;
    protected IWorkspaceRoot fRoot;
    protected String fWorkspace;
    protected Text fDestinationText;
    protected Text fJavadocCommandText;
    protected Text fDocletText;
    protected Text fDocletTypeText;
    protected Button fStandardButton;
    protected Button fDestinationBrowserButton;
    protected Button fCustomButton;
    protected Button fPrivateVisibility;
    protected Button fProtectedVisibility;
    protected Button fPackageVisibility;
    protected Button fPublicVisibility;
    private Label fDocletLabel;
    private Label fDocletTypeLabel;
    private Label fDestinationLabel;
    private CLabel fDescriptionLabel;
    protected String fVisibilitySelection;
    protected boolean fDocletSelected;
    private JavadocOptionsManager fStore;
    private JavadocWizard fWizard;
    protected StatusInfo fJavadocStatus;
    protected StatusInfo fDestinationStatus;
    protected StatusInfo fDocletStatus;
    protected StatusInfo fTreeStatus;
    protected StatusInfo fPreferenceStatus;
    protected StatusInfo fWizardStatus;
    private final int PREFERENCESTATUS = 0;
    private final int CUSTOMSTATUS = 1;
    private final int STANDARDSTATUS = 2;
    private final int TREESTATUS = 3;
    private final int JAVADOCSTATUS = 4;

    protected JavadocTreeWizardPage(String pageName, JavadocOptionsManager store) {
        super(pageName);
        this.setDescription(JavadocExportMessages.getString("JavadocTreeWizardPage.javadoctreewizardpage.description"));
        this.fStore = store;
        this.fJavadocStatus = new StatusInfo();
        this.fDestinationStatus = new StatusInfo();
        this.fDocletStatus = new StatusInfo();
        this.fTreeStatus = new StatusInfo();
        this.fPreferenceStatus = new StatusInfo();
        this.fWizardStatus = store.getWizardStatus();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fWizard = (JavadocWizard)this.getWizard();
        Composite composite = new Composite(parent, 0);
        GridLayout compositeGridLayout = new GridLayout();
        composite.setLayoutData((Object)this.createGridData(1808, 0, 0));
        compositeGridLayout.numColumns = 6;
        composite.setLayout((Layout)compositeGridLayout);
        this.createJavadocCommandSet(composite);
        this.createInputGroup(composite);
        this.createVisibilitySet(composite);
        this.createOptionsSet(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.javadoc_tree_page_context");
    }

    protected void createJavadocCommandSet(Composite composite) {
        GridLayout commandSetLayout = this.createGridLayout(2);
        commandSetLayout.marginHeight = 0;
        commandSetLayout.marginWidth = 0;
        Composite c = new Composite(composite, 0);
        c.setLayoutData((Object)this.createGridData(1808, 6, 0));
        c.setLayout((Layout)commandSetLayout);
        this.createLabel(c, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.javadoccommand.label"), this.createGridData(32, 2, 0));
        this.fJavadocCommandText = this.createText(c, 2060, null, this.createGridData(768, 1, 0));
        ((GridData)this.fJavadocCommandText.getLayoutData()).widthHint = 200;
        this.fJavadocCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocTreeWizardPage.this.doValidation(4);
            }
        });
        Button javadocCommandBrowserButton = this.createButton(c, 8, JavadocExportMessages.getString("JavadocTreeWizardPage.javadoccommand.button.label"), this.createGridData(256, 1, 0));
        SWTUtil.setButtonDimensionHint(javadocCommandBrowserButton);
        javadocCommandBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavadocPreferencePage page = new JavadocPreferencePage();
                JavadocTreeWizardPage.this.showPreferencePage("org.eclipse.jdt.ui.preferences.JavadocPreferencePage", (IPreferencePage)page);
                JavadocTreeWizardPage.this.fJavadocCommandText.setText(JavadocPreferencePage.getJavaDocCommand());
            }
        });
    }

    protected void createInputGroup(Composite composite) {
        this.createLabel(composite, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.checkboxtreeandlistgroup.label"), this.createGridData(6));
        Composite c = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)this.createGridData(1808, 6, 0));
        JavadocProjectContentProvider treeContentProvider = new JavadocProjectContentProvider();
        JavadocMemberContentProvider listContentProvider = new JavadocMemberContentProvider();
        this.fInputGroup = new CheckboxTreeAndListGroup(c, this.fStore.getRoot(), treeContentProvider, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (IStructuredContentProvider)listContentProvider, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), 0, this.convertWidthInCharsToPixels(60), this.convertHeightInCharsToPixels(10));
        this.fInputGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                JavadocTreeWizardPage.this.doValidation(3);
                JavadocTreeWizardPage.this.fWizard.removeAllProjects();
                JavadocTreeWizardPage.this.setProjects();
            }
        });
        if (!this.fStore.getJavaProjects().isEmpty()) {
            this.setTreeChecked(this.fStore.getSelectedElements(), (IJavaProject)this.fStore.getJavaProjects().get(0));
        }
        this.fInputGroup.aboutToOpen();
    }

    private void createVisibilitySet(Composite composite) {
        GridLayout visibilityLayout = this.createGridLayout(4);
        visibilityLayout.marginHeight = 0;
        visibilityLayout.marginWidth = 0;
        Composite visibilityGroup = new Composite(composite, 0);
        visibilityGroup.setLayoutData((Object)this.createGridData(768, 6, 0));
        visibilityGroup.setLayout((Layout)visibilityLayout);
        this.createLabel(visibilityGroup, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.visibilitygroup.label"), this.createGridData(768, 4, 0));
        this.fPrivateVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.privatebutton.label"), this.createGridData(768, 1, 0));
        this.fPackageVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.packagebutton.label"), this.createGridData(768, 1, 0));
        this.fProtectedVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.protectedbutton.label"), this.createGridData(768, 1, 0));
        this.fPublicVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.publicbutton.label"), this.createGridData(768, 1, 0));
        this.fDescriptionLabel = new CLabel(visibilityGroup, 16384);
        this.fDescriptionLabel.setLayoutData((Object)this.createGridData(768, 4, this.convertWidthInCharsToPixels(3) - 3));
        this.fPrivateVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PRIVATE;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.privatevisibilitydescription.label"));
                }
            }
        });
        this.fPackageVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PACKAGE;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.packagevisibledescription.label"));
                }
            }
        });
        this.fProtectedVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PROTECTED;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.protectedvisibilitydescription.label"));
                }
            }
        });
        this.fPublicVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PUBLIC;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.publicvisibilitydescription.label"));
                }
            }
        });
        this.setVisibilitySettings();
    }

    protected void setVisibilitySettings() {
        this.fVisibilitySelection = this.fStore.getAccess();
        this.fPrivateVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PRIVATE));
        if (this.fPrivateVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.privatevisibilitydescription.label"));
        }
        this.fProtectedVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PROTECTED));
        if (this.fProtectedVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.protectedvisibilitydescription.label"));
        }
        this.fPackageVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PACKAGE));
        if (this.fPackageVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.packagevisibledescription.label"));
        }
        this.fPublicVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PUBLIC));
        if (this.fPublicVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.publicvisibilitydescription.label"));
        }
    }

    private void createOptionsSet(Composite composite) {
        GridLayout optionSetLayout = this.createGridLayout(3);
        optionSetLayout.marginHeight = 0;
        optionSetLayout.marginWidth = 0;
        Composite optionSetGroup = new Composite(composite, 0);
        optionSetGroup.setLayoutData((Object)this.createGridData(1808, 6, 0));
        optionSetGroup.setLayout((Layout)optionSetLayout);
        this.fStandardButton = this.createButton(optionSetGroup, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.standarddocletbutton.label"), this.createGridData(256, 3, 0));
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.fDestinationLabel = this.createLabel(optionSetGroup, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.destinationfield.label"), this.createGridData(32, 1, this.convertWidthInCharsToPixels(3)));
        this.fDestinationText = this.createText(optionSetGroup, 2052, null, this.createGridData(768, 1, 0));
        ((GridData)this.fDestinationText.getLayoutData()).widthHint = 200;
        this.fDestinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocTreeWizardPage.this.doValidation(2);
            }
        });
        this.fDestinationBrowserButton = this.createButton(optionSetGroup, 8, JavadocExportMessages.getString("JavadocTreeWizardPage.destinationbrowse.label"), this.createGridData(256, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fDestinationBrowserButton);
        this.fCustomButton = this.createButton(optionSetGroup, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.customdocletbutton.label"), this.createGridData(3));
        this.fDocletTypeLabel = this.createLabel(optionSetGroup, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.docletnamefield.label"), this.createGridData(256, 1, this.convertWidthInCharsToPixels(3)));
        this.fDocletTypeText = this.createText(optionSetGroup, 2052, null, this.createGridData(256, 2, 0));
        this.fDocletTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocTreeWizardPage.this.doValidation(1);
            }
        });
        this.fDocletLabel = this.createLabel(optionSetGroup, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.docletpathfield.label"), this.createGridData(256, 1, this.convertWidthInCharsToPixels(3)));
        this.fDocletText = this.createText(optionSetGroup, 2052, null, this.createGridData(256, 2, 0));
        this.fDocletText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocTreeWizardPage.this.doValidation(1);
            }
        });
        this.fCustomButton.addSelectionListener((SelectionListener)new JavadocWizardPage.EnableSelectionAdapter(new Control[]{this.fDocletLabel, this.fDocletText, this.fDocletTypeLabel, this.fDocletTypeText}, new Control[]{this.fDestinationLabel, this.fDestinationText, this.fDestinationBrowserButton}));
        this.fCustomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavadocTreeWizardPage.this.doValidation(1);
            }
        });
        this.fStandardButton.addSelectionListener((SelectionListener)new JavadocWizardPage.EnableSelectionAdapter(new Control[]{this.fDestinationLabel, this.fDestinationText, this.fDestinationBrowserButton}, new Control[]{this.fDocletLabel, this.fDocletText, this.fDocletTypeLabel, this.fDocletTypeText}));
        this.fStandardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavadocTreeWizardPage.this.doValidation(2);
            }
        });
        this.fDestinationBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String text = JavadocTreeWizardPage.this.handleFolderBrowseButtonPressed(JavadocTreeWizardPage.this.fDestinationText.getText(), JavadocTreeWizardPage.this.fDestinationText.getShell(), JavadocExportMessages.getString("JavadocTreeWizardPage.destinationbrowsedialog.title"), JavadocExportMessages.getString("JavadocTreeWizardPage.destinationbrowsedialog.label"));
                JavadocTreeWizardPage.this.fDestinationText.setText(text);
            }
        });
        this.setOptionSetSettings();
    }

    public boolean getCustom() {
        return this.fCustomButton.getSelection();
    }

    private void setOptionSetSettings() {
        if (!this.fStore.fromStandard()) {
            this.fCustomButton.setSelection(true);
            this.fDocletText.setText(this.fStore.getDocletPath());
            this.fDocletTypeText.setText(this.fStore.getDocletName());
            this.fDestinationText.setText(this.fStore.getDestination((IJavaProject)this.fWizard.getSelectedProjects().iterator().next()));
            this.fDestinationText.setEnabled(false);
            this.fDestinationBrowserButton.setEnabled(false);
            this.fDestinationLabel.setEnabled(false);
        } else {
            this.fStandardButton.setSelection(true);
            if (this.fWizard.getSelectedProjects().size() == 1) {
                this.fDestinationText.setText(this.fStore.getDestination((IJavaProject)this.fWizard.getSelectedProjects().iterator().next()));
            } else {
                this.fDestinationText.setText(this.fStore.getDestination());
            }
            this.fDocletText.setText(this.fStore.getDocletPath());
            this.fDocletTypeText.setText(this.fStore.getDocletName());
            this.fDocletText.setEnabled(false);
            this.fDocletLabel.setEnabled(false);
            this.fDocletTypeText.setEnabled(false);
            this.fDocletTypeLabel.setEnabled(false);
        }
        String javadocCommand = JavadocPreferencePage.getJavaDocCommand();
        this.fJavadocCommandText.setText(javadocCommand);
        this.fJavadocCommandText.setToolTipText(javadocCommand);
    }

    protected void setTreeChecked(IJavaElement[] sourceElements, IJavaProject project) {
        if (sourceElements.length < 1) {
            this.fInputGroup.initialCheckTreeItem(project);
        } else {
            int i = 0;
            while (i < sourceElements.length) {
                IPackageFragmentRoot root;
                IJavaElement curr = sourceElements[i];
                if (curr instanceof ICompilationUnit) {
                    this.fInputGroup.initialCheckListItem(curr);
                } else if (curr instanceof IPackageFragment) {
                    this.fInputGroup.initialCheckTreeItem(curr);
                } else if (curr instanceof IJavaProject) {
                    this.fInputGroup.initialCheckTreeItem(curr);
                } else if (curr instanceof IPackageFragmentRoot && !(root = (IPackageFragmentRoot)curr).isArchive()) {
                    this.fInputGroup.initialCheckTreeItem(curr);
                }
                ++i;
            }
        }
    }

    private IPath[] getSourcePath(IJavaProject[] projects) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        int k = 0;
        while (k < projects.length) {
            IJavaProject iJavaProject = projects[k];
            try {
                IPackageFragmentRoot[] roots = iJavaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IPath p;
                    IResource resource;
                    IPackageFragmentRoot curr = roots[i];
                    if (curr.getKind() == 1 && (resource = curr.getResource()) != null && (p = resource.getLocation()) != null) {
                        res.add(p);
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            ++k;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getClassPath(IJavaProject[] javaProjects) {
        ArrayList<Path> res = new ArrayList<Path>();
        int j = 0;
        while (j < javaProjects.length) {
            IJavaProject iJavaProject = javaProjects[j];
            try {
                IPath p = iJavaProject.getProject().getLocation();
                if (p != null) {
                    IPath outputLocation = p.append(iJavaProject.getOutputLocation());
                    String[] classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)iJavaProject);
                    int i = 0;
                    while (i < classPath.length) {
                        String curr = classPath[i];
                        Path path = new Path(curr);
                        if (!outputLocation.equals((Object)path)) {
                            res.add(path);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            ++j;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IJavaElement[] getSourceElements(IJavaProject[] projects) {
        ArrayList<Object> res = new ArrayList<Object>();
        try {
            Set allChecked = this.fInputGroup.getAllCheckedTreeItems();
            HashSet<String> incompletePackages = new HashSet<String>();
            int h = 0;
            while (h < projects.length) {
                IJavaProject iJavaProject = projects[h];
                IPackageFragmentRoot[] roots = iJavaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IPackageFragmentRoot root = roots[i];
                    if (root.getKind() == 1) {
                        IJavaElement[] packs = root.getChildren();
                        int k = 0;
                        while (k < packs.length) {
                            IJavaElement curr = packs[k];
                            if (curr.getElementType() == 4 && (curr.getElementName().length() == 0 || !allChecked.contains(curr) || this.fInputGroup.isTreeItemGreyChecked(curr))) {
                                incompletePackages.add(curr.getElementName());
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
                ++h;
            }
            Iterator checkedElements = this.fInputGroup.getAllCheckedListItems();
            while (checkedElements.hasNext()) {
                ICompilationUnit unit;
                Object element = checkedElements.next();
                if (!(element instanceof ICompilationUnit) || !incompletePackages.contains((unit = (ICompilationUnit)element).getParent().getElementName())) continue;
                res.add(unit);
            }
            HashSet<String> addedPackages = new HashSet<String>();
            checkedElements = allChecked.iterator();
            while (checkedElements.hasNext()) {
                IPackageFragment fragment;
                String name;
                Object element = checkedElements.next();
                if (!(element instanceof IPackageFragment) || incompletePackages.contains(name = (fragment = (IPackageFragment)element).getElementName()) || addedPackages.contains(name)) continue;
                res.add(fragment);
                addedPackages.add(name);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return res.toArray(new IJavaElement[res.size()]);
    }

    protected void finish() {
        if (this.fCustomButton.getSelection()) {
            this.fStore.setDocletName(this.fDocletTypeText.getText());
            this.fStore.setDocletPath(this.fDocletText.getText());
            this.fStore.setFromStandard(false);
        }
        if (this.fStandardButton.getSelection()) {
            this.fStore.setFromStandard(true);
            if (this.fWizard.getSelectedProjects().size() == 1) {
                this.fStore.setDestination((IJavaProject)this.fWizard.getSelectedProjects().iterator().next(), this.fDestinationText.getText());
            }
            this.fStore.setDestination(this.fDestinationText.getText());
        }
        IJavaProject[] projects = this.fWizard.getSelectedProjects().toArray(new IJavaProject[this.fWizard.getSelectedProjects().size()]);
        this.fStore.setProjects(projects, true);
        this.fStore.setSourcepath(this.getSourcePath(projects));
        this.fStore.setClasspath(this.getClassPath(projects));
        this.fStore.setAccess(this.fVisibilitySelection);
        this.fStore.setSourceElements(this.getSourceElements(projects));
    }

    protected void setProjects() {
        TreeItem[] treeItems = this.fInputGroup.getTree().getItems();
        int i = 0;
        while (i < treeItems.length) {
            if (treeItems[i].getChecked()) {
                this.fWizard.addSelectedProject((IJavaProject)treeItems[i].getData());
            }
            ++i;
        }
    }

    private void doValidation(int validate) {
        switch (validate) {
            case 0: {
                this.fPreferenceStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 1: {
                if (!this.fCustomButton.getSelection()) break;
                this.fDestinationStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                String doclet = this.fDocletTypeText.getText();
                String docletPath = this.fDocletText.getText();
                if (doclet.length() == 0) {
                    this.fDocletStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.nodocletname.error"));
                } else if (JavaConventions.validateJavaTypeName((String)doclet).matches(4)) {
                    this.fDocletStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.invaliddocletname.error"));
                } else if (docletPath.length() == 0 || !this.validDocletPath(docletPath)) {
                    this.fDocletStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.invaliddocletpath.error"));
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 2: {
                if (!this.fStandardButton.getSelection()) break;
                this.fDestinationStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                Path path = new Path(this.fDestinationText.getText());
                if (Path.ROOT.equals((Object)path) || Path.EMPTY.equals((Object)path)) {
                    this.fDestinationStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.nodestination.error"));
                }
                File file = new File(path.toOSString());
                if (!path.isValidPath(path.toOSString()) || file.isFile()) {
                    this.fDestinationStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.invaliddestination.error"));
                }
                if (path.append("package-list").toFile().exists() || path.append("index.html").toFile().exists()) {
                    this.fDestinationStatus.setWarning(JavadocExportMessages.getString("JavadocTreeWizardPage.warning.mayoverwritefiles"));
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 3: {
                this.fTreeStatus = new StatusInfo();
                if (this.fInputGroup.getAllCheckedTreeItems().size() == 0) {
                    this.fTreeStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.invalidtreeselection.error"));
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 4: {
                this.fJavadocStatus = new StatusInfo();
                Path path = new Path(this.fJavadocCommandText.getText());
                if (!path.toFile().isFile()) {
                    this.fJavadocStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.javadoccommandfile.error"));
                }
                this.updateStatus(this.findMostSevereStatus());
            }
        }
    }

    private boolean validDocletPath(String docletPath) {
        StringTokenizer tokens = new StringTokenizer(docletPath, ";");
        while (tokens.hasMoreTokens()) {
            File file = new File(tokens.nextToken());
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    private boolean showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager);
        boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode, result){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$targetNode = iPreferenceNode;
                this.val$result = blArray;
            }

            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                this.val$result[0] = dialog.open() == 0;
            }
        });
        return result[0];
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fJavadocStatus, this.fPreferenceStatus, this.fDestinationStatus, this.fDocletStatus, this.fTreeStatus, this.fWizardStatus});
    }

    public void init() {
        this.updateStatus(new StatusInfo());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.doValidation(4);
            this.doValidation(2);
            this.doValidation(1);
            this.doValidation(3);
            this.doValidation(0);
        }
    }

    public IPath getDestination() {
        if (this.fStandardButton.getSelection()) {
            return new Path(this.fDestinationText.getText());
        }
        return null;
    }
}

