/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocWizard;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocWizardPage;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavadocSpecificsWizardPage
extends JavadocWizardPage {
    protected Button fAntBrowseButton;
    private Button fCheckbrowser;
    protected Text fAntText;
    protected Button fOverViewButton;
    private Button fOverViewBrowseButton;
    protected Button fAntButton;
    private Button fJDK14Button;
    private Composite fLowerComposite;
    protected Text fOverViewText;
    protected Text fExtraOptionsText;
    private StatusInfo fOverviewStatus;
    private StatusInfo fAntStatus;
    private JavadocOptionsManager fStore;
    private JavadocWizard fWizard;
    private final int OVERVIEWSTATUS = 1;
    private final int ANTSTATUS = 2;

    protected JavadocSpecificsWizardPage(String pageName, JavadocOptionsManager store) {
        super(pageName);
        this.setDescription(JavadocExportMessages.getString("JavadocSpecificsWizardPage.description"));
        this.fStore = store;
        this.fOverviewStatus = new StatusInfo();
        this.fAntStatus = new StatusInfo();
    }

    public void createControl(Composite parent) {
        this.fWizard = (JavadocWizard)this.getWizard();
        this.fLowerComposite = new Composite(parent, 0);
        this.fLowerComposite.setLayoutData((Object)this.createGridData(1808, 1, 0));
        GridLayout layout = this.createGridLayout(3);
        layout.marginHeight = 0;
        this.fLowerComposite.setLayout((Layout)layout);
        this.createExtraOptionsGroup(this.fLowerComposite);
        this.createAntGroup(this.fLowerComposite);
        this.setControl((Control)this.fLowerComposite);
        Dialog.applyDialogFont((Control)this.fLowerComposite);
        WorkbenchHelp.setHelp((Control)this.fLowerComposite, (String)"org.eclipse.jdt.ui.javadoc_specifics_page_context");
    }

    private void createExtraOptionsGroup(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)this.createGridLayout(3));
        c.setLayoutData((Object)this.createGridData(768, 3, 0));
        ((GridLayout)c.getLayout()).marginWidth = 0;
        this.fOverViewButton = this.createButton(c, 32, JavadocExportMessages.getString("JavadocSpecificsWizardPage.overviewbutton.label"), this.createGridData(1));
        this.fOverViewText = this.createText(c, 2052, null, this.createGridData(768, 1, 0));
        ((GridData)this.fOverViewText.getLayoutData()).widthHint = 200;
        this.fOverViewBrowseButton = this.createButton(c, 8, JavadocExportMessages.getString("JavadocSpecificsWizardPage.overviewbrowse.label"), this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fOverViewBrowseButton);
        String str = this.fStore.getOverview();
        if (str.equals("")) {
            this.fOverViewText.setEnabled(false);
            this.fOverViewBrowseButton.setEnabled(false);
        } else {
            this.fOverViewButton.setSelection(true);
            this.fOverViewText.setText(str);
        }
        this.createLabel(composite, 0, JavadocExportMessages.getString("JavadocSpecificsWizardPage.extraoptionsfield.label"), this.createGridData(32, 3, 0));
        this.fExtraOptionsText = this.createText(composite, 2882, null, this.createGridData(1296, 3, 0));
        str = this.fStore.getAdditionalParams();
        this.fExtraOptionsText.setText(str);
        this.fJDK14Button = this.createButton(composite, 32, JavadocExportMessages.getString("JavadocSpecificsWizardPage.jdk14mode.label"), this.createGridData(3));
        this.fJDK14Button.setSelection(this.fStore.isJDK14Mode());
        this.fOverViewButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fOverViewBrowseButton, this.fOverViewText}){

            public void validate() {
                JavadocSpecificsWizardPage.this.doValidation(1);
            }
        });
        this.fOverViewText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocSpecificsWizardPage.this.doValidation(1);
            }
        });
        this.fOverViewBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavadocSpecificsWizardPage.this.handleFileBrowseButtonPressed(JavadocSpecificsWizardPage.this.fOverViewText, new String[]{"*.html"}, JavadocExportMessages.getString("JavadocSpecificsWizardPage.overviewbrowsedialog.title"));
            }
        });
    }

    private void createAntGroup(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)this.createGridLayout(3));
        c.setLayoutData((Object)this.createGridData(768, 3, 0));
        ((GridLayout)c.getLayout()).marginWidth = 0;
        this.fAntButton = this.createButton(c, 32, JavadocExportMessages.getString("JavadocSpecificsWizardPage.antscriptbutton.label"), this.createGridData(3));
        this.createLabel(c, 0, JavadocExportMessages.getString("JavadocSpecificsWizardPage.antscripttext.label"), this.createGridData(32, 1, 0));
        this.fAntText = this.createText(c, 2052, null, this.createGridData(768, 1, 0));
        ((GridData)this.fAntText.getLayoutData()).widthHint = 200;
        if (this.fWizard.getSelectedProjects().size() == 1) {
            this.fAntText.setText(this.fStore.getSpecificAntpath((IJavaProject)this.fWizard.getSelectedProjects().iterator().next()));
        } else {
            this.fAntText.setText(this.fStore.getGeneralAntpath());
        }
        this.fAntBrowseButton = this.createButton(c, 8, JavadocExportMessages.getString("JavadocSpecificsWizardPage.antscriptbrowse.label"), this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fAntBrowseButton);
        this.fAntButton.setEnabled(this.fWizard.getSelectedProjects().size() != 1);
        this.fAntText.setEnabled(this.fAntButton.getEnabled());
        this.fAntBrowseButton.setEnabled(this.fAntButton.getEnabled());
        this.fCheckbrowser = this.createButton(c, 32, JavadocExportMessages.getString("JavadocSpecificsWizardPage.openbrowserbutton.label"), this.createGridData(3));
        this.fCheckbrowser.setSelection(this.fStore.doOpenInBrowser());
        this.fAntButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fAntText, this.fAntBrowseButton}){

            public void validate() {
                JavadocSpecificsWizardPage.this.doValidation(2);
            }
        });
        this.fAntText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocSpecificsWizardPage.this.doValidation(2);
            }
        });
        this.fAntBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String temp = JavadocSpecificsWizardPage.this.fAntText.getText();
                Path path = new Path(temp);
                String file = path.lastSegment();
                if (file == null) {
                    file = "javadoc.xml";
                }
                path = path.removeLastSegments(1);
                temp = JavadocSpecificsWizardPage.this.handleFolderBrowseButtonPressed(path.toOSString(), JavadocSpecificsWizardPage.this.fAntText.getShell(), JavadocExportMessages.getString("JavadocSpecificsWizardPage.antscriptbrowsedialog.title"), JavadocExportMessages.getString("JavadocSpecificsWizardPage.antscriptbrowsedialog.label"));
                path = new Path(temp);
                path = path.addTrailingSeparator().append(file);
                JavadocSpecificsWizardPage.this.fAntText.setText(path.toOSString());
            }
        });
    }

    private void doValidation(int VALIDATE) {
        File file = null;
        String ext = null;
        Path path = null;
        switch (VALIDATE) {
            case 1: {
                this.fOverviewStatus = new StatusInfo();
                if (!this.fOverViewButton.getSelection()) break;
                path = new Path(this.fOverViewText.getText());
                file = path.toFile();
                ext = path.getFileExtension();
                if (file == null || !file.exists()) {
                    this.fOverviewStatus.setError(JavadocExportMessages.getString("JavadocSpecificsWizardPage.overviewnotfound.error"));
                    break;
                }
                if (ext != null && ext.equalsIgnoreCase("html")) break;
                this.fOverviewStatus.setError(JavadocExportMessages.getString("JavadocSpecificsWizardPage.overviewincorrect.error"));
                break;
            }
            case 2: {
                this.fAntStatus = new StatusInfo();
                if (!this.fAntButton.getSelection()) break;
                path = new Path(this.fAntText.getText());
                ext = path.getFileExtension();
                IPath antSeg = path.removeLastSegments(1);
                if (!antSeg.isValidPath(antSeg.toOSString()) || ext == null || !ext.equalsIgnoreCase("xml")) {
                    this.fAntStatus.setError(JavadocExportMessages.getString("JavadocSpecificsWizardPage.antfileincorrect.error"));
                    break;
                }
                if (!path.toFile().exists()) break;
                this.fAntStatus.setWarning(JavadocExportMessages.getString("JavadocSpecificsWizardPage.antfileoverwrite.warning"));
            }
        }
        this.updateStatus(this.findMostSevereStatus());
    }

    protected void finish() {
        String str = this.fExtraOptionsText.getText();
        if (str.length() > 0) {
            this.fStore.setAdditionalParams(str);
        } else {
            this.fStore.setAdditionalParams("");
        }
        if (this.fOverViewText.getEnabled()) {
            this.fStore.setOverview(this.fOverViewText.getText());
        } else {
            this.fStore.setOverview("");
        }
        if (this.fAntText.getEnabled()) {
            this.fStore.setGeneralAntpath(this.fAntText.getText());
            if (this.fWizard.getSelectedProjects().size() == 1) {
                this.fStore.setSpecificAntpath((IJavaProject)this.fWizard.getSelectedProjects().iterator().next(), this.fAntText.getText());
            }
        }
        this.fStore.setOpenInBrowser(this.fCheckbrowser.getSelection());
        this.fStore.setJDK14Mode(this.fJDK14Button.getSelection());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fAntButton.setEnabled(this.fWizard.getSelectedProjects().size() == 1);
            this.doValidation(1);
            this.doValidation(2);
        }
    }

    public void init() {
        this.updateStatus(new StatusInfo());
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fAntStatus, this.fOverviewStatus});
    }

    public boolean generateAnt() {
        return this.fAntButton.getSelection();
    }
}

