/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocReader;
import org.eclipse.jdt.internal.ui.preferences.JavadocPreferencePage;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JavadocOptionsManager {
    private IWorkspaceRoot fRoot = ResourcesPlugin.getWorkspace().getRoot();
    private List fProjects;
    private IFile fXmlfile;
    private StatusInfo fWizardStatus;
    private List fSourceElements;
    private List fSelectedElements;
    private String fAccess;
    private String fDocletpath;
    private String fDocletname;
    private boolean fFromStandard;
    private String fStylesheet;
    private String fAdditionalParams;
    private String fOverview;
    private String fTitle;
    private IPath[] fSourcepath;
    private IPath[] fClasspath;
    private boolean fNotree;
    private boolean fNoindex;
    private boolean fSplitindex;
    private boolean fNonavbar;
    private boolean fNodeprecated;
    private boolean fNoDeprecatedlist;
    private boolean fAuthor;
    private boolean fVersion;
    private boolean fUse;
    private boolean fJDK14Mode;
    private boolean fOpenInBrowser;
    private Map fLinks;
    private String fDestination;
    private String fDependencies;
    private String fAntpath;
    public final String PRIVATE = "private";
    public final String PROTECTED = "protected";
    public final String PACKAGE = "package";
    public final String PUBLIC = "public";
    public final String USE = "use";
    public final String NOTREE = "notree";
    public final String NOINDEX = "noindex";
    public final String NONAVBAR = "nonavbar";
    public final String NODEPRECATED = "nodeprecated";
    public final String NODEPRECATEDLIST = "nodeprecatedlist";
    public final String VERSION = "version";
    public final String AUTHOR = "author";
    public final String SPLITINDEX = "splitindex";
    public final String STYLESHEETFILE = "stylesheetfile";
    public final String OVERVIEW = "overview";
    public final String DOCLETNAME = "docletname";
    public final String DOCLETPATH = "docletpath";
    public final String SOURCEPATH = "sourcepath";
    public final String CLASSPATH = "classpath";
    public final String DESTINATION = "destdir";
    public final String OPENINBROWSER = "openinbrowser";
    public final String VISIBILITY = "access";
    public final String PACKAGENAMES = "packagenames";
    public final String SOURCEFILES = "sourcefiles";
    public final String EXTRAOPTIONS = "additionalparam";
    public final String JAVADOCCOMMAND = "javadoccommand";
    public final String TITLE = "doctitle";
    public final String HREF = "href";
    public final String NAME = "name";
    public final String PATH = "path";
    private final String FROMSTANDARD = "fromStandard";
    private final String ANTPATH = "antpath";
    public final String SOURCE = "source";
    static /* synthetic */ Class class$0;

    public JavadocOptionsManager(IFile xmlJavadocFile, IDialogSettings settings, ISelection currSelection) {
        this.fXmlfile = xmlJavadocFile;
        this.fWizardStatus = new StatusInfo();
        this.fLinks = new HashMap();
        this.fProjects = new ArrayList();
        if (xmlJavadocFile != null) {
            try {
                JavadocReader reader = new JavadocReader(xmlJavadocFile.getContents());
                Element element = reader.readXML();
                IJavaProject p = reader.getProject();
                if (element != null && p != null) {
                    this.fProjects.add(p);
                    this.loadFromXML(element);
                    return;
                }
                this.fWizardStatus.setWarning(JavadocExportMessages.getString("JavadocOptionsManager.antfileincorrectCE.warning"));
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                this.fWizardStatus.setWarning(JavadocExportMessages.getString("JavadocOptionsManager.antfileincorrectCE.warning"));
            }
            catch (IOException e) {
                JavaPlugin.log(e);
                this.fWizardStatus.setWarning(JavadocExportMessages.getString("JavadocOptionsManager.antfileincorrectIOE.warning"));
            }
            catch (SAXException sAXException) {
                this.fWizardStatus.setWarning(JavadocExportMessages.getString("JavadocOptionsManager.antfileincorrectSAXE.warning"));
            }
        }
        if (settings != null) {
            this.loadFromDialogStore(settings, currSelection);
        } else {
            this.loadDefaults(currSelection);
        }
    }

    private void loadFromDialogStore(IDialogSettings settings, ISelection sel) {
        this.fSelectedElements = this.getValidSelection(sel);
        this.fAccess = settings.get("access");
        if (this.fAccess == null) {
            this.fAccess = "protected";
        }
        this.fFromStandard = settings.getBoolean("fromStandard");
        this.fDocletpath = settings.get("docletpath");
        this.fDocletname = settings.get("docletname");
        if (this.fDocletpath == null || this.fDocletname == null) {
            this.fFromStandard = true;
            this.fDocletpath = "";
            this.fDocletname = "";
        }
        this.fAntpath = settings.get("antpath");
        if (this.fAntpath == null) {
            this.fAntpath = "";
        }
        this.fDestination = settings.get("destdir");
        if (this.fDestination == null) {
            this.fDestination = "";
        }
        this.fTitle = settings.get("doctitle");
        if (this.fTitle == null) {
            this.fTitle = "";
        }
        this.fStylesheet = settings.get("stylesheetfile");
        if (this.fStylesheet == null) {
            this.fStylesheet = "";
        }
        this.fAdditionalParams = settings.get("additionalparam");
        if (this.fAdditionalParams == null) {
            this.fAdditionalParams = "";
        }
        this.fOverview = settings.get("overview");
        if (this.fOverview == null) {
            this.fOverview = "";
        }
        this.fUse = this.loadbutton(settings.get("use"));
        this.fAuthor = this.loadbutton(settings.get("author"));
        this.fVersion = this.loadbutton(settings.get("version"));
        this.fNodeprecated = this.loadbutton(settings.get("nodeprecated"));
        this.fNoDeprecatedlist = this.loadbutton(settings.get("nodeprecatedlist"));
        this.fNonavbar = this.loadbutton(settings.get("nonavbar"));
        this.fNoindex = this.loadbutton(settings.get("noindex"));
        this.fNotree = this.loadbutton(settings.get("notree"));
        this.fSplitindex = this.loadbutton(settings.get("splitindex"));
        this.fOpenInBrowser = this.loadbutton(settings.get("openinbrowser"));
        this.fJDK14Mode = this.loadbutton(settings.get("source"));
        this.loadLinksFromDialogSettings(settings);
    }

    private String getDefaultAntPath(IJavaProject project) {
        IPath path;
        if (project != null && (path = project.getProject().getLocation()) != null) {
            return path.append("javadoc.xml").toOSString();
        }
        return "";
    }

    private String getDefaultDestination(IJavaProject project) {
        if (project != null) {
            URL url = JavaUI.getProjectJavadocLocation(project);
            if (url == null || !url.getProtocol().equals("file")) {
                IPath path = project.getProject().getLocation();
                if (path != null) {
                    return path.append("doc").toOSString();
                }
            } else {
                return new File(url.getFile()).getPath();
            }
        }
        return "";
    }

    private void loadLinksFromDialogSettings(IDialogSettings settings) {
        IDialogSettings links;
        if (settings != null && (links = settings.getSection("projects")) != null) {
            IDialogSettings[] projs = links.getSections();
            int i = 0;
            while (i < projs.length) {
                IJavaProject javaProject;
                IDialogSettings iDialogSettings = projs[i];
                String projectName = iDialogSettings.getName();
                IProject project = this.fRoot.getProject(projectName);
                if (project.exists() && !this.fLinks.containsKey(javaProject = JavaCore.create((IProject)project))) {
                    String antpath;
                    String destdir;
                    String hrefs = iDialogSettings.get("href");
                    if (hrefs == null) {
                        hrefs = "";
                    }
                    if ((destdir = iDialogSettings.get("destdir")) == null || destdir.length() == 0) {
                        destdir = this.getDefaultDestination(javaProject);
                    }
                    if ((antpath = iDialogSettings.get("antpath")) == null || antpath.length() == 0) {
                        antpath = this.getDefaultAntPath(javaProject);
                    }
                    ProjectData data = new ProjectData();
                    data.setDestination(destdir);
                    data.setAntpath(antpath);
                    data.setLinks(hrefs);
                    if (!this.fLinks.containsValue(javaProject)) {
                        this.fLinks.put(javaProject, data);
                    }
                }
                ++i;
            }
        }
        IProject[] projects = this.fRoot.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject iProject = projects[i];
            IJavaProject javaProject = JavaCore.create((IProject)iProject);
            if (!this.fLinks.containsKey(javaProject)) {
                ProjectData data = new ProjectData();
                data.setDestination(this.getDefaultDestination(javaProject));
                data.setAntpath(this.getDefaultAntPath(javaProject));
                data.setLinks("");
                this.fLinks.put(javaProject, data);
            }
            ++i;
        }
    }

    private void loadDefaults(ISelection sel) {
        this.fSelectedElements = this.getValidSelection(sel);
        this.fAccess = "public";
        this.fDocletname = "";
        this.fDocletpath = "";
        this.fTitle = "";
        this.fStylesheet = "";
        this.fAdditionalParams = "";
        this.fOverview = "";
        this.fAntpath = "";
        this.fDestination = "";
        this.fUse = true;
        this.fAuthor = true;
        this.fVersion = true;
        this.fNodeprecated = false;
        this.fNoDeprecatedlist = false;
        this.fNonavbar = false;
        this.fNoindex = false;
        this.fNotree = false;
        this.fSplitindex = true;
        this.fOpenInBrowser = false;
        this.fJDK14Mode = false;
        this.fFromStandard = true;
        this.loadLinksFromDialogSettings(null);
    }

    private void loadFromXML(Element element) {
        String destination;
        this.fAccess = element.getAttribute("access");
        if (this.fAccess.length() <= 0) {
            this.fAccess = "protected";
        }
        this.fDestination = destination = element.getAttribute("destdir");
        this.fFromStandard = true;
        this.fDocletname = "";
        this.fDocletpath = "";
        if (destination.equals("")) {
            NodeList list = element.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                if (child.getNodeName().equals("doclet")) {
                    this.fDocletpath = ((Element)child).getAttribute("path");
                    this.fDocletname = ((Element)child).getAttribute("name");
                    if (!this.fDocletpath.equals("") || this.fDocletname.equals("")) {
                        this.fFromStandard = false;
                        break;
                    }
                    this.fDocletname = "";
                    this.fDocletpath = "";
                    break;
                }
                ++i;
            }
        }
        boolean firstTime = true;
        StringBuffer buf = new StringBuffer();
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals("link")) {
                String href = ((Element)child).getAttribute("href");
                if (firstTime) {
                    firstTime = false;
                } else {
                    buf.append(';');
                }
                buf.append(href);
            }
            ++i;
        }
        Iterator iter = this.fProjects.iterator();
        while (iter.hasNext()) {
            IJavaProject iJavaProject = (IJavaProject)iter.next();
            ProjectData data = new ProjectData();
            IPath path = this.fXmlfile.getLocation();
            if (path != null) {
                data.setAntpath(path.toOSString());
            } else {
                data.setAntpath("");
            }
            data.setLinks(buf.toString());
            data.setDestination(destination);
            this.fLinks.put(iJavaProject, data);
        }
        this.setSelectedElementsFromAnt(element, (IJavaProject)this.fProjects.get(0));
        IPath p = this.fXmlfile.getLocation();
        this.fAntpath = p != null ? p.toOSString() : "";
        this.fStylesheet = element.getAttribute("stylesheetfile");
        this.fTitle = element.getAttribute("doctitle");
        this.fAdditionalParams = element.getAttribute("additionalparam");
        this.fOverview = element.getAttribute("overview");
        this.fUse = this.loadbutton(element.getAttribute("use"));
        this.fAuthor = this.loadbutton(element.getAttribute("author"));
        this.fVersion = this.loadbutton(element.getAttribute("version"));
        this.fNodeprecated = this.loadbutton(element.getAttribute("nodeprecated"));
        this.fNoDeprecatedlist = this.loadbutton(element.getAttribute("nodeprecatedlist"));
        this.fNonavbar = this.loadbutton(element.getAttribute("nonavbar"));
        this.fNoindex = this.loadbutton(element.getAttribute("noindex"));
        this.fNotree = this.loadbutton(element.getAttribute("notree"));
        this.fSplitindex = this.loadbutton(element.getAttribute("splitindex"));
    }

    private IPath makeAbsolutePathFromRelative(String pathStr) {
        Path path = new Path(pathStr);
        if (!path.isAbsolute()) {
            if (this.fXmlfile == null) {
                return null;
            }
            IPath basePath = this.fXmlfile.getParent().getLocation();
            if (basePath == null) {
                return null;
            }
            return basePath.append(pathStr);
        }
        return path;
    }

    private void setSelectedElementsFromAnt(Element element, IJavaProject iJavaProject) {
        String sourcefiles;
        String name;
        this.fSelectedElements = new ArrayList();
        String packagenames = element.getAttribute("packagenames");
        if (packagenames != null) {
            StringTokenizer tokenizer = new StringTokenizer(packagenames, ",");
            while (tokenizer.hasMoreTokens()) {
                IJavaElement el;
                name = tokenizer.nextToken().trim();
                try {
                    el = JavaModelUtil.findTypeContainer(iJavaProject, name);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                    continue;
                }
                if (el == null || !(el instanceof IPackageFragment)) continue;
                this.fSelectedElements.add(el);
            }
        }
        if ((sourcefiles = element.getAttribute("sourcefiles")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(sourcefiles, ",");
            while (tokenizer.hasMoreTokens()) {
                IPath path;
                name = tokenizer.nextToken().trim();
                if (!name.endsWith(".java") || (path = this.makeAbsolutePathFromRelative(name)) == null) continue;
                IFile[] files = this.fRoot.findFilesForLocation(path);
                int i = 0;
                while (i < files.length) {
                    ICompilationUnit el;
                    IFile curr = files[i];
                    if (curr.getProject().equals((Object)iJavaProject.getProject()) && (el = JavaCore.createCompilationUnitFrom((IFile)curr)) != null) {
                        this.fSelectedElements.add(el);
                    }
                    ++i;
                }
            }
        }
    }

    public StatusInfo getWizardStatus() {
        return this.fWizardStatus;
    }

    public IJavaElement[] getSelectedElements() {
        return this.fSelectedElements.toArray(new IJavaElement[this.fSelectedElements.size()]);
    }

    public IJavaElement[] getSourceElements() {
        return this.fSourceElements.toArray(new IJavaElement[this.fSourceElements.size()]);
    }

    public String getAccess() {
        return this.fAccess;
    }

    public String getGeneralAntpath() {
        return this.fAntpath;
    }

    public String getSpecificAntpath(IJavaProject project) {
        ProjectData data = (ProjectData)this.fLinks.get(project);
        if (data != null) {
            return data.getAntPath();
        }
        return "";
    }

    public boolean fromStandard() {
        return this.fFromStandard;
    }

    public String getDestination(IJavaProject project) {
        ProjectData data = (ProjectData)this.fLinks.get(project);
        if (data != null) {
            return data.getDestination();
        }
        return "";
    }

    public String getDestination() {
        return this.fDestination;
    }

    public String getDocletPath() {
        return this.fDocletpath;
    }

    public String getDocletName() {
        return this.fDocletname;
    }

    public String getStyleSheet() {
        return this.fStylesheet;
    }

    public String getOverview() {
        return this.fOverview;
    }

    public String getAdditionalParams() {
        return this.fAdditionalParams;
    }

    public IPath[] getClasspath() {
        return this.fClasspath;
    }

    public IPath[] getSourcepath() {
        return this.fSourcepath;
    }

    public IWorkspaceRoot getRoot() {
        return this.fRoot;
    }

    public List getJavaProjects() {
        return this.fProjects;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public String getLinks(IJavaProject project) {
        ProjectData data = (ProjectData)this.fLinks.get(project);
        if (data != null) {
            return data.getLinks();
        }
        return "";
    }

    public String getDependencies() {
        return this.fDependencies;
    }

    public Map getLinkMap() {
        return this.fLinks;
    }

    public boolean doOpenInBrowser() {
        return this.fOpenInBrowser;
    }

    public boolean getBoolean(String flag) {
        if (flag.equals("author")) {
            return this.fAuthor;
        }
        if (flag.equals("version")) {
            return this.fVersion;
        }
        if (flag.equals("use")) {
            return this.fUse;
        }
        if (flag.equals("nodeprecated")) {
            return this.fNodeprecated;
        }
        if (flag.equals("nodeprecatedlist")) {
            return this.fNoDeprecatedlist;
        }
        if (flag.equals("noindex")) {
            return this.fNoindex;
        }
        if (flag.equals("notree")) {
            return this.fNotree;
        }
        if (flag.equals("splitindex")) {
            return this.fSplitindex;
        }
        if (flag.equals("nonavbar")) {
            return this.fNonavbar;
        }
        return false;
    }

    private boolean loadbutton(String value) {
        if (value == null || value.equals("")) {
            return false;
        }
        return value.equals("true");
    }

    private String flatPathList(IPath[] paths) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            if (i > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(paths[i].toOSString());
            ++i;
        }
        return buf.toString();
    }

    public String[] createArgumentArray() {
        int i;
        String[] argsArray;
        ExecutionArguments tokens;
        if (this.fProjects.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(JavadocPreferencePage.getJavaDocCommand());
        if (this.fFromStandard) {
            args.add("-d");
            args.add(this.fDestination);
        } else {
            if (!this.fAdditionalParams.equals("")) {
                tokens = new ExecutionArguments("", this.fAdditionalParams);
                argsArray = tokens.getProgramArgumentsArray();
                i = 0;
                while (i < argsArray.length) {
                    args.add(argsArray[i]);
                    ++i;
                }
            }
            args.add("-doclet");
            args.add(this.fDocletname);
            args.add("-docletpath");
            args.add(this.fDocletpath);
        }
        args.add("-sourcepath");
        args.add(this.flatPathList(this.fSourcepath));
        args.add("-classpath");
        args.add(this.flatPathList(this.fClasspath));
        args.add("-" + this.fAccess);
        if (this.fFromStandard) {
            if (this.fJDK14Mode) {
                args.add("-source");
                args.add("1.4");
            }
            if (this.fUse) {
                args.add("-use");
            }
            if (this.fVersion) {
                args.add("-version");
            }
            if (this.fAuthor) {
                args.add("-author");
            }
            if (this.fNonavbar) {
                args.add("-nonavbar");
            }
            if (this.fNoindex) {
                args.add("-noindex");
            }
            if (this.fNotree) {
                args.add("-notree");
            }
            if (this.fNodeprecated) {
                args.add("-nodeprecated");
            }
            if (this.fNoDeprecatedlist) {
                args.add("-nodeprecatedlist");
            }
            if (this.fSplitindex) {
                args.add("-splitindex");
            }
            if (!this.fTitle.equals("")) {
                args.add("-doctitle");
                args.add(this.fTitle);
            }
            if (!this.fStylesheet.equals("")) {
                args.add("-stylesheetfile");
                args.add(this.fStylesheet);
            }
            if (!this.fAdditionalParams.equals("")) {
                tokens = new ExecutionArguments("", this.fAdditionalParams);
                argsArray = tokens.getProgramArgumentsArray();
                i = 0;
                while (i < argsArray.length) {
                    args.add(argsArray[i]);
                    ++i;
                }
            }
            String hrefs = this.fDependencies;
            StringTokenizer tokenizer = new StringTokenizer(hrefs, ";");
            while (tokenizer.hasMoreElements()) {
                String href = (String)tokenizer.nextElement();
                args.add("-link");
                args.add(href);
            }
        }
        if (!this.fOverview.equals("")) {
            args.add("-overview");
            args.add(this.fOverview);
        }
        int i2 = 0;
        while (i2 < this.fSourceElements.size()) {
            IPath p;
            IJavaElement curr = (IJavaElement)this.fSourceElements.get(i2);
            if (curr instanceof IPackageFragment) {
                args.add(curr.getElementName());
            } else if (curr instanceof ICompilationUnit && (p = curr.getResource().getLocation()) != null) {
                args.add(p.toOSString());
            }
            ++i2;
        }
        String[] res = args.toArray(new String[args.size()]);
        return res;
    }

    /*
     * Exception decompiling
     */
    public void createXML() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 261->265)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IDialogSettings createDialogSettings() {
        DialogSettings settings = new DialogSettings("javadoc");
        settings.put("fromStandard", this.fFromStandard);
        settings.put("docletname", this.fDocletname);
        settings.put("docletpath", this.fDocletpath);
        settings.put("access", this.fAccess);
        settings.put("use", this.fUse);
        settings.put("author", this.fAuthor);
        settings.put("version", this.fVersion);
        settings.put("nodeprecated", this.fNodeprecated);
        settings.put("nodeprecatedlist", this.fNoDeprecatedlist);
        settings.put("splitindex", this.fSplitindex);
        settings.put("noindex", this.fNoindex);
        settings.put("notree", this.fNotree);
        settings.put("nonavbar", this.fNonavbar);
        settings.put("openinbrowser", this.fOpenInBrowser);
        settings.put("source", this.fJDK14Mode);
        if (!this.fAntpath.equals("")) {
            settings.put("antpath", this.fAntpath);
        }
        if (!this.fDestination.equals("")) {
            settings.put("destdir", this.fDestination);
        }
        if (!this.fAdditionalParams.equals("")) {
            settings.put("additionalparam", this.fAdditionalParams);
        }
        if (!this.fOverview.equals("")) {
            settings.put("overview", this.fOverview);
        }
        if (!this.fStylesheet.equals("")) {
            settings.put("stylesheetfile", this.fStylesheet);
        }
        if (!this.fTitle.equals("")) {
            settings.put("doctitle", this.fTitle);
        }
        DialogSettings links = new DialogSettings("projects");
        Set keys = this.fLinks.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            IJavaProject iJavaProject = (IJavaProject)iter.next();
            DialogSettings proj = new DialogSettings(iJavaProject.getElementName());
            if (!keys.contains(iJavaProject)) {
                proj.put("href", "");
                proj.put("destdir", "");
                proj.put("antpath", "");
            } else {
                ProjectData data = (ProjectData)this.fLinks.get(iJavaProject);
                proj.put("href", data.getLinks());
                proj.put("destdir", data.getDestination());
                proj.put("antpath", data.getAntPath());
            }
            links.addSection((IDialogSettings)proj);
        }
        settings.addSection((IDialogSettings)links);
        return settings;
    }

    public void setAccess(String access) {
        this.fAccess = access;
    }

    public void setDestination(IJavaProject project, String destination) {
        ProjectData data = (ProjectData)this.fLinks.get(project);
        if (data != null) {
            data.setDestination(destination);
        }
    }

    public void setDestination(String destination) {
        this.fDestination = destination;
    }

    public void setDocletPath(String docletpath) {
        this.fDocletpath = docletpath;
    }

    public void setDocletName(String docletname) {
        this.fDocletname = docletname;
    }

    public void setStyleSheet(String stylesheet) {
        this.fStylesheet = stylesheet;
    }

    public void setOverview(String overview) {
        this.fOverview = overview;
    }

    public void setAdditionalParams(String params) {
        this.fAdditionalParams = params;
    }

    public void setSpecificAntpath(IJavaProject project, String antpath) {
        ProjectData data = (ProjectData)this.fLinks.get(project);
        if (data != null) {
            data.setAntpath(antpath);
        }
    }

    public void setGeneralAntpath(String antpath) {
        this.fAntpath = antpath;
    }

    public void setClasspath(IPath[] classpath) {
        this.fClasspath = classpath;
    }

    public void setSourcepath(IPath[] sourcepath) {
        this.fSourcepath = sourcepath;
    }

    public void setSourceElements(IJavaElement[] elements) {
        this.fSourceElements = new ArrayList<IJavaElement>(Arrays.asList(elements));
    }

    public void setProjects(IJavaProject[] projects, boolean clear) {
        if (clear) {
            this.fProjects.clear();
        }
        int i = 0;
        while (i < projects.length) {
            IJavaProject iJavaProject = projects[i];
            if (!this.fProjects.contains(iJavaProject)) {
                this.fProjects.add(iJavaProject);
            }
            ++i;
        }
    }

    public void setFromStandard(boolean fromStandard) {
        this.fFromStandard = fromStandard;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void setDependencies(String dependencies) {
        this.fDependencies = dependencies;
    }

    public void setLinks(IJavaProject project, String hrefs) {
        ProjectData data = (ProjectData)this.fLinks.get(project);
        if (data != null) {
            data.setLinks(hrefs);
        }
    }

    public void setOpenInBrowser(boolean openInBrowser) {
        this.fOpenInBrowser = openInBrowser;
    }

    public void setBoolean(String flag, boolean value) {
        if (flag.equals("author")) {
            this.fAuthor = value;
        } else if (flag.equals("use")) {
            this.fUse = value;
        } else if (flag.equals("version")) {
            this.fVersion = value;
        } else if (flag.equals("nodeprecated")) {
            this.fNodeprecated = value;
        } else if (flag.equals("nodeprecatedlist")) {
            this.fNoDeprecatedlist = value;
        } else if (flag.equals("noindex")) {
            this.fNoindex = value;
        } else if (flag.equals("notree")) {
            this.fNotree = value;
        } else if (flag.equals("splitindex")) {
            this.fSplitindex = value;
        } else if (flag.equals("nonavbar")) {
            this.fNonavbar = value;
        }
    }

    public boolean isJDK14Mode() {
        return this.fJDK14Mode;
    }

    public void setJDK14Mode(boolean jdk14Mode) {
        this.fJDK14Mode = jdk14Mode;
    }

    private List getValidSelection(ISelection currentSelection) {
        ArrayList res = new ArrayList();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            if (structuredSelection.isEmpty() && (currentSelection = JavaPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection()) instanceof IStructuredSelection) {
                structuredSelection = (IStructuredSelection)currentSelection;
            }
            Iterator iter = structuredSelection.iterator();
            this.getProjects(res, iter);
        }
        return res;
    }

    private void getProjects(List selectedElements, Iterator iter) {
        while (iter.hasNext()) {
            IJavaProject jproj;
            Object selectedElement = iter.next();
            IJavaElement elem = this.getSelectableJavaElement(selectedElement);
            if (elem == null || (jproj = elem.getJavaProject()) == null) continue;
            if (!this.fProjects.contains(jproj)) {
                this.fProjects.add(jproj);
            }
            selectedElements.add(elem);
        }
        if (this.fProjects.isEmpty()) {
            try {
                IJavaProject[] jprojects = JavaCore.create((IWorkspaceRoot)this.fRoot).getJavaProjects();
                int i = 0;
                while (i < jprojects.length) {
                    IJavaProject iJavaProject = jprojects[i];
                    if (this.getValidProject(iJavaProject)) {
                        this.fProjects.add(iJavaProject);
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private IJavaElement getSelectableJavaElement(Object obj) {
        IJavaElement je = null;
        try {
            if (obj instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)obj;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.IJavaElement;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                je = (IJavaElement)iAdaptable.getAdapter((Class)clazz);
            }
            if (je == null) {
                return null;
            }
            switch (je.getElementType()) {
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    if (this.containsCompilationUnits((IPackageFragmentRoot)je)) {
                        return je;
                    }
                    break;
                }
                case 4: {
                    if (this.containsCompilationUnits((IPackageFragment)je)) {
                        return je;
                    }
                    break;
                }
                default: {
                    ICompilationUnit cu = (ICompilationUnit)je.getAncestor(5);
                    if (cu != null) {
                        return JavaModelUtil.toOriginal(cu);
                    }
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        IJavaProject project = je.getJavaProject();
        if (this.getValidProject(project)) {
            return project;
        }
        return null;
    }

    private boolean getValidProject(IJavaProject project) {
        if (project != null && project.exists()) {
            try {
                IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (this.containsCompilationUnits(roots[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return false;
    }

    private boolean containsCompilationUnits(IPackageFragmentRoot root) throws JavaModelException {
        if (root.getKind() != 1) {
            return false;
        }
        IJavaElement[] elements = root.getChildren();
        int i = 0;
        while (i < elements.length) {
            IPackageFragment fragment;
            if (elements[i] instanceof IPackageFragment && this.containsCompilationUnits(fragment = (IPackageFragment)elements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsCompilationUnits(IPackageFragment pack) throws JavaModelException {
        return pack.getCompilationUnits().length > 0;
    }

    private static class ProjectData {
        private String fHrefs;
        private String fDestinationDir;
        private String fAntPath;

        ProjectData() {
        }

        public void setLinks(String hrefs) {
            this.fHrefs = hrefs == null ? "" : hrefs;
        }

        public void setDestination(String destination) {
            this.fDestinationDir = destination == null ? "" : destination;
        }

        public void setAntpath(String antpath) {
            this.fAntPath = antpath == null ? "" : antpath;
        }

        public String getLinks() {
            return this.fHrefs;
        }

        public String getDestination() {
            return this.fDestinationDir;
        }

        public String getAntPath() {
            return this.fAntPath;
        }
    }
}

