/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.ProblemDialog;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageActionDelegate;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;

public class CreateJarActionDelegate
extends JarPackageActionDelegate {
    public void run(IAction action) {
        MultiStatus mergedStatus;
        IFile[] descriptions = this.getDescriptionFiles(this.getSelection());
        int length = descriptions.length;
        if (length < 1) {
            return;
        }
        String message = length > 1 ? JarPackagerMessages.getString("JarFileExportOperation.creationOfSomeJARsFailed") : JarPackagerMessages.getString("JarFileExportOperation.jarCreationFailed");
        MultiStatus readStatus = new MultiStatus(JavaPlugin.getPluginId(), 0, message, null);
        JarPackageData[] jarPackages = this.readJarPackages(descriptions, readStatus);
        if (jarPackages.length > 0) {
            IStatus status = this.export(jarPackages);
            if (status == null) {
                return;
            }
            message = readStatus.getSeverity() == 4 ? readStatus.getMessage() : status.getMessage();
            mergedStatus = new MultiStatus(JavaPlugin.getPluginId(), status.getCode(), readStatus.getChildren(), message, null);
            mergedStatus.merge(status);
        } else {
            mergedStatus = readStatus;
        }
        if (!mergedStatus.isOK()) {
            ProblemDialog.open(this.getShell(), JarPackagerMessages.getString("CreateJarActionDelegate.jarExport.title"), null, (IStatus)mergedStatus);
        }
    }

    private JarPackageData[] readJarPackages(IFile[] descriptions, MultiStatus readStatus) {
        ArrayList<JarPackageData> jarPackagesList = new ArrayList<JarPackageData>(descriptions.length);
        int i = 0;
        while (i < descriptions.length) {
            JarPackageData jarPackage = this.readJarPackage(descriptions[i], readStatus);
            if (jarPackage != null) {
                jarPackagesList.add(jarPackage);
            }
            ++i;
        }
        return jarPackagesList.toArray(new JarPackageData[jarPackagesList.size()]);
    }

    private IStatus export(JarPackageData[] jarPackages) {
        Shell shell = this.getShell();
        IJarExportRunnable op = jarPackages[0].createJarExportRunnable(jarPackages, shell);
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() != null) {
                ExceptionHandler.handle(ex, shell, JarPackagerMessages.getString("CreateJarActionDelegate.jarExportError.title"), JarPackagerMessages.getString("CreateJarActionDelegate.jarExportError.message"));
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return op.getStatus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JarPackageData readJarPackage(IFile description, MultiStatus readStatus) {
        block11: {
            Assert.isLegal((boolean)description.isAccessible());
            Assert.isNotNull((Object)description.getFileExtension());
            Assert.isLegal((boolean)description.getFileExtension().equals("jardesc"));
            jarPackage = new JarPackageData();
            reader = null;
            try {
                try {
                    reader = jarPackage.createJarDescriptionReader(description.getContents());
                    reader.read(jarPackage);
                    jarPackage.setSaveManifest(false);
                    jarPackage.setSaveDescription(false);
                }
                catch (CoreException ex) {
                    message = JarPackagerMessages.getFormattedString("JarFileExportOperation.errorReadingFile", description.getFullPath(), ex.getStatus().getMessage());
                    this.addToStatus(readStatus, jarPackage, message, ex);
                    var9_7 = null;
                    var7_8 = null;
                    if (reader != null) {
                        readStatus.addAll(reader.getStatus());
                    }
                    try {
                        if (reader == null) return var9_7;
                        reader.close();
                        return var9_7;
                    }
                    catch (CoreException ex) {
                        message = JarPackagerMessages.getFormattedString("JarFileExportOperation.errorClosingJarPackageDescriptionReader", description.getFullPath());
                        this.addToStatus(readStatus, jarPackage, message, ex);
                    }
                    return var9_7;
                }
            }
            catch (Throwable var8_17) {
                var7_9 = null;
                if (reader != null) {
                    readStatus.addAll(reader.getStatus());
                }
                ** try [egrp 2[TRYBLOCK] [3 : 148->163)] { 
lbl37:
                // 1 sources

                if (reader == null) throw var8_17;
                reader.close();
                throw var8_17;
lbl40:
                // 1 sources

                catch (CoreException ex) {
                    message = JarPackagerMessages.getFormattedString("JarFileExportOperation.errorClosingJarPackageDescriptionReader", description.getFullPath());
                    this.addToStatus(readStatus, jarPackage, message, ex);
                }
                throw var8_17;
            }
            {
                var7_10 = null;
                if (reader == null) break block11;
            }
            readStatus.addAll(reader.getStatus());
        }
        try {}
        catch (CoreException ex) {
            message = JarPackagerMessages.getFormattedString("JarFileExportOperation.errorClosingJarPackageDescriptionReader", description.getFullPath());
            this.addToStatus(readStatus, jarPackage, message, ex);
            return jarPackage;
        }
        if (reader == null) return jarPackage;
        reader.close();
        return jarPackage;
    }

    protected void addToStatus(MultiStatus multiStatus, JarPackageData jarPackage, String defaultMessage, CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), defaultMessage, (Throwable)ex);
        }
        multiStatus.add(status);
    }
}

