/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocAccess;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.jdt.internal.ui.infoviews.AbstractInfoView;
import org.eclipse.jdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.jdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;

public class JavadocView
extends AbstractInfoView {
    private static final int LABEL_FLAGS = 39136439;
    private StyledText fText;
    private DefaultInformationControl.IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private SelectAllAction fSelectAllAction;

    protected void internalCreatePartControl(Composite parent) {
        this.fText = new StyledText(parent, 768);
        this.fText.setEditable(false);
        this.fPresenter = new HTMLTextPresenter(false);
        this.getViewSite().setSelectionProvider((ISelectionProvider)new SelectionProvider(this.fText));
        this.fText.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                JavadocView.this.setInput(JavadocView.this.fText.getText());
            }
        });
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction(this.fText, (SelectionProvider)this.getSelectionProvider());
    }

    protected void setForeground(Color color) {
        this.fText.setForeground(color);
    }

    protected void setBackground(Color color) {
        this.fText.setBackground(color);
    }

    protected void internalDispose() {
        this.fText = null;
    }

    public void setFocus() {
        this.fText.setFocus();
    }

    protected Object computeInput(Object input) {
        if (this.fText == null || !(input instanceof IJavaElement)) {
            return null;
        }
        IJavaElement je = (IJavaElement)input;
        String javadocHtml = null;
        if (je.getElementType() == 5) {
            try {
                javadocHtml = this.getJavadocHtml((IJavaElement[])((ICompilationUnit)je).getTypes());
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        } else {
            javadocHtml = this.getJavadocHtml(new IJavaElement[]{je});
        }
        return javadocHtml;
    }

    protected void setInput(Object input) {
        String javadocHtml = (String)input;
        this.fPresentation.clear();
        Rectangle size = this.fText.getClientArea();
        try {
            javadocHtml = this.fPresenter.updatePresentation(this.getSite().getShell().getDisplay(), javadocHtml, this.fPresentation, size.width, size.height);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        this.fText.setText(javadocHtml);
        TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
    }

    private String getJavadocHtml(IJavaElement[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList(buffer);
                IJavaElement curr = result[i];
                if (curr instanceof IMember) {
                    HTMLPrinter.addBullet(buffer, this.getInfoText((IMember)curr));
                }
                HTMLPrinter.endBulletList(buffer);
                ++i;
            }
        } else {
            IJavaElement curr = result[0];
            if (curr instanceof IMember) {
                JavaDocCommentReader reader;
                IMember member = (IMember)curr;
                try {
                    reader = JavaDocAccess.getJavaDoc(member, true);
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph(buffer, new JavaDoc2HTMLTextReader(reader));
                }
            }
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0);
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(IMember member) {
        return JavaElementLabels.getElementLabel((IJavaElement)member, 39136439);
    }

    protected boolean isIngoringEqualInput() {
        return false;
    }

    protected IJavaElement findSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        try {
            IJavaElement element = super.findSelectedJavaElement(part, selection);
            if (element == null && part instanceof JavaEditor && selection instanceof ITextSelection) {
                JavaEditor editor = (JavaEditor)part;
                ITextSelection textSelection = (ITextSelection)selection;
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                if (document == null) {
                    return null;
                }
                ITypedRegion typedRegion = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)textSelection.getOffset());
                if ("__java_javadoc".equals(typedRegion.getType())) {
                    return TextSelectionConverter.getElementAtOffset((JavaEditor)part, textSelection);
                }
                return null;
            }
            return element;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        super.menuAboutToShow(menu);
        menu.add((IAction)this.fSelectAllAction);
    }

    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("selectAll", (IAction)this.fSelectAllAction);
    }

    protected Control getControl() {
        return this.fText;
    }

    private static class SelectAllAction
    extends Action {
        private StyledText fStyledText;
        private SelectionProvider fSelectionProvider;

        public SelectAllAction(StyledText styledText, SelectionProvider selectionProvider) {
            super("selectAll");
            Assert.isNotNull((Object)styledText);
            Assert.isNotNull((Object)selectionProvider);
            this.fStyledText = styledText;
            this.fSelectionProvider = selectionProvider;
            this.setText(InfoViewMessages.getString("SelectAllAction.label"));
            this.setToolTipText(InfoViewMessages.getString("SelectAllAction.tooltip"));
            this.setDescription(InfoViewMessages.getString("SelectAllAction.description"));
            WorkbenchHelp.setHelp((IAction)this, (String)IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        }

        public void run() {
            this.fStyledText.selectAll();
            this.fSelectionProvider.fireSelectionChanged();
        }
    }

    private static class SelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList();
        private StyledText fStyledText;

        public SelectionProvider(StyledText styledText) {
            Assert.isNotNull((Object)styledText);
            this.fStyledText = styledText;
            this.fStyledText.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SelectionProvider this$1;
                {
                    this.this$1 = selectionProvider;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.fireSelectionChanged();
                }
            });
        }

        public void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] selectionChangedListeners = this.fListeners.getListeners();
            int i = 0;
            while (i < selectionChangedListeners.length) {
                ((ISelectionChangedListener)selectionChangedListeners[i]).selectionChanged(event);
                ++i;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            Document document = new Document(this.fStyledText.getSelectionText());
            return new TextSelection((IDocument)document, 0, document.getLength());
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
        }
    }
}

