/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class SourceActionDialog
extends CheckedTreeSelectionDialog {
    private int fInsertPosition;
    private IDialogSettings fSettings;
    private CompilationUnitEditor fEditor;
    private ITreeContentProvider fContentProvider;
    private boolean fGenerateComment;
    private IType fType;
    private int fWidth = 60;
    private int fHeight = 18;
    private String fCommentString;
    private int fVisibilityModifier;
    private boolean fFinal;
    private boolean fSynchronized;
    private final String SETTINGS_SECTION = "SourceActionDialog";
    public final String SETTINGS_INSERTPOSITION = "InsertPosition";
    private final String VISIBILITY_MODIFIER = "VisibilityModifier";
    private final String FINAL_MODIFIER = "FinalModifier";
    private final String SYNCHRONIZED_MODIFIER = "SynchronizedModifier";

    public SourceActionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, CompilationUnitEditor editor, IType type) {
        super(parent, labelProvider, contentProvider);
        this.fEditor = editor;
        this.fContentProvider = contentProvider;
        this.fType = type;
        this.fCommentString = ActionMessages.getString("SourceActionDialog.createMethodComment");
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        this.fGenerateComment = settings.createComments;
        IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
        this.fSettings = dialogSettings.getSection("SourceActionDialog");
        if (this.fSettings == null) {
            this.fSettings = dialogSettings.addNewSection("SourceActionDialog");
            this.fSettings.put("VisibilityModifier", 1);
            this.fSettings.put("FinalModifier", false);
            this.fSettings.put("SynchronizedModifier", false);
            this.fSettings.put("InsertPosition", 1);
        }
        try {
            this.fVisibilityModifier = this.fSettings.getInt("VisibilityModifier");
            this.fFinal = this.fSettings.getBoolean("FinalModifier");
            this.fSynchronized = this.fSettings.getBoolean("SynchronizedModifier");
            this.fInsertPosition = this.fSettings.getInt("InsertPosition");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSettings = dialogSettings.addNewSection("SourceActionDialog");
            this.fSettings.put("VisibilityModifier", 1);
            this.fSettings.put("FinalModifier", false);
            this.fSettings.put("SynchronizedModifier", false);
            this.fSettings.put("InsertPosition", 1);
        }
    }

    public int getInsertPosition() {
        return this.fInsertPosition;
    }

    public void setInsertPosition(int insert) {
        if (this.fInsertPosition != insert) {
            this.fInsertPosition = insert;
            this.fSettings.put("InsertPosition", insert);
        }
    }

    public void setCommentString(String string) {
        this.fCommentString = string;
    }

    protected ITreeContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    public boolean getGenerateComment() {
        return this.fGenerateComment;
    }

    public int getVisibilityModifier() {
        return this.fVisibilityModifier;
    }

    public void setGenerateComment(boolean comment) {
        this.fGenerateComment = comment;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    public void setVisibility(int visibility) {
        if (this.fVisibilityModifier != visibility) {
            this.fVisibilityModifier = visibility;
            this.fSettings.put("VisibilityModifier", visibility);
        }
    }

    public void setFinal(boolean value) {
        if (this.fFinal != value) {
            this.fFinal = value;
            this.fSettings.put("FinalModifier", value);
        }
    }

    public void setSynchronized(boolean value) {
        if (this.fSynchronized != value) {
            this.fSynchronized = value;
            this.fSettings.put("SynchronizedModifier", value);
        }
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = super.createSelectionButtons(composite);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        return buttonComposite;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.okPressed();
                break;
            }
            case 1: {
                this.cancelPressed();
            }
        }
    }

    protected Label createMessageArea(Composite composite) {
        if (this.getMessage() != null) {
            Label label = new Label(composite, 0);
            label.setText(this.getMessage());
            label.setFont(composite.getFont());
            return label;
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gd = null;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        Label messageLabel = this.createMessageArea(composite);
        if (messageLabel != null) {
            gd = new GridData(256);
            gd.horizontalSpan = 2;
            messageLabel.setLayoutData((Object)gd);
        }
        Composite inner = new Composite(composite, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        inner.setLayout((Layout)innerLayout);
        inner.setFont(parent.getFont());
        CheckboxTreeViewer treeViewer = this.createTreeViewer(inner);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gd.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        treeViewer.getControl().setLayoutData((Object)gd);
        Composite buttonComposite = this.createSelectionButtons(inner);
        gd = new GridData(272);
        buttonComposite.setLayoutData((Object)gd);
        gd = new GridData(1808);
        inner.setLayoutData((Object)gd);
        Composite entryComposite = this.createEntryPtCombo(composite);
        entryComposite.setLayoutData((Object)new GridData(768));
        Composite commentComposite = this.createCommentSelection(composite);
        commentComposite.setLayoutData((Object)new GridData(768));
        gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Composite createCommentSelection(Composite composite) {
        Composite commentComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        commentComposite.setLayout((Layout)layout);
        commentComposite.setFont(composite.getFont());
        Button commentButton = new Button(commentComposite, 32);
        commentButton.setText(this.fCommentString);
        commentButton.setLayoutData((Object)new GridData(256));
        commentButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                SourceActionDialog.this.setGenerateComment(isSelected);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        commentButton.setSelection(this.getGenerateComment());
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        commentButton.setLayoutData((Object)gd);
        return commentComposite;
    }

    protected Composite addVisibilityAndModifiersChoices(Composite buttonComposite) {
        IVisibilityChangeListener visibilityChangeListener = new IVisibilityChangeListener(){

            public void visibilityChanged(int newVisibility) {
                SourceActionDialog.this.setVisibility(newVisibility);
            }

            public void modifierChanged(int modifier, boolean isChecked) {
                switch (modifier) {
                    case 16: {
                        SourceActionDialog.this.setFinal(isChecked);
                        return;
                    }
                    case 32: {
                        SourceActionDialog.this.setSynchronized(isChecked);
                        return;
                    }
                }
            }
        };
        int initialVisibility = this.getVisibilityModifier();
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[2] = 2;
        int[] availableVisibilities = nArray;
        Composite visibilityComposite = this.createVisibilityControlAndModifiers(buttonComposite, visibilityChangeListener, availableVisibilities, initialVisibility);
        return visibilityComposite;
    }

    private List convertToIntegerList(int[] array) {
        ArrayList<Integer> result = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            result.add(new Integer(array[i]));
            ++i;
        }
        return result;
    }

    protected Composite createVisibilityControl(Composite parent, final IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
        List allowedVisibilities = this.convertToIntegerList(availableVisibilities);
        if (allowedVisibilities.size() == 1) {
            return null;
        }
        Group group = new Group(parent, 0);
        group.setText(RefactoringMessages.getString("VisibilityControlUtil.Access_modifier"));
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        String[] labels = new String[]{"&public", "pro&tected", RefactoringMessages.getString("VisibilityControlUtil.defa&ult_4"), "pri&vate"};
        Integer[] data = new Integer[]{new Integer(1), new Integer(4), new Integer(0), new Integer(2)};
        Integer initialVisibility = new Integer(correctVisibility);
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button((Composite)group, 16);
            Integer visibilityCode = data[i];
            radio.setLayoutData((Object)new GridData(256));
            radio.setText(labels[i]);
            radio.setData((Object)visibilityCode);
            radio.setSelection(visibilityCode.equals(initialVisibility));
            radio.setEnabled(allowedVisibilities.contains(visibilityCode));
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    visibilityChangeListener.visibilityChanged((Integer)event.widget.getData());
                }
            });
            ++i;
        }
        return group;
    }

    protected Composite createVisibilityControlAndModifiers(Composite parent, final IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
        Composite visibilityComposite = this.createVisibilityControl(parent, visibilityChangeListener, availableVisibilities, correctVisibility);
        Button finalCheckboxButton = new Button(visibilityComposite, 32);
        finalCheckboxButton.setText(RefactoringMessages.getString("VisibilityControlUtil.final"));
        GridData gd = new GridData(256);
        finalCheckboxButton.setLayoutData((Object)gd);
        finalCheckboxButton.setData((Object)new Integer(16));
        finalCheckboxButton.setEnabled(true);
        finalCheckboxButton.setSelection(this.isFinal());
        finalCheckboxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                visibilityChangeListener.modifierChanged((Integer)event.widget.getData(), ((Button)event.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        Button syncCheckboxButton = new Button(visibilityComposite, 32);
        syncCheckboxButton.setText(RefactoringMessages.getString("VisibilityControlUtil.synchronized"));
        gd = new GridData(256);
        syncCheckboxButton.setLayoutData((Object)gd);
        syncCheckboxButton.setData((Object)new Integer(32));
        syncCheckboxButton.setEnabled(true);
        syncCheckboxButton.setSelection(this.isSynchronized());
        syncCheckboxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                visibilityChangeListener.modifierChanged((Integer)event.widget.getData(), ((Button)event.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        return visibilityComposite;
    }

    protected Composite createEntryPtCombo(Composite composite) {
        Composite selectionComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        selectionComposite.setLayout((Layout)layout);
        this.addOrderEntryChoices(selectionComposite);
        return selectionComposite;
    }

    private Composite addOrderEntryChoices(Composite buttonComposite) {
        Label enterLabel = new Label(buttonComposite, 0);
        enterLabel.setText(ActionMessages.getString("SourceActionDialog.enterAt_label"));
        GridData gd = new GridData(256);
        enterLabel.setLayoutData((Object)gd);
        final Combo enterCombo = new Combo(buttonComposite, 8);
        this.fillWithPossibleInsertPositions(enterCombo);
        gd = new GridData(1808);
        enterCombo.setLayoutData((Object)gd);
        enterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = enterCombo.getSelectionIndex();
                SourceActionDialog.this.setInsertPosition(index);
            }
        });
        return buttonComposite;
    }

    private void fillWithPossibleInsertPositions(Combo combo) {
        try {
            int index;
            int position = 0;
            int presetOffset = 0;
            if (this.fEditor != null) {
                presetOffset = ((TextSelection)this.fEditor.getSelectionProvider().getSelection()).getOffset();
            } else {
                List preselected = this.getInitialElementSelections();
                int size = preselected.size();
                if (size > 1 || size == 0) {
                    presetOffset = 0;
                } else {
                    IJavaElement element = (IJavaElement)preselected.get(0);
                    int type = element.getElementType();
                    if (type == 8) {
                        presetOffset = ((IField)element).getSourceRange().getOffset();
                    } else if (type == 9) {
                        presetOffset = ((IMethod)element).getSourceRange().getOffset();
                    }
                }
            }
            IMethod[] methods = this.fType.getMethods();
            combo.add(ActionMessages.getString("SourceActionDialog.first_method"));
            combo.add(ActionMessages.getString("SourceActionDialog.last_method"));
            int bestDiff = Integer.MAX_VALUE;
            int i = 0;
            while (i < methods.length) {
                int currDiff = 0;
                IMethod curr = methods[i];
                combo.add(JavaElementLabels.getElementLabel((IJavaElement)methods[i], 1));
                currDiff = presetOffset - curr.getSourceRange().getOffset();
                if (currDiff >= 0) {
                    if (currDiff >= bestDiff) break;
                    bestDiff = currDiff;
                    position = i + 2;
                }
                ++i;
            }
            if ((index = this.getInsertPosition()) > 1) {
                combo.select(position);
            } else {
                combo.select(index);
            }
            this.setInsertPosition(combo.getSelectionIndex());
        }
        catch (JavaModelException javaModelException) {}
    }

    public boolean getFinal() {
        return this.fFinal;
    }

    public boolean getSynchronized() {
        return this.fSynchronized;
    }

    public boolean isFinal() {
        return this.fFinal;
    }

    public boolean isSynchronized() {
        return this.fSynchronized;
    }

    public IJavaElement getElementPosition() {
        int comboBoxIndex = this.getInsertPosition();
        try {
            if (comboBoxIndex == 0) {
                return this.asFirstMethod(this.fType);
            }
            if (comboBoxIndex == 1) {
                return null;
            }
            return this.atElementPosition(this.fType, comboBoxIndex);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private IMethod asFirstMethod(IType type) throws JavaModelException {
        IMethod[] methods;
        if (type != null && (methods = type.getMethods()).length > 0) {
            return methods[0];
        }
        return null;
    }

    private IJavaElement atElementPosition(IType type, int index) throws JavaModelException {
        if (type != null) {
            IMethod[] methods = type.getMethods();
            IJavaElement[] elements = type.getChildren();
            int i = 0;
            while (i < elements.length - 1) {
                if (methods[index - 2] == elements[i]) {
                    return elements[i + 1];
                }
                ++i;
            }
        }
        return null;
    }
}

