/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class PackageSelectionDialog
extends ElementListSelectionDialog {
    public static final int F_REMOVE_DUPLICATES = 1;
    public static final int F_SHOW_PARENTS = 2;
    public static final int F_HIDE_DEFAULT_PACKAGE = 4;
    private Point fLocation;
    private Point fSize;
    private IRunnableContext fContext;
    private IJavaSearchScope fScope;
    private int fFlags;

    public PackageSelectionDialog(Shell parent, IRunnableContext context, int flags, IJavaSearchScope scope) {
        super(parent, PackageSelectionDialog.createLabelProvider(flags));
        this.fFlags = flags;
        this.fScope = scope;
        this.fContext = context;
    }

    private static ILabelProvider createLabelProvider(int dialogFlags) {
        int flags = JavaElementLabelProvider.SHOW_DEFAULT;
        if ((dialogFlags & 1) == 0) {
            flags |= 0x40;
        }
        return new JavaElementLabelProvider(flags);
    }

    public int open() {
        final ArrayList packageList = new ArrayList();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IJavaSearchResultCollector requestor = new IJavaSearchResultCollector(this, packageList, monitor){
                        private HashSet fSet;
                        private final boolean fAddDefault;
                        private final boolean fDuplicates;
                        private final boolean fIncludeParents;
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ArrayList val$packageList;
                        private final /* synthetic */ IProgressMonitor val$monitor;
                        {
                            this.this$1 = var1_1;
                            this.val$packageList = arrayList;
                            this.val$monitor = iProgressMonitor;
                            this.fSet = new HashSet<E>();
                            this.fAddDefault = (PackageSelectionDialog.access$0(1.access$0(var1_1)) & 4) == 0;
                            this.fDuplicates = (PackageSelectionDialog.access$0(1.access$0(var1_1)) & 1) == 0;
                            this.fIncludeParents = (PackageSelectionDialog.access$0(1.access$0(var1_1)) & 2) != 0;
                        }

                        public void aboutToStart() {
                        }

                        public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) {
                            String name = enclosingElement.getElementName();
                            if ((this.fAddDefault || name.length() > 0) && (this.fDuplicates || this.fSet.add(name))) {
                                this.val$packageList.add(enclosingElement);
                                if (this.fIncludeParents) {
                                    this.addParentPackages(enclosingElement, name);
                                }
                            }
                        }

                        private void addParentPackages(IJavaElement enclosingElement, String name) {
                            IPackageFragmentRoot root = (IPackageFragmentRoot)enclosingElement.getParent();
                            int idx = name.lastIndexOf(46);
                            while (idx != -1) {
                                name = name.substring(0, idx);
                                if (this.fDuplicates || this.fSet.add(name)) {
                                    this.val$packageList.add(root.getPackageFragment(name));
                                }
                                idx = name.lastIndexOf(46);
                            }
                        }

                        public void done() {
                        }

                        public IProgressMonitor getProgressMonitor() {
                            return this.val$monitor;
                        }
                    };
                    new SearchEngine().search(ResourcesPlugin.getWorkspace(), "*", 2, 0, PackageSelectionDialog.this.fScope, requestor);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }

            static /* synthetic */ PackageSelectionDialog access$0(1 var0) {
                return var0.PackageSelectionDialog.this;
            }
        };
        try {
            this.fContext.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, JavaUIMessages.getString("PackageSelectionDialog.error.title"), JavaUIMessages.getString("TypeSelectionDialog.error3Message"));
            return 1;
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        if (packageList.isEmpty()) {
            String title = JavaUIMessages.getString("PackageSelectionDialog.nopackages.title");
            String message = JavaUIMessages.getString("PackageSelectionDialog.nopackages.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return 1;
        }
        this.setElements(packageList.toArray());
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.open_package_dialog_context");
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.readSettings();
        return control;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.fSize != null) {
            result.x = Math.max(result.x, this.fSize.x);
            result.y = Math.max(result.y, this.fSize.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.fLocation != null) {
            int ye;
            result.x = this.fLocation.x;
            result.y = this.fLocation.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    private void readSettings() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.fLocation = new Point(x, y);
            int width = s.getInt("width");
            int height = s.getInt("height");
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
            this.fSize = null;
        }
    }

    private void writeSettings() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
    }

    private IDialogSettings getDialogSettings() {
        String sectionName;
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings subSettings = settings.getSection(sectionName = ((Object)((Object)this)).getClass().getName());
        if (subSettings == null) {
            subSettings = settings.addNewSection(sectionName);
        }
        return subSettings;
    }

    static /* synthetic */ int access$0(PackageSelectionDialog packageSelectionDialog) {
        return packageSelectionDialog.fFlags;
    }
}

