/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class JavaTextViewer
extends Viewer {
    private SourceViewer fSourceViewer;
    private Object fInput;

    JavaTextViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 768);
        JavaTextTools tools = JavaCompareUtilities.getJavaTextTools();
        if (tools != null) {
            this.fSourceViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(tools, null));
        }
        this.fSourceViewer.setEditable(false);
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void setInput(Object input) {
        if (input instanceof IStreamContentAccessor) {
            Document document = new Document(JavaTextViewer.getString(input));
            JavaCompareUtilities.setupDocument((IDocument)document);
            this.fSourceViewer.setDocument((IDocument)document);
        }
        this.fInput = input;
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection s, boolean reveal) {
    }

    public void refresh() {
    }

    private static String getString(Object input) {
        if (input instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)input;
            try {
                return JavaCompareUtilities.readString(sca);
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex);
            }
        }
        return "";
    }
}

