/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.IStreamContentAccessorExtension2;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaStructureCreator;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;

public abstract class JavaHistoryAction
extends Action
implements IActionDelegate {
    private boolean fModifiesFile;
    private ISelection fSelection;
    private JavaEditor fEditor;
    private String fTitle;
    private String fMessage;

    JavaHistoryAction(boolean modifiesFile) {
        this.fModifiesFile = modifiesFile;
    }

    ISelection getSelection() {
        return this.fSelection;
    }

    final IFile getFile(Object input) {
        ICompilationUnit cu = null;
        if (input instanceof ICompilationUnit) {
            cu = (ICompilationUnit)input;
        } else if (input instanceof IMember) {
            cu = ((IMember)input).getCompilationUnit();
        }
        if (cu == null || !cu.exists()) {
            return null;
        }
        IFile file = (IFile)(cu = JavaModelUtil.toOriginal(cu)).getResource();
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    final ITypedElement[] buildEditions(ITypedElement target, IFile file) {
        IFileState[] states = null;
        try {
            states = file.getHistory(null);
        }
        catch (CoreException ex) {
            JavaPlugin.log(ex);
        }
        int count = 1;
        if (states != null) {
            count += states.length;
        }
        ITypedElement[] editions = new ITypedElement[count];
        editions[0] = new ResourceNode((IResource)file);
        if (states != null) {
            int i = 0;
            while (i < states.length) {
                editions[i + 1] = new HistoryItem(target, states[i]);
                ++i;
            }
        }
        return editions;
    }

    final Shell getShell() {
        if (this.fEditor != null) {
            return this.fEditor.getEditorSite().getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    final IJavaElement getWorkingCopy(IJavaElement input) {
        try {
            return EditorUtility.getWorkingCopy(input, true);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    final boolean beingEdited(IFile file) {
        FileEditorInput input;
        ICompilationUnitDocumentProvider dp = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        return dp.getDocument(input = new FileEditorInput(file)) != null;
    }

    final IMember getEditionElement(ISelection selection) {
        IMember m;
        Object o;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (o = ss.getFirstElement()) instanceof IMember && (m = (IMember)o).exists() && !m.isBinary() && JavaStructureCreator.hasEdition((IJavaElement)m)) {
            return m;
        }
        return null;
    }

    final boolean isEnabled(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (this.fModifiesFile) {
            return true;
        }
        return true;
    }

    boolean isEnabled(ISelection selection) {
        IMember m = this.getEditionElement(selection);
        if (m == null) {
            return false;
        }
        IFile file = this.getFile(m);
        if (!this.isEnabled(file)) {
            return false;
        }
        if (file != null && this.beingEdited(file)) {
            return this.getWorkingCopy((IJavaElement)m) != null;
        }
        return true;
    }

    void applyChanges(ASTRewrite rewriter, final TextBuffer buffer, Shell shell, boolean inEditor) throws CoreException, InvocationTargetException, InterruptedException {
        MultiTextEdit edit = new MultiTextEdit();
        rewriter.rewriteNode(buffer, (TextEdit)edit);
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        TextBufferEditor editor = new TextBufferEditor(buffer);
        editor.add((TextEdit)edit);
        editor.performEdits((IProgressMonitor)nullProgressMonitor);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    TextBuffer.commitChanges(buffer, false, pm);
                }
                catch (CoreException ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        };
        if (inEditor) {
            r.run((IProgressMonitor)nullProgressMonitor);
        } else {
            ProgressMonitorDialog pd = new ProgressMonitorDialog(shell);
            pd.run(true, false, r);
        }
    }

    static String trimTextBlock(String content, String delimiter) {
        String[] lines;
        if (content != null && (lines = Strings.convertIntoLines(content)) != null) {
            Strings.trimIndentation(lines, JavaCompareUtilities.getTabSize());
            return Strings.concatenate(lines, delimiter);
        }
        return null;
    }

    final JavaEditor getEditor(IFile file) {
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    if (ep instanceof JavaEditor) {
                        return (JavaEditor)ep;
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return null;
    }

    public abstract void run(ISelection var1);

    void init(JavaEditor editor, String text, String title, String message) {
        Assert.isNotNull((Object)editor);
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)message);
        this.fEditor = editor;
        this.fTitle = title;
        this.fMessage = message;
        this.setText(text);
        this.setEnabled(this.checkEnabled());
    }

    final JavaEditor getEditor() {
        return this.fEditor;
    }

    public final void run() {
        IJavaElement element = null;
        try {
            element = SelectionConverter.getElementAtOffset(this.fEditor);
        }
        catch (JavaModelException javaModelException) {}
        this.fSelection = element != null ? new StructuredSelection((Object)element) : StructuredSelection.EMPTY;
        boolean isEnabled = this.isEnabled(this.fSelection);
        this.setEnabled(isEnabled);
        if (!isEnabled) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.fTitle, (String)this.fMessage);
            return;
        }
        this.run(this.fSelection);
    }

    private boolean checkEnabled() {
        ICompilationUnit unit = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        IFile file = this.getFile(unit);
        return this.isEnabled(file);
    }

    public final void update() {
        this.setEnabled(this.checkEnabled());
    }

    public final void selectionChanged(IAction uiProxy, ISelection selection) {
        this.fSelection = selection;
        uiProxy.setEnabled(this.isEnabled(selection));
    }

    public final void run(IAction action) {
        this.run(this.fSelection);
    }

    class JavaTextBufferNode
    implements ITypedElement,
    IStreamContentAccessorExtension2 {
        private TextBuffer fBuffer;
        private boolean fInEditor;

        JavaTextBufferNode(TextBuffer buffer, boolean inEditor) {
            this.fBuffer = buffer;
            this.fInEditor = inEditor;
        }

        public String getName() {
            if (this.fInEditor) {
                return CompareMessages.getString("Editor_Buffer");
            }
            return CompareMessages.getString("Workspace_File");
        }

        public String getType() {
            return "java";
        }

        public Image getImage() {
            return null;
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(JavaCompareUtilities.getBytes(this.fBuffer.getContent(), "UTF-16"));
        }

        public String getCharset() {
            return "UTF-16";
        }
    }
}

