/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessorExtension2;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;

class JavaCompareUtilities {
    JavaCompareUtilities() {
    }

    static int getTabSize() {
        return CodeFormatterUtil.getTabWidth();
    }

    static String getString(ResourceBundle bundle, String key, String dfltValue) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    static String getString(ResourceBundle bundle, String key) {
        return JavaCompareUtilities.getString(bundle, key, key);
    }

    static int getInteger(ResourceBundle bundle, String key, int dfltValue) {
        if (bundle != null) {
            try {
                String s = bundle.getString(key);
                if (s != null) {
                    return Integer.parseInt(s);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    static ImageDescriptor getImageDescriptor(int type) {
        switch (type) {
            case 9: 
            case 10: {
                return JavaCompareUtilities.getImageDescriptor("obj16/compare_method.gif");
            }
            case 8: {
                return JavaCompareUtilities.getImageDescriptor("obj16/compare_field.gif");
            }
            case 11: {
                return JavaPluginImages.DESC_OBJS_PACKDECL;
            }
            case 13: {
                return JavaPluginImages.DESC_OBJS_IMPDECL;
            }
            case 12: {
                return JavaPluginImages.DESC_OBJS_IMPCONT;
            }
            case 5: {
                return JavaPluginImages.DESC_OBJS_CUNIT;
            }
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    static ImageDescriptor getTypeImageDescriptor(boolean isClass) {
        if (isClass) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE;
    }

    static ImageDescriptor getImageDescriptor(IMember element) {
        int t = element.getElementType();
        if (t == 7) {
            IType type = (IType)element;
            try {
                return JavaCompareUtilities.getTypeImageDescriptor(type.isClass());
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return JavaPluginImages.DESC_OBJS_GHOST;
            }
        }
        return JavaCompareUtilities.getImageDescriptor(t);
    }

    static String getJavaElementID(IJavaElement je) {
        if (je instanceof IMember && ((IMember)je).isBinary()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        switch (je.getElementType()) {
            case 5: {
                sb.append('{');
                break;
            }
            case 7: {
                sb.append('[');
                sb.append(je.getElementName());
                break;
            }
            case 8: {
                sb.append('^');
                sb.append(je.getElementName());
                break;
            }
            case 9: {
                sb.append('~');
                sb.append(JavaElementLabels.getElementLabel(je, 1));
                break;
            }
            case 10: {
                String id = je.getHandleIdentifier();
                int pos = id.lastIndexOf(124);
                if (pos < 0) break;
                sb.append(id.substring(pos));
                break;
            }
            case 11: {
                sb.append('%');
                break;
            }
            case 12: {
                sb.append('<');
                break;
            }
            case 13: {
                sb.append('#');
                sb.append(je.getElementName());
                break;
            }
            default: {
                return null;
            }
        }
        return sb.toString();
    }

    static String buildID(int type, String name) {
        StringBuffer sb = new StringBuffer();
        switch (type) {
            case 0: {
                sb.append('{');
                break;
            }
            case 4: 
            case 5: {
                sb.append('[');
                sb.append(name);
                break;
            }
            case 6: {
                sb.append('^');
                sb.append(name);
                break;
            }
            case 8: 
            case 9: {
                sb.append('~');
                sb.append(name);
                break;
            }
            case 7: {
                sb.append('|');
                sb.append(name);
                break;
            }
            case 1: {
                sb.append('%');
                break;
            }
            case 3: {
                sb.append('#');
                sb.append(name);
                break;
            }
            case 2: {
                sb.append('<');
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
            }
        }
        return sb.toString();
    }

    static ImageDescriptor getImageDescriptor(String relativePath) {
        JavaPlugin plugin = JavaPlugin.getDefault();
        URL installURL = null;
        if (plugin != null) {
            installURL = plugin.getDescriptor().getInstallURL();
        }
        if (installURL != null) {
            try {
                URL url = new URL(installURL, "icons/full/" + relativePath);
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException malformedURLException) {
                Assert.isTrue((boolean)false);
            }
        }
        return null;
    }

    static Image getImage(IMember member) {
        ImageDescriptor id = JavaCompareUtilities.getImageDescriptor(member);
        return id.createImage();
    }

    static JavaTextTools getJavaTextTools() {
        JavaPlugin plugin = JavaPlugin.getDefault();
        if (plugin != null) {
            return plugin.getJavaTextTools();
        }
        return null;
    }

    static IDocumentPartitioner createJavaPartitioner() {
        JavaTextTools tools = JavaCompareUtilities.getJavaTextTools();
        if (tools != null) {
            return tools.createDocumentPartitioner();
        }
        return null;
    }

    static void setupDocument(IDocument document) {
        JavaTextTools tools = JavaCompareUtilities.getJavaTextTools();
        if (tools != null) {
            tools.setupJavaDocumentPartitioner(document);
        }
    }

    /*
     * Exception decompiling
     */
    private static String readString(InputStream is, String encoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 109->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        if (is != null) {
            String encoding = null;
            if (sa instanceof IStreamContentAccessorExtension2) {
                encoding = ((IStreamContentAccessorExtension2)sa).getCharset();
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return JavaCompareUtilities.readString(is, encoding);
        }
        return null;
    }

    static byte[] getBytes(String s, String encoding) {
        try {
            return s.getBytes(encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s.getBytes();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] readLines(InputStream is2, String encoding) {
        String[] stringArray;
        BufferedReader reader = null;
        try {
            try {
                int c;
                reader = new BufferedReader(new InputStreamReader(is2, encoding));
                StringBuffer sb = new StringBuffer();
                ArrayList<String> list = new ArrayList<String>();
                while ((c = reader.read()) != -1) {
                    sb.append((char)c);
                    if (c == 13) {
                        c = reader.read();
                        if (c == -1) break;
                        sb.append((char)c);
                        if (c != 10) continue;
                        list.add(sb.toString());
                        sb = new StringBuffer();
                        continue;
                    }
                    if (c != 10) continue;
                    list.add(sb.toString());
                    sb = new StringBuffer();
                }
                if (sb.length() > 0) {
                    list.add(sb.toString());
                }
                stringArray = list.toArray(new String[list.size()]);
                Object var6_8 = null;
                if (reader == null) return stringArray;
            }
            catch (IOException iOException) {
                String[] stringArray2 = null;
                Object var6_9 = null;
                if (reader == null) return stringArray2;
                try {
                    reader.close();
                    return stringArray2;
                }
                catch (IOException iOException2) {}
                return stringArray2;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (reader == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            reader.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        reader.close();
        return stringArray;
    }
}

