/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class SelectionProviderMediator
implements ISelectionProvider {
    private Viewer[] fViewers;
    private InternalListener fListener;
    private Viewer fViewerInFocus;
    private ListenerList fSelectionChangedListeners;

    public SelectionProviderMediator(Viewer[] viewers) {
        Assert.isNotNull((Object)viewers);
        this.fViewers = viewers;
        this.fListener = new InternalListener();
        this.fSelectionChangedListeners = new ListenerList(4);
        this.fViewerInFocus = null;
        int i = 0;
        while (i < this.fViewers.length) {
            Viewer viewer = this.fViewers[i];
            viewer.addSelectionChangedListener((ISelectionChangedListener)this.fListener);
            Control control = viewer.getControl();
            control.addFocusListener((FocusListener)this.fListener);
            ++i;
        }
    }

    private void doFocusChanged(Widget control) {
        int i = 0;
        while (i < this.fViewers.length) {
            if (this.fViewers[i].getControl() == control) {
                this.propagateFocusChanged(this.fViewers[i]);
                return;
            }
            ++i;
        }
    }

    private void doSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider == this.fViewerInFocus) {
            this.fireSelectionChanged();
        }
    }

    private void propagateFocusChanged(Viewer viewer) {
        if (viewer != this.fViewerInFocus) {
            this.fViewerInFocus = viewer;
            this.fireSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        if (this.fSelectionChangedListeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Object[] listeners = this.fSelectionChangedListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return CallHierarchyUI.convertSelection(this.getRawSelection());
    }

    public ISelection getRawSelection() {
        if (this.fViewerInFocus != null) {
            return this.fViewerInFocus.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.fViewerInFocus != null) {
            this.fViewerInFocus.setSelection(selection);
        }
    }

    public Viewer getViewerInFocus() {
        return this.fViewerInFocus;
    }

    private class InternalListener
    implements ISelectionChangedListener,
    FocusListener {
        InternalListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionProviderMediator.this.doSelectionChanged(event);
        }

        public void focusGained(FocusEvent e) {
            SelectionProviderMediator.this.doFocusChanged(e.widget);
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

