/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

class SearchScopeActionGroup
extends ActionGroup {
    private static final String TAG_SEARCH_SCOPE_TYPE = "search_scope_type";
    private static final String TAG_SELECTED_WORKING_SET = "working_set";
    private static final String DIALOGSTORE_SCOPE_TYPE = "SearchScopeActionGroup.search_scope_type";
    private static final String DIALOGSTORE_SELECTED_WORKING_SET = "SearchScopeActionGroup.working_set";
    private static final int SEARCH_SCOPE_TYPE_WORKSPACE = 1;
    private static final int SEARCH_SCOPE_TYPE_PROJECT = 2;
    private static final int SEARCH_SCOPE_TYPE_HIERARCHY = 3;
    private static final int SEARCH_SCOPE_TYPE_WORKING_SET = 4;
    private SearchScopeAction fSelectedAction = null;
    private String fSelectedWorkingSetName = null;
    private CallHierarchyViewPart fView;
    private IDialogSettings fDialogSettings;
    private SearchScopeHierarchyAction fSearchScopeHierarchyAction;
    private SearchScopeProjectAction fSearchScopeProjectAction;
    private SearchScopeWorkspaceAction fSearchScopeWorkspaceAction;
    private SelectWorkingSetAction fSelectWorkingSetAction;

    public SearchScopeActionGroup(CallHierarchyViewPart view, IDialogSettings dialogSettings) {
        this.fView = view;
        this.fDialogSettings = dialogSettings;
        this.createActions();
    }

    public IJavaSearchScope getSearchScope() {
        if (this.fSelectedAction != null) {
            return this.fSelectedAction.getSearchScope();
        }
        return null;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fillViewMenu(actionBars.getMenuManager());
    }

    public void fillContextMenu(IMenuManager menu) {
    }

    protected void setActiveWorkingSet(IWorkingSet set) {
        if (set != null) {
            this.fSelectedWorkingSetName = set.getName();
            this.fSelectedAction = new SearchScopeWorkingSetAction(set);
        } else {
            this.fSelectedWorkingSetName = null;
            this.fSelectedAction = null;
        }
    }

    protected IWorkingSet getActiveWorkingSet() {
        if (this.fSelectedWorkingSetName != null) {
            return this.getWorkingSet(this.fSelectedWorkingSetName);
        }
        return null;
    }

    private IWorkingSet getWorkingSet(String workingSetName) {
        return this.getWorkingSetManager().getWorkingSet(workingSetName);
    }

    protected void setSelected(SearchScopeAction newSelection, boolean ignoreUnchecked) {
        if (!ignoreUnchecked || newSelection.isChecked()) {
            this.fSelectedWorkingSetName = newSelection instanceof SearchScopeWorkingSetAction ? ((SearchScopeWorkingSetAction)newSelection).getWorkingSet().getName() : null;
            this.fSelectedAction = newSelection;
            this.fDialogSettings.put(DIALOGSTORE_SCOPE_TYPE, this.getSearchScopeType());
            this.fDialogSettings.put(DIALOGSTORE_SELECTED_WORKING_SET, this.fSelectedWorkingSetName);
        }
    }

    protected CallHierarchyViewPart getView() {
        return this.fView;
    }

    protected IWorkingSetManager getWorkingSetManager() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        return workingSetManager;
    }

    protected void fillSearchActions(IMenuManager javaSearchMM) {
        javaSearchMM.removeAll();
        Action[] actions = this.getActions();
        int i = 0;
        while (i < actions.length) {
            Action action = actions[i];
            if (action.isEnabled()) {
                javaSearchMM.add((IAction)action);
            }
            ++i;
        }
        javaSearchMM.setVisible(!javaSearchMM.isEmpty());
    }

    void fillViewMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.search"));
        MenuManager javaSearchMM = new MenuManager(CallHierarchyMessages.getString("SearchScopeActionGroup.searchScope"), "group.search");
        javaSearchMM.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SearchScopeActionGroup.this.fillSearchActions(manager);
            }
        });
        menu.appendToGroup("group.search", (IContributionItem)javaSearchMM);
    }

    private Action[] getActions() {
        ArrayList<SearchScopeWorkingSetAction> actions = new ArrayList<SearchScopeWorkingSetAction>();
        this.addAction(actions, this.fSearchScopeWorkspaceAction);
        this.addAction(actions, this.fSearchScopeProjectAction);
        this.addAction(actions, this.fSearchScopeHierarchyAction);
        this.addAction(actions, this.fSelectWorkingSetAction);
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] sets = workingSetManager.getRecentWorkingSets();
        int i = 0;
        while (i < sets.length) {
            SearchScopeWorkingSetAction workingSetAction = new SearchScopeWorkingSetAction(sets[i]);
            if (sets[i].getName().equals(this.fSelectedWorkingSetName)) {
                workingSetAction.setChecked(true);
            }
            actions.add(workingSetAction);
            ++i;
        }
        return actions.toArray(new Action[actions.size()]);
    }

    private void addAction(List actions, Action action) {
        if (action == this.fSelectedAction) {
            action.setChecked(true);
        } else {
            action.setChecked(false);
        }
        actions.add(action);
    }

    private void createActions() {
        int searchScopeType;
        this.fSearchScopeWorkspaceAction = new SearchScopeWorkspaceAction();
        this.fSelectWorkingSetAction = new SelectWorkingSetAction();
        this.fSearchScopeHierarchyAction = new SearchScopeHierarchyAction();
        this.fSearchScopeProjectAction = new SearchScopeProjectAction();
        try {
            searchScopeType = this.fDialogSettings.getInt(DIALOGSTORE_SCOPE_TYPE);
        }
        catch (NumberFormatException numberFormatException) {
            searchScopeType = 1;
        }
        String workingSetName = this.fDialogSettings.get(DIALOGSTORE_SELECTED_WORKING_SET);
        SearchScopeAction action = this.getSearchScopeAction(searchScopeType, workingSetName);
        if (action != null) {
            this.setSelected(action, false);
        } else {
            this.setSelected(this.fSearchScopeWorkspaceAction, false);
        }
    }

    public void saveState(IMemento memento) {
        int type = this.getSearchScopeType();
        memento.putInteger(TAG_SEARCH_SCOPE_TYPE, type);
        if (type == 4) {
            memento.putString(TAG_SELECTED_WORKING_SET, this.fSelectedWorkingSetName);
        }
    }

    public void restoreState(IMemento memento) {
        Integer scopeType = memento.getInteger(TAG_SEARCH_SCOPE_TYPE);
        if (scopeType != null) {
            String workingSetName = memento.getString(TAG_SELECTED_WORKING_SET);
            SearchScopeAction searchScopeAction = this.getSearchScopeAction(scopeType, workingSetName);
            if (searchScopeAction != null) {
                this.setSelected(searchScopeAction, false);
            }
        }
    }

    private SearchScopeAction getSearchScopeAction(int searchScopeType, String workingSetName) {
        switch (searchScopeType) {
            case 1: {
                return this.fSearchScopeWorkspaceAction;
            }
            case 2: {
                return this.fSearchScopeProjectAction;
            }
            case 3: {
                return this.fSearchScopeHierarchyAction;
            }
            case 4: {
                IWorkingSet workingSet = this.getWorkingSet(workingSetName);
                if (workingSet != null) {
                    return new SearchScopeWorkingSetAction(workingSet);
                }
                return null;
            }
        }
        return null;
    }

    private int getSearchScopeType() {
        if (this.fSelectedAction != null) {
            return this.fSelectedAction.getSearchScopeType();
        }
        return 0;
    }

    private abstract class SearchScopeAction
    extends Action {
        public SearchScopeAction(String text) {
            super(text, 8);
        }

        public abstract IJavaSearchScope getSearchScope();

        public abstract int getSearchScopeType();

        public void run() {
            SearchScopeActionGroup.this.setSelected(this, true);
        }
    }

    private class SearchScopeHierarchyAction
    extends SearchScopeAction {
        public SearchScopeHierarchyAction() {
            super(CallHierarchyMessages.getString("SearchScopeActionGroup.hierarchy.text"));
            this.setToolTipText(CallHierarchyMessages.getString("SearchScopeActionGroup.hierarchy.tooltip"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
        }

        public IJavaSearchScope getSearchScope() {
            try {
                IMethod method = SearchScopeActionGroup.this.getView().getMethod();
                if (method != null) {
                    return SearchEngine.createHierarchyScope((IType)method.getDeclaringType());
                }
                return null;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return null;
            }
        }

        public int getSearchScopeType() {
            return 3;
        }
    }

    private class SearchScopeProjectAction
    extends SearchScopeAction {
        public SearchScopeProjectAction() {
            super(CallHierarchyMessages.getString("SearchScopeActionGroup.project.text"));
            this.setToolTipText(CallHierarchyMessages.getString("SearchScopeActionGroup.project.tooltip"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
        }

        public IJavaSearchScope getSearchScope() {
            IMethod method = SearchScopeActionGroup.this.getView().getMethod();
            IJavaProject project = null;
            if (method != null) {
                project = method.getJavaProject();
            }
            if (project != null) {
                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}, (boolean)false);
            }
            return null;
        }

        public int getSearchScopeType() {
            return 2;
        }
    }

    private class SearchScopeWorkingSetAction
    extends SearchScopeAction {
        private IWorkingSet mWorkingSet;
        static /* synthetic */ Class class$0;

        public SearchScopeWorkingSetAction(IWorkingSet workingSet) {
            super(workingSet.getName());
            this.setToolTipText(CallHierarchyMessages.getString("SearchScopeActionGroup.workingset.tooltip"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
            this.mWorkingSet = workingSet;
        }

        public IJavaSearchScope getSearchScope() {
            return SearchEngine.createJavaSearchScope((IJavaElement[])this.getJavaElements(this.mWorkingSet.getElements()));
        }

        public IWorkingSet getWorkingSet() {
            return this.mWorkingSet;
        }

        private IJavaElement[] getJavaElements(IAdaptable[] adaptables) {
            ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
            int i = 0;
            while (i < adaptables.length) {
                IJavaElement element;
                IAdaptable iAdaptable = adaptables[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[Lorg.eclipse.jdt.core.IJavaElement;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                    result.add(element);
                }
                ++i;
            }
            return result.toArray(new IJavaElement[result.size()]);
        }

        public int getSearchScopeType() {
            return 4;
        }
    }

    private class SearchScopeWorkspaceAction
    extends SearchScopeAction {
        public SearchScopeWorkspaceAction() {
            super(CallHierarchyMessages.getString("SearchScopeActionGroup.workspace.text"));
            this.setToolTipText(CallHierarchyMessages.getString("SearchScopeActionGroup.workspace.tooltip"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
        }

        public IJavaSearchScope getSearchScope() {
            return SearchEngine.createWorkspaceScope();
        }

        public int getSearchScopeType() {
            return 1;
        }
    }

    private class SelectWorkingSetAction
    extends Action {
        public SelectWorkingSetAction() {
            super(CallHierarchyMessages.getString("SearchScopeActionGroup.workingset.select.text"));
            this.setToolTipText(CallHierarchyMessages.getString("SearchScopeActionGroup.workingset.select.tooltip"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
        }

        public void run() {
            IWorkingSetManager workingSetManager = SearchScopeActionGroup.this.getWorkingSetManager();
            IWorkingSetSelectionDialog dialog = workingSetManager.createWorkingSetSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), false);
            IWorkingSet workingSet = SearchScopeActionGroup.this.getActiveWorkingSet();
            if (workingSet != null) {
                dialog.setSelection(new IWorkingSet[]{workingSet});
            }
            if (dialog.open() == 0) {
                IWorkingSet[] result = dialog.getSelection();
                if (result != null && result.length > 0) {
                    SearchScopeActionGroup.this.setActiveWorkingSet(result[0]);
                    workingSetManager.addRecentWorkingSet(result[0]);
                } else {
                    SearchScopeActionGroup.this.setActiveWorkingSet(null);
                }
            }
        }
    }
}

