/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.help.WorkbenchHelp;

class HistoryAction
extends Action {
    private static JavaElementLabelProvider fLabelProvider = new JavaElementLabelProvider(2051);
    private CallHierarchyViewPart fView;
    private IMethod fMethod;

    public HistoryAction(CallHierarchyViewPart viewPart, IMethod element) {
        this.fView = viewPart;
        this.fMethod = element;
        String elementName = this.getElementLabel((IJavaElement)element);
        this.setText(elementName);
        this.setImageDescriptor(this.getImageDescriptor((IJavaElement)element));
        this.setDescription(CallHierarchyMessages.getFormattedString(CallHierarchyMessages.getString("HistoryAction.description"), elementName));
        this.setToolTipText(CallHierarchyMessages.getFormattedString(CallHierarchyMessages.getString("HistoryAction.tooltip"), elementName));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.call_hierarchy_history_action_context");
    }

    private ImageDescriptor getImageDescriptor(IJavaElement elem) {
        JavaElementImageProvider imageProvider = new JavaElementImageProvider();
        ImageDescriptor desc = imageProvider.getBaseImageDescriptor(elem, 0);
        imageProvider.dispose();
        return desc;
    }

    public void run() {
        this.fView.gotoHistoryEntry(this.fMethod);
    }

    private String getElementLabel(IJavaElement element) {
        Assert.isNotNull((Object)element);
        return fLabelProvider.getText(element);
    }
}

