/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.net.URL;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenBrowserUtil {
    public static void open(final URL url, Display display, String dialogTitle) {
        if (WorkbenchHelp.getHelpSupport() != null) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    WorkbenchHelp.displayHelpResource((String)(String.valueOf(url.toExternalForm()) + "?noframes=true"));
                }
            });
        } else {
            OpenBrowserUtil.showMessage(display, dialogTitle, ActionMessages.getString("OpenBrowserUtil.help_not_available"), false);
        }
    }

    private static void showMessage(Display display, final String title, final String message, final boolean isError) {
        display.asyncExec(new Runnable(){

            public void run() {
                Shell shell = JavaPlugin.getActiveWorkbenchShell();
                if (isError) {
                    MessageDialog.openError((Shell)shell, (String)title, (String)message);
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
                }
            }
        });
    }
}

