/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.JavaIndenter;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocAutoIndentStrategy;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.TextEditorAction;

public class IndentAction
extends TextEditorAction {
    private int fCaretOffset;
    private final boolean fIsTabAction;
    static /* synthetic */ Class class$0;

    public IndentAction(ResourceBundle bundle, String prefix, ITextEditor editor, boolean isTabAction) {
        super(bundle, prefix, editor);
        this.fIsTabAction = isTabAction;
    }

    public void run() {
        if (!this.isEnabled() || !this.validateEditorInputState()) {
            return;
        }
        ITextSelection selection = this.getSelection();
        final IDocument document = this.getDocument();
        if (document != null) {
            int nLines;
            int firstLine;
            final int offset = selection.getOffset();
            final int length = selection.getLength();
            final Position end = new Position(offset + length);
            this.fCaretOffset = -1;
            try {
                document.addPosition(end);
                firstLine = document.getLineOfOffset(offset);
                int minusOne = length == 0 ? 0 : 1;
                nLines = document.getLineOfOffset(offset + length - minusOne) - firstLine + 1;
            }
            catch (BadLocationException e) {
                JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "", (Throwable)e));
                return;
            }
            Runnable runnable = new Runnable(){

                /*
                 * Exception decompiling
                 */
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 318->322)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            if (nLines > 50) {
                Display display = this.getTextEditor().getEditorSite().getWorkbenchWindow().getShell().getDisplay();
                BusyIndicator.showWhile((Display)display, (Runnable)runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void selectAndReveal(int newOffset, int newLength) {
        Assert.isTrue((newOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((newLength >= 0 ? 1 : 0) != 0);
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof JavaEditor) {
            ISourceViewer viewer = ((JavaEditor)editor).getViewer();
            if (viewer != null) {
                viewer.setSelectedRange(newOffset, newLength);
            }
        } else {
            this.getTextEditor().selectAndReveal(newOffset, newLength);
        }
    }

    private boolean indentLine(IDocument document, int line, int caret, JavaIndenter indenter, JavaHeuristicScanner scanner) throws BadLocationException {
        int lineLength;
        int end;
        IRegion currentLine = document.getLineInformation(line);
        int offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)offset);
            String type = partition.getType();
            if (partition.getOffset() < offset && type.equals("__java_javadoc") || type.equals("__java_multiline_comment")) {
                int start = 0;
                if (line > 0) {
                    IRegion previousLine = document.getLineInformation(line - 1);
                    start = previousLine.getOffset() + previousLine.getLength();
                }
                DocumentCommand command = new DocumentCommand(){};
                command.text = "\n";
                command.offset = start;
                new JavaDocAutoIndentStrategy("___java_partitioning").customizeDocumentCommand(document, command);
                int i = command.text.indexOf(42);
                indent = i != -1 ? command.text.substring(1, i) : command.text.substring(1);
            }
        }
        if (indent == null) {
            StringBuffer computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : new String();
        }
        if ((end = scanner.findNonWhitespaceForwardInAnyPartition(offset, offset + (lineLength = currentLine.getLength()))) == -1) {
            end = offset + lineLength;
        }
        int length = end - offset;
        String currentIndent = document.get(offset, length);
        if (this.fIsTabAction && caret == end && this.whiteSpaceLength(currentIndent) >= this.whiteSpaceLength(indent)) {
            String tab = this.getTabEquivalent();
            document.replace(caret, 0, tab);
            this.fCaretOffset = caret + tab.length();
            return true;
        }
        this.fCaretOffset = caret >= offset && caret <= end ? offset + indent.length() : -1;
        if (!indent.equals(currentIndent)) {
            document.replace(offset, length, indent);
            return true;
        }
        return false;
    }

    private int whiteSpaceLength(String indent) {
        if (indent == null) {
            return 0;
        }
        int size = 0;
        int l = indent.length();
        int tabSize = JavaPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.jdt.ui.editor.tab.width");
        int i = 0;
        while (i < l) {
            size += indent.charAt(i) == '\t' ? tabSize : 1;
            ++i;
        }
        return size;
    }

    private String getTabEquivalent() {
        String tab;
        if (JavaPlugin.getDefault().getPreferenceStore().getBoolean("spacesForTabs")) {
            int size = JavaCore.getPlugin().getPluginPreferences().getInt("org.eclipse.jdt.core.formatter.tabulation.size");
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < size) {
                buf.append(' ');
                ++i;
            }
            tab = buf.toString();
        } else {
            tab = "\t";
        }
        return tab;
    }

    private ISelectionProvider getSelectionProvider() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            return editor.getSelectionProvider();
        }
        return null;
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            if (this.fIsTabAction) {
                this.setEnabled(this.canModifyEditor() && this.isSmartMode() && this.isValidSelection());
            } else {
                this.setEnabled(this.canModifyEditor() && !this.getSelection().isEmpty());
            }
        }
    }

    private boolean isValidSelection() {
        ITextSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        int offset = selection.getOffset();
        int length = selection.getLength();
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        try {
            IRegion firstLine = document.getLineInformationOfOffset(offset);
            int lineOffset = firstLine.getOffset();
            if (length == 0) {
                return document.get(lineOffset, offset - lineOffset).trim().length() == 0;
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isSmartMode() {
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof ITextEditorExtension3) {
            return ((ITextEditorExtension3)editor).getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    private IDocument getDocument() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            if (provider != null && input != null) {
                return provider.getDocument((Object)input);
            }
        }
        return null;
    }

    private ITextSelection getSelection() {
        ISelection selection;
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }

    static /* synthetic */ ITextEditor access$0(IndentAction indentAction) {
        return indentAction.getTextEditor();
    }

    static /* synthetic */ boolean access$1(IndentAction indentAction, IDocument iDocument, int n, int n2, JavaIndenter javaIndenter, JavaHeuristicScanner javaHeuristicScanner) {
        return indentAction.indentLine(iDocument, n, n2, javaIndenter, javaHeuristicScanner);
    }

    static /* synthetic */ boolean access$2(IndentAction indentAction) {
        return indentAction.fIsTabAction;
    }

    static /* synthetic */ int access$3(IndentAction indentAction) {
        return indentAction.fCaretOffset;
    }

    static /* synthetic */ void access$4(IndentAction indentAction, int n, int n2) {
        indentAction.selectAndReveal(n, n2);
    }
}

