/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.AddMethodStubOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddMethodStubAction
extends Action {
    private ISelection fSelection;
    private IType fParentType;

    public AddMethodStubAction() {
        super(JavaUIMessages.getString("AddMethodStubAction.label"));
        this.setDescription(JavaUIMessages.getString("AddMethodStubAction.description"));
        this.setToolTipText(JavaUIMessages.getString("AddMethodStubAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.add_methodstub_action_context");
    }

    public boolean init(IType parentType, ISelection selection) {
        if (AddMethodStubAction.canActionBeAdded(parentType, selection)) {
            block6: {
                this.fParentType = parentType;
                this.fSelection = selection;
                if (parentType != null) {
                    try {
                        if (parentType.isInterface()) {
                            this.setText(JavaUIMessages.getFormattedString("AddMethodStubAction.detailed.implement", parentType.getElementName()));
                            break block6;
                        }
                        this.setText(JavaUIMessages.getFormattedString("AddMethodStubAction.detailed.override", parentType.getElementName()));
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                    }
                } else {
                    this.setText(JavaUIMessages.getString("AddMethodStubAction.label"));
                }
            }
            return true;
        }
        this.fParentType = null;
        this.fSelection = null;
        return false;
    }

    public void run() {
        if (!AddMethodStubAction.canActionBeAdded(this.fParentType, this.fSelection)) {
            return;
        }
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        try {
            IEditorPart editor = EditorUtility.openInEditor(this.fParentType);
            IType usedType = (IType)EditorUtility.getWorkingCopy((IMember)this.fParentType);
            if (usedType == null) {
                MessageDialog.openError((Shell)shell, (String)JavaUIMessages.getString("AddMethodStubAction.error.title"), (String)JavaUIMessages.getString("AddMethodStubAction.error.type_removed_in_editor"));
                return;
            }
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
            List list = ((IStructuredSelection)this.fSelection).toList();
            IMethod[] methods = list.toArray(new IMethod[list.size()]);
            AddMethodStubOperation op = new AddMethodStubOperation(usedType, methods, settings, this.createOverrideQuery(), this.createReplaceQuery(), false);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op));
            IMethod[] res = op.getCreatedMethods();
            if (res != null && res.length > 0 && editor != null) {
                EditorUtility.revealInEditor(editor, (IJavaElement)res[0]);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, shell, JavaUIMessages.getString("AddMethodStubAction.error.title"), null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, JavaUIMessages.getString("AddMethodStubAction.error.title"), null);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IRequestQuery createOverrideQuery() {
        return new IRequestQuery(){

            public int doQuery(IMember method) {
                String formattedMessage;
                String methodName = JavaElementLabels.getElementLabel((IJavaElement)method, 1);
                String declTypeName = JavaElementLabels.getElementLabel((IJavaElement)method.getDeclaringType(), 0);
                try {
                    formattedMessage = Flags.isFinal((int)method.getFlags()) ? JavaUIMessages.getFormattedString("AddMethodStubAction.OverridesFinalDialog.message", new String[]{methodName, declTypeName}) : JavaUIMessages.getFormattedString("AddMethodStubAction.OverridesPrivateDialog.message", new String[]{methodName, declTypeName});
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e.getStatus());
                    return 0;
                }
                return AddMethodStubAction.this.showQueryDialog(formattedMessage);
            }
        };
    }

    private IRequestQuery createReplaceQuery() {
        return new IRequestQuery(){

            public int doQuery(IMember method) {
                String methodName = JavaElementLabels.getElementLabel((IJavaElement)method, 1);
                String formattedMessage = JavaUIMessages.getFormattedString("AddMethodStubAction.ReplaceExistingDialog.message", methodName);
                return AddMethodStubAction.this.showQueryDialog(formattedMessage);
            }
        };
    }

    private int showQueryDialog(final String message) {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 3;
        nArray[2] = 1;
        int[] returnCodes = nArray;
        final Shell shell = JavaPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            JavaPlugin.logErrorMessage("AddMethodStubAction.showQueryDialog: No active shell found");
            return 0;
        }
        final int[] result = new int[]{1};
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = JavaUIMessages.getString("AddMethodStubAction.QueryDialog.title");
                String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, options, 0);
                result[0] = dialog.open();
            }
        });
        int returnVal = result[0];
        return returnVal < 0 ? 0 : returnCodes[returnVal];
    }

    public static boolean canActionBeAdded(IType parentType, ISelection selection) {
        if (parentType == null || parentType.getCompilationUnit() == null || !JavaModelUtil.isEditable(parentType.getCompilationUnit()) || !(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return false;
        }
        Object[] elems = ((IStructuredSelection)selection).toArray();
        int nSelected = elems.length;
        if (nSelected > 0) {
            int i = 0;
            while (i < nSelected) {
                Object elem = elems[i];
                if (!(elem instanceof IMethod)) {
                    return false;
                }
                IMethod meth = (IMethod)elem;
                if (meth.getDeclaringType().equals(parentType)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

