/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class WorkingCopyUtil {
    private WorkingCopyUtil() {
    }

    public static IJavaElement getWorkingCopyIfExists(IJavaElement element) {
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 5: {
                return JavaModelUtil.toWorkingCopy((ICompilationUnit)element);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return JavaModelUtil.toWorkingCopy((IMember)element);
            }
            case 12: {
                return JavaModelUtil.toWorkingCopy((IImportContainer)element);
            }
            case 13: {
                return JavaModelUtil.toWorkingCopy((IImportDeclaration)element);
            }
            case 11: {
                return JavaModelUtil.toWorkingCopy((IPackageDeclaration)element);
            }
        }
        return element;
    }

    public static ICompilationUnit getWorkingCopyIfExists(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        return JavaModelUtil.toWorkingCopy(cu);
    }

    public static IMember getWorkingCopyIfExists(IMember member) throws JavaModelException {
        if (member == null) {
            return null;
        }
        return JavaModelUtil.toWorkingCopy(member);
    }

    public static IJavaElement getOriginal(IMember member) {
        return JavaModelUtil.toOriginal(member);
    }

    public static ICompilationUnit getOriginal(ICompilationUnit cu) {
        return JavaModelUtil.toOriginal(cu);
    }

    public static IMember[] getOriginals(IMember[] members) {
        IMember[] result = new IMember[members.length];
        int i = 0;
        while (i < members.length) {
            result[i] = (IMember)WorkingCopyUtil.getOriginal(members[i]);
            ++i;
        }
        return result;
    }

    public static ICompilationUnit getNewWorkingCopy(ICompilationUnit cu) throws JavaModelException {
        return (ICompilationUnit)WorkingCopyUtil.getOriginal(cu).getWorkingCopy();
    }

    public static ICompilationUnit getNewWorkingCopy(ICompilationUnit cu, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        return WorkingCopyUtil.getOriginal(cu).getWorkingCopy(owner, null, pm);
    }

    public static ICompilationUnit getNewWorkingCopy(IPackageFragment pack, String cuName) throws JavaModelException {
        return (ICompilationUnit)pack.getCompilationUnit(cuName).getWorkingCopy();
    }

    public static ICompilationUnit getNewWorkingCopy(IPackageFragment pack, String cuName, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        return pack.getCompilationUnit(cuName).getWorkingCopy(owner, null, pm);
    }
}

