/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.StringTokenizer;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TypeFilter
implements IPropertyChangeListener {
    private static TypeFilter fgDefault;
    private StringMatcher[] fStringMatchers = null;

    public static TypeFilter getDefault() {
        if (fgDefault == null) {
            fgDefault = new TypeFilter();
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)fgDefault);
        }
        return fgDefault;
    }

    public static boolean isFiltered(String packageName) {
        return TypeFilter.getDefault().filter(packageName);
    }

    public static boolean isFiltered(char[] packageName) {
        return TypeFilter.getDefault().filter(new String(packageName));
    }

    private TypeFilter() {
    }

    private StringMatcher[] getStringMatchers() {
        if (this.fStringMatchers == null) {
            String str = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.typefilter.enabled");
            StringTokenizer tok = new StringTokenizer(str, ";");
            int nTokens = tok.countTokens();
            this.fStringMatchers = new StringMatcher[nTokens];
            int i = 0;
            while (i < nTokens) {
                this.fStringMatchers[i] = new StringMatcher(tok.nextToken(), false, false);
                ++i;
            }
        }
        return this.fStringMatchers;
    }

    public boolean filter(String packageName) {
        StringMatcher[] matchers = this.getStringMatchers();
        int i = 0;
        while (i < matchers.length) {
            StringMatcher curr = matchers[i];
            if (curr.match(packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.jdt.ui.typefilter.enabled")) {
            this.fStringMatchers = null;
            AllTypesCache.forceCacheFlush();
        }
    }
}

