/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaModelException;

public class SuperTypeHierarchyCache {
    private static final int CACHE_SIZE = 8;
    private static ArrayList fgHierarchyCache = new ArrayList(8);
    private static int fgCacheHits = 0;
    private static int fgCacheMisses = 0;
    private static int fgMaxCreationTime = 0;
    private static int fgTotCreationTime = 0;

    public static ITypeHierarchy getTypeHierarchy(IType type) throws JavaModelException {
        ArrayList arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.findTypeHierarchyInCache(type);
            if (hierarchy == null) {
                ++fgCacheMisses;
                if (fgHierarchyCache.size() >= 8) {
                    HierarchyCacheEntry entry = (HierarchyCacheEntry)fgHierarchyCache.get(0);
                    entry.freeHierarchy();
                }
                int startTime = (int)System.currentTimeMillis();
                hierarchy = type.newSupertypeHierarchy(null);
                int totTime = (int)System.currentTimeMillis() - startTime;
                if (totTime > fgMaxCreationTime) {
                    fgMaxCreationTime = totTime;
                }
                fgTotCreationTime += totTime;
                HierarchyCacheEntry newEntry = new HierarchyCacheEntry(hierarchy);
                fgHierarchyCache.add(newEntry);
            } else {
                ++fgCacheHits;
            }
            return hierarchy;
        }
    }

    public static boolean hasInCache(IType type) {
        return SuperTypeHierarchyCache.findTypeHierarchyInCache(type) != null;
    }

    private static ITypeHierarchy findTypeHierarchyInCache(IType type) {
        int i = fgHierarchyCache.size() - 1;
        while (i >= 0) {
            HierarchyCacheEntry curr = (HierarchyCacheEntry)fgHierarchyCache.get(i);
            ITypeHierarchy hierarchy = curr.getTypeHierarchy();
            if (!hierarchy.exists()) {
                curr.freeHierarchy();
            } else if (hierarchy.getType().equals(type)) {
                return hierarchy;
            }
            --i;
        }
        return null;
    }

    public static int getCacheHits() {
        return fgCacheHits;
    }

    public static int getCacheMisses() {
        return fgCacheMisses;
    }

    public static int getMaxCreationTime() {
        return fgMaxCreationTime;
    }

    public static int getAvgCreationTime() {
        return fgTotCreationTime / fgCacheMisses;
    }

    private static class HierarchyCacheEntry
    implements ITypeHierarchyChangedListener {
        private ITypeHierarchy fTypeHierarchy;

        public HierarchyCacheEntry(ITypeHierarchy hierarchy) {
            this.fTypeHierarchy = hierarchy;
            this.fTypeHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        }

        public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
            ArrayList arrayList = fgHierarchyCache;
            synchronized (arrayList) {
                this.freeHierarchy();
            }
        }

        public ITypeHierarchy getTypeHierarchy() {
            return this.fTypeHierarchy;
        }

        public void freeHierarchy() {
            this.fTypeHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            fgHierarchyCache.remove(this);
        }
    }
}

