/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.TypeInfo;

public class IFileTypeInfo
extends TypeInfo {
    private final String fProject;
    private final String fFolder;
    private final String fFile;
    private final String fExtension;

    public IFileTypeInfo(String pkg, String name, char[][] enclosingTypes, boolean isInterface, String project, String sourceFolder, String file, String extension) {
        super(pkg, name, enclosingTypes, isInterface);
        this.fProject = project;
        this.fFolder = sourceFolder;
        this.fFile = file;
        this.fExtension = extension;
    }

    public int getElementType() {
        return 3;
    }

    protected IJavaElement getJavaElement(IJavaSearchScope scope) {
        Path path;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaElement elem = JavaCore.create((IResource)root.findMember((IPath)(path = new Path(this.getPath()))));
        if (elem.exists()) {
            return elem;
        }
        return null;
    }

    public IPath getPackageFragmentRootPath() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('/');
        buffer.append(this.fProject);
        if (this.fFolder != null && this.fFolder.length() > 0) {
            buffer.append('/');
            buffer.append(this.fFolder);
        }
        return new Path(buffer.toString());
    }

    public String getPath() {
        StringBuffer result = new StringBuffer();
        result.append('/');
        result.append(this.fProject);
        result.append('/');
        if (this.fFolder != null && this.fFolder.length() > 0) {
            result.append(this.fFolder);
            result.append('/');
        }
        if (this.fPackage != null && this.fPackage.length() > 0) {
            result.append(this.fPackage.replace('.', '/'));
            result.append('/');
        }
        result.append(this.fFile);
        result.append('.');
        result.append(this.fExtension);
        return result.toString();
    }

    public String getProject() {
        return this.fProject;
    }

    public String getFolder() {
        return this.fFolder;
    }

    public String getFileName() {
        return this.fFile;
    }

    public String getExtension() {
        return this.fExtension;
    }
}

