/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterUtil {
    public static boolean OLD_FUNC = true;
    public static boolean DEBUG = false;

    public static boolean useOldFormatter() {
        return !PreferenceConstants.getPreferenceStore().getBoolean("use_new_formatter");
    }

    public static String createIndentString(int indent) {
        if (CodeFormatterUtil.useOldFormatter()) {
            return CodeFormatterUtil.old_formatter("", indent, null, "", null);
        }
        String str = CodeFormatterUtil.format(1, "x", indent, null, "", null);
        return str.substring(0, str.indexOf(120));
    }

    public static int getTabWidth() {
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        return preferences.getInt("org.eclipse.jdt.core.formatter.tabulation.size");
    }

    private static String old_formatter(String string, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        ICodeFormatter formatter = ToolFactory.createDefaultCodeFormatter((Map)options);
        return formatter.format(string, indentationLevel, positions, lineSeparator);
    }

    public static String format(int kind, String string, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        return CodeFormatterUtil.format(kind, string, 0, string.length(), indentationLevel, positions, lineSeparator, options);
    }

    public static String format(int kind, String string, int offset, int length, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        TextEdit edit = CodeFormatterUtil.format2(kind, string, offset, length, indentationLevel, lineSeparator, options);
        if (edit == null) {
            JavaPlugin.logErrorMessage("formatter failed to format (no edit returned). Will use unformatted text instead. kind: " + kind + ", string: " + string);
            return string.substring(offset, offset + length);
        }
        String formatted = CodeFormatterUtil.getOldAPICompatibleResult(string, edit, indentationLevel, positions, lineSeparator, options);
        return formatted.substring(offset, formatted.length() - (string.length() - (offset + length)));
    }

    public static String format(ASTNode node, String string, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        if (OLD_FUNC && CodeFormatterUtil.useOldFormatter()) {
            return CodeFormatterUtil.old_formatter(string, indentationLevel, positions, lineSeparator, options);
        }
        TextEdit edit = CodeFormatterUtil.format2(node, string, indentationLevel, lineSeparator, options);
        if (edit == null) {
            JavaPlugin.logErrorMessage("formatter failed to format (no edit returned). Will use unformatted text instead. node: " + node.getNodeType() + ", string: " + string);
            return string;
        }
        return CodeFormatterUtil.getOldAPICompatibleResult(string, edit, indentationLevel, positions, lineSeparator, options);
    }

    private static String getOldAPICompatibleResult(String string, TextEdit edit, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        Position[] p = null;
        if (positions != null) {
            p = new Position[positions.length];
            int i = 0;
            while (i < positions.length) {
                p[i] = new Position(positions[i], 0);
                ++i;
            }
        }
        String res = CodeFormatterUtil.evaluateFormatterEdit(string, edit, p);
        int[] positionCopy = null;
        if (positions != null) {
            if (DEBUG) {
                positionCopy = (int[])positions.clone();
            }
            int i = 0;
            while (i < positions.length) {
                Position curr = p[i];
                positions[i] = curr.getOffset();
                ++i;
            }
        }
        if (DEBUG) {
            String oldFormat = CodeFormatterUtil.old_formatter(string, indentationLevel, positionCopy, lineSeparator, options);
            CodeFormatterUtil.testSame(res, oldFormat, positions, positionCopy);
        }
        return res;
    }

    public static String evaluateFormatterEdit(String string, TextEdit edit, Position[] positions) {
        try {
            Document doc = CodeFormatterUtil.createDocument(string, positions);
            edit.apply((IDocument)doc, 0);
            if (positions != null) {
                int i = 0;
                while (i < positions.length) {
                    Assert.isTrue(!positions[i].isDeleted, "Position got deleted");
                    ++i;
                }
            }
            return doc.get();
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            Assert.isTrue(false, "Fromatter created edits with wrong positions: " + e.getMessage());
            return null;
        }
    }

    public static TextEdit format2(int kind, String string, int offset, int length, int indentationLevel, String lineSeparator, Map options) {
        if (offset < 0 || length < 0 || offset + length > string.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + offset + ", length: " + length + ", string size: " + string.length());
        }
        if (CodeFormatterUtil.useOldFormatter()) {
            return CodeFormatterUtil.emulateNewWithOld(string, offset, length, indentationLevel, lineSeparator, options);
        }
        return ToolFactory.createCodeFormatter((Map)options).format(kind, string, offset, length, indentationLevel, lineSeparator);
    }

    public static TextEdit format2(int kind, String string, int indentationLevel, String lineSeparator, Map options) {
        return CodeFormatterUtil.format2(kind, string, 0, string.length(), indentationLevel, lineSeparator, options);
    }

    public static TextEdit format2(ASTNode node, String str, int indentationLevel, String lineSeparator, Map options) {
        int code;
        String prefix = "";
        String suffix = "";
        if (node instanceof Statement) {
            code = 2;
            if (node.getNodeType() == 49) {
                prefix = "switch(1) {";
                suffix = "}";
                code = 2;
            }
        } else if (node instanceof Expression) {
            code = 1;
            if (node instanceof Type) {
                suffix = " x;";
            }
        } else {
            switch (node.getNodeType()) {
                case 23: 
                case 28: 
                case 31: 
                case 55: {
                    code = 4;
                    break;
                }
                case 5: 
                case 39: 
                case 43: {
                    suffix = " x;";
                    code = 1;
                    break;
                }
                case 15: {
                    code = 8;
                    break;
                }
                case 44: 
                case 58: {
                    suffix = ";";
                    code = 2;
                    break;
                }
                case 59: {
                    prefix = "A ";
                    suffix = ";";
                    code = 2;
                    break;
                }
                case 26: 
                case 35: {
                    suffix = "\nclass A {}";
                    code = 8;
                    break;
                }
                case 29: {
                    suffix = "void foo();";
                    code = 4;
                    break;
                }
                case 12: {
                    prefix = "try {}";
                    code = 2;
                    break;
                }
                case 1: {
                    prefix = "new A()";
                    suffix = ";";
                    code = 2;
                    break;
                }
                default: {
                    Assert.isTrue(false, "Node type not covered: " + node.getClass().getName());
                    return null;
                }
            }
        }
        String concatStr = String.valueOf(prefix) + str + suffix;
        TextEdit edit = CodeFormatterUtil.format2(code, concatStr, prefix.length(), str.length(), indentationLevel, lineSeparator, options);
        if (prefix.length() > 0) {
            edit = CodeFormatterUtil.shifEdit(edit, prefix.length());
        }
        return edit;
    }

    private static TextEdit emulateNewWithOld(String string, int offset, int length, int indentationLevel, String lineSeparator, Map options) {
        String formatted = CodeFormatterUtil.old_formatter(string, indentationLevel, null, lineSeparator, options);
        IScanner origScanner = CodeFormatterUtil.getTokenScanner(string);
        IScanner newScanner = CodeFormatterUtil.getTokenScanner(formatted);
        MultiTextEdit result = new MultiTextEdit();
        int end = offset + length;
        try {
            int origNextStart = 0;
            int newNextStart = 0;
            do {
                char[] newComment;
                char[] origComment;
                int newEnd;
                int origEnd;
                int newTok;
                int origTok;
                Assert.isTrue((origTok = origScanner.getNextToken()) == (newTok = newScanner.getNextToken()));
                int origStart = origNextStart;
                int newStart = newNextStart;
                if (origTok == 158) {
                    origEnd = string.length();
                    newEnd = formatted.length();
                    origNextStart = -1;
                } else {
                    origEnd = origScanner.getCurrentTokenStartPosition();
                    newEnd = newScanner.getCurrentTokenStartPosition();
                    origNextStart = origScanner.getCurrentTokenEndPosition() + 1;
                    newNextStart = newScanner.getCurrentTokenEndPosition() + 1;
                }
                if (origStart >= offset && origEnd > offset && origStart < end && origEnd <= end && CodeFormatterUtil.isDifferent(string, origStart, origEnd, formatted, newStart, newEnd)) {
                    ReplaceEdit edit = new ReplaceEdit(origStart, origEnd - origStart, formatted.substring(newStart, newEnd));
                    result.addChild((TextEdit)edit);
                }
                if (!TokenScanner.isComment(origTok) || origEnd < offset || origNextStart > end || CharOperation.equals((char[])(origComment = origScanner.getCurrentTokenSource()), (char[])(newComment = newScanner.getCurrentTokenSource()))) continue;
                CodeFormatterUtil.commentDifferent(new String(origComment), new String(newComment), origEnd, (TextEdit)result);
            } while (origNextStart != -1);
            if (indentationLevel > 0) {
                result.addChild((TextEdit)new InsertEdit(offset, CodeFormatterUtil.createIndentString(indentationLevel)));
            }
            return result;
        }
        catch (MalformedTreeException e) {
            JavaPlugin.log(e);
            Assert.isTrue(false, e.getMessage());
        }
        catch (InvalidInputException invalidInputException) {}
        return null;
    }

    private static void commentDifferent(String origComment, String newComment, int offset, TextEdit result) {
        DefaultLineTracker tracker1 = new DefaultLineTracker();
        tracker1.set(origComment);
        DefaultLineTracker tracker2 = new DefaultLineTracker();
        tracker2.set(newComment);
        ArrayList<ReplaceEdit> res = new ArrayList<ReplaceEdit>();
        int nLines = tracker2.getNumberOfLines();
        if (tracker1.getNumberOfLines() == nLines) {
            try {
                int start1 = 0;
                int start2 = 0;
                int i = 0;
                while (i < nLines) {
                    int sameStart2;
                    IRegion region1 = tracker1.getLineInformation(i);
                    IRegion region2 = tracker2.getLineInformation(i);
                    int lineEnd1 = region1.getOffset() + region1.getLength();
                    int lineEnd2 = region2.getOffset() + region2.getLength();
                    int sameStart1 = region1.getOffset();
                    if (CodeFormatterUtil.isDifferent(origComment, sameStart1, lineEnd1, newComment, sameStart2 = lineEnd2 - region1.getLength(), lineEnd2)) {
                        if (DEBUG) {
                            System.out.println("Comment line changed: is: " + origComment.substring(sameStart1, lineEnd1) + ", was: " + newComment.substring(sameStart2, lineEnd2));
                        }
                        res.add(new ReplaceEdit(start1 + offset, lineEnd1 - start1, newComment.substring(start2, lineEnd2)));
                    } else if (CodeFormatterUtil.isDifferent(origComment, start1, sameStart1, newComment, start2, sameStart2)) {
                        res.add(new ReplaceEdit(start1 + offset, sameStart1 - start1, newComment.substring(start2, sameStart2)));
                    }
                    start1 = lineEnd1;
                    start2 = lineEnd2;
                    ++i;
                }
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
                res.clear();
            }
        }
        if (res.isEmpty()) {
            result.addChild((TextEdit)new ReplaceEdit(offset, origComment.length(), newComment));
        } else {
            int i = 0;
            while (i < res.size()) {
                result.addChild((TextEdit)res.get(i));
                ++i;
            }
        }
    }

    private static IScanner getTokenScanner(String str) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        return scanner;
    }

    private static boolean isDifferent(String old, int oldStart, int oldEnd, String formatted, int formStart, int formEnd) {
        if (oldEnd - oldStart != formEnd - formStart) {
            return true;
        }
        int i = oldStart;
        int j = formStart;
        while (i < oldEnd) {
            if (old.charAt(i) != formatted.charAt(j)) {
                return true;
            }
            ++i;
            ++j;
        }
        return false;
    }

    private static TextEdit shifEdit(TextEdit oldEdit, int diff) {
        MultiTextEdit newEdit;
        ReplaceEdit edit;
        if (oldEdit instanceof ReplaceEdit) {
            edit = (ReplaceEdit)oldEdit;
            newEdit = new ReplaceEdit(edit.getOffset() - diff, edit.getLength(), edit.getText());
        } else if (oldEdit instanceof InsertEdit) {
            edit = (InsertEdit)oldEdit;
            newEdit = new InsertEdit(edit.getOffset() - diff, edit.getText());
        } else if (oldEdit instanceof DeleteEdit) {
            edit = (DeleteEdit)oldEdit;
            newEdit = new DeleteEdit(edit.getOffset() - diff, edit.getLength());
        } else if (oldEdit instanceof MultiTextEdit) {
            newEdit = new MultiTextEdit();
        } else {
            return null;
        }
        TextEdit[] children = oldEdit.getChildren();
        int i = 0;
        while (i < children.length) {
            TextEdit shifted = CodeFormatterUtil.shifEdit(children[i], diff);
            if (shifted != null) {
                newEdit.addChild(shifted);
            }
            ++i;
        }
        return newEdit;
    }

    private static void testSame(String a, String b, int[] p1, int[] p2) {
        if (!a.equals(b)) {
            System.out.println("diff: " + a + ", " + b);
        }
        if (p1 != null) {
            int i = 0;
            while (i < p2.length) {
                if (p1[i] != p2[i]) {
                    System.out.println("diff: " + p1[i] + ", " + p2[i]);
                }
                ++i;
            }
        }
    }

    private static Document createDocument(String string, Position[] positions) throws IllegalArgumentException {
        Document doc;
        block5: {
            doc = new Document(string);
            try {
                if (positions == null) break block5;
                doc.addPositionCategory("myCategory");
                doc.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("myCategory"){

                    protected boolean notDeleted() {
                        if (this.fOffset < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < this.fOffset + this.fLength) {
                            this.fPosition.offset = this.fOffset + this.fLength;
                            return false;
                        }
                        return true;
                    }
                });
                int i = 0;
                while (i < positions.length) {
                    try {
                        doc.addPosition("myCategory", positions[i]);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + positions[i].offset + ", length: " + positions[i].length + ", string size: " + string.length());
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        return doc;
    }
}

