/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.corext.util.UnresolvableTypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.widgets.Display;

public class AllTypesCache {
    private static final int INITIAL_DELAY = 4000;
    private static final int TIMEOUT = 3000;
    private static final int INITIAL_SIZE = 2000;
    private static Object fgLock = new Object();
    private static boolean fgIsLocked;
    private static volatile TypeCacher fgTypeCacherThread;
    private static TypeInfo[] fgTypeCache;
    private static int fgSizeHint;
    private static boolean fgTerminated;
    private static boolean fgAsyncMode;
    private static int fgNumberOfCacheFlushes;
    private static TypeCacheDeltaListener fgDeltaListener;
    private static Comparator fgTypeNameComparator;

    static {
        fgSizeHint = 2000;
        fgTypeNameComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((TypeInfo)o1).getTypeName().compareTo(((TypeInfo)o2).getTypeName());
            }
        };
    }

    public static void getTypes(IJavaSearchScope scope, int kind, IProgressMonitor monitor, Collection typesFound) throws JavaModelException {
        TypeInfo[] allTypes = AllTypesCache.getAllTypes(monitor);
        boolean isWorkspaceScope = scope.equals(SearchEngine.createWorkspaceScope());
        boolean isBoth = kind == 0;
        boolean isInterface = kind == 6;
        int i = 0;
        while (i < allTypes.length) {
            TypeInfo info = fgTypeCache[i];
            if ((isWorkspaceScope || info.isEnclosed(scope)) && (isBoth || isInterface == info.isInterface())) {
                typesFound.add(info);
            }
            ++i;
        }
    }

    private static void setCache(TypeInfo[] cache) {
        Object object = fgLock;
        synchronized (object) {
            fgTypeCache = cache;
            if (fgTypeCache != null) {
                fgSizeHint = fgTypeCache.length;
            }
            fgTypeCacherThread = null;
            fgLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TypeInfo[] getAllTypes(IProgressMonitor monitor) throws JavaModelException {
        AllTypesCache.forceDeltaComplete();
        var1_1 = AllTypesCache.fgLock;
        synchronized (var1_1) {
            block11: {
                if (AllTypesCache.fgTypeCache != null) break block11;
                if (AllTypesCache.fgTypeCacherThread != null) ** GOTO lbl-1000
                searchResult = new ArrayList<E>(AllTypesCache.fgSizeHint);
                try {
                    AllTypesCache.fgIsLocked = true;
                    if (AllTypesCache.search(new TypeInfoRequestor(searchResult), 3, monitor)) {
                        result = searchResult.toArray(new TypeInfo[searchResult.size()]);
                        Arrays.sort(result, AllTypesCache.fgTypeNameComparator);
                        AllTypesCache.fgTypeCache = result;
                        AllTypesCache.fgSizeHint = result.length;
                    }
                }
                catch (Throwable var5_4) {
                    var4_5 = null;
                    AllTypesCache.fgIsLocked = false;
                    throw var5_4;
                }
                {
                    var4_6 = null;
                    AllTypesCache.fgIsLocked = false;
                    break block11;
                }
lbl-1000:
                // 2 sources

                {
                    while (AllTypesCache.fgTypeCache == null) {
                        AllTypesCache.fgLock.wait();
                    }
                }
            }
            if (monitor != null) {
                monitor.done();
            }
            return AllTypesCache.fgTypeCache;
        }
    }

    public static boolean isCacheUpToDate() {
        AllTypesCache.forceDeltaComplete();
        return fgTypeCache != null;
    }

    private static void forceDeltaComplete() {
        ICompilationUnit[] primaryWorkingCopies = JavaCore.getWorkingCopies(null);
        int i = 0;
        while (i < primaryWorkingCopies.length) {
            ICompilationUnit curr = primaryWorkingCopies[i];
            try {
                ICompilationUnit iCompilationUnit = curr;
                synchronized (iCompilationUnit) {
                    curr.reconcile();
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            ++i;
        }
    }

    public static int getNumberOfAllTypesHint() {
        return fgSizeHint;
    }

    public static void forceCacheFlush() {
        if (fgTerminated) {
            return;
        }
        Object object = fgLock;
        synchronized (object) {
            fgTypeCache = null;
            ++fgNumberOfCacheFlushes;
            if (fgTypeCacherThread != null) {
                fgTypeCacherThread.restart();
            } else if (fgAsyncMode) {
                fgTypeCacherThread = new TypeCacher(fgSizeHint, 3000, null);
                fgTypeCacherThread.start();
            }
        }
    }

    public static int getNumberOfCacheFlushes() {
        return fgNumberOfCacheFlushes;
    }

    public static TypeInfo[] getTypesForName(String simpleTypeName, IJavaSearchScope searchScope, IProgressMonitor monitor) throws JavaModelException {
        UnresolvableTypeInfo key;
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        HashSet<String> namesFound = new HashSet<String>();
        TypeInfo[] allTypes = AllTypesCache.getAllTypes(monitor);
        int index = Arrays.binarySearch(allTypes, key = new UnresolvableTypeInfo("", simpleTypeName, null, true, null), fgTypeNameComparator);
        if (index >= 0 && index < allTypes.length) {
            TypeInfo curr;
            int i = index - 1;
            while (i >= 0) {
                curr = allTypes[i];
                if (!simpleTypeName.equals(curr.getTypeName())) break;
                if (!namesFound.contains(curr.getFullyQualifiedName()) && curr.isEnclosed(searchScope)) {
                    result.add(curr);
                    namesFound.add(curr.getFullyQualifiedName());
                }
                --i;
            }
            i = index;
            while (i < allTypes.length) {
                curr = allTypes[i];
                if (!simpleTypeName.equals(curr.getTypeName())) break;
                if (!namesFound.contains(curr.getFullyQualifiedName()) && curr.isEnclosed(searchScope)) {
                    result.add(curr);
                    namesFound.add(curr.getFullyQualifiedName());
                }
                ++i;
            }
        }
        return result.toArray(new TypeInfo[result.size()]);
    }

    public static boolean isIndexUpToDate() {
        class TypeFoundException
        extends Error {
            TypeFoundException() {
            }
        }
        ITypeNameRequestor requestor = new ITypeNameRequestor(){

            public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                throw new TypeFoundException();
            }

            public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                throw new TypeFoundException();
            }
        };
        try {
            if (!AllTypesCache.search(requestor, 2, null)) {
                return false;
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        catch (TypeFoundException typeFoundException) {}
        return true;
    }

    static boolean search(ITypeNameRequestor requestor, int waitingPolicy, IProgressMonitor monitor) {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            new SearchEngine().searchAllTypeNames(ResourcesPlugin.getWorkspace(), null, null, 2, false, 0, SearchEngine.createWorkspaceScope(), requestor, waitingPolicy, monitor);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
        return true;
    }

    public static void initialize() {
        fgDeltaListener = new TypeCacheDeltaListener();
        JavaCore.addElementChangedListener((IElementChangedListener)fgDeltaListener);
        Display d = Display.getDefault();
        if (d != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    AllTypesCache.startBackgroundMode();
                }
            });
        }
    }

    private static void startBackgroundMode() {
        AllTypesCache.forceDeltaComplete();
        if (fgIsLocked) {
            fgAsyncMode = true;
            return;
        }
        Object object = fgLock;
        synchronized (object) {
            if (fgTypeCacherThread != null) {
                if (fgTerminated && fgTypeCacherThread != null) {
                    fgTypeCacherThread.abort();
                }
            } else if (!fgTerminated) {
                fgAsyncMode = true;
                if (fgTypeCache == null) {
                    fgTypeCacherThread = new TypeCacher(fgSizeHint, 4000, null);
                    fgTypeCacherThread.start();
                }
            }
        }
    }

    public static void terminate() {
        if (fgDeltaListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)fgDeltaListener);
        }
        fgDeltaListener = null;
        Object object = fgLock;
        synchronized (object) {
            fgTerminated = true;
            fgAsyncMode = false;
            if (fgTypeCacherThread != null) {
                fgTypeCacherThread.abort();
                try {
                    fgTypeCacherThread.join(1000L);
                }
                catch (InterruptedException e) {
                    JavaPlugin.log(e);
                }
                fgTypeCacherThread = null;
            }
        }
    }

    static class TypeCacher
    extends Thread {
        private int fDelay;
        private int fSizeHint;
        private volatile boolean fRestart;
        private volatile boolean fAbort;
        private IProgressMonitor fMonitor;

        TypeCacher(int sizeHint, int delay, IProgressMonitor monitor) {
            super("All Types Caching");
            this.fSizeHint = sizeHint;
            this.fDelay = delay;
            this.fMonitor = monitor;
            this.setPriority(4);
        }

        void restart() {
            this.fRestart = true;
            this.interrupt();
        }

        public void abort() {
            this.fAbort = true;
            this.fRestart = true;
            this.interrupt();
        }

        public void run() {
            while (!this.fAbort) {
                if (this.fDelay > 0) {
                    try {
                        Thread.sleep(this.fDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.fAbort) continue;
                        break;
                    }
                }
                this.fRestart = false;
                Collection searchResult = this.doSearchTypes();
                if (searchResult == null) continue;
                if (!this.fAbort && !this.fRestart) {
                    TypeInfo[] result = searchResult.toArray(new TypeInfo[searchResult.size()]);
                    Arrays.sort(result, fgTypeNameComparator);
                    AllTypesCache.setCache(result);
                }
                if (!this.fRestart) break;
            }
        }

        private Collection doSearchTypes() {
            class RequestorAbort
            extends Error {
                final /* synthetic */ TypeCacher this$1;

                RequestorAbort(TypeCacher typeCacher) {
                    this.this$1 = typeCacher;
                }
            }
            if (ResourcesPlugin.getWorkspace() == null) {
                return null;
            }
            ArrayList typesFound = new ArrayList(this.fSizeHint);
            TypeInfoRequestor requestor = new TypeInfoRequestor(this, typesFound){
                final /* synthetic */ TypeCacher this$1;
                {
                    this.this$1 = typeCacher;
                }

                protected boolean inScope(char[] packageName) {
                    if (TypeCacher.access$0(this.this$1)) {
                        throw new RequestorAbort(this.this$1);
                    }
                    return super.inScope(packageName);
                }
            };
            try {
                if (!AllTypesCache.search(requestor, 3, this.fMonitor)) {
                    return null;
                }
            }
            catch (RequestorAbort requestorAbort) {
                return null;
            }
            return typesFound;
        }

        static /* synthetic */ boolean access$0(TypeCacher typeCacher) {
            return typeCacher.fRestart;
        }
    }

    private static class TypeCacheDeltaListener
    implements IElementChangedListener {
        TypeCacheDeltaListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (fgTerminated) {
                return;
            }
            boolean needsFlushing = this.processDelta(event.getDelta());
            if (needsFlushing) {
                AllTypesCache.forceCacheFlush();
            }
        }

        private boolean processDelta(IJavaElementDelta delta) {
            IJavaElement elem = delta.getElement();
            boolean isAddedOrRemoved = delta.getKind() != 4 || (delta.getFlags() & 0xC0) != 0;
            switch (elem.getElementType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    if (isAddedOrRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 5: {
                    if (!JavaModelUtil.isPrimary((ICompilationUnit)elem)) {
                        return false;
                    }
                    if (((ICompilationUnit)elem).isWorkingCopy()) {
                        // empty if block
                    }
                    if (isAddedOrRemoved || this.isPossibleStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isPossibleStructuralChange(int flags) {
            return (flags & 0x4001) == 1;
        }

        private boolean processChildrenDelta(IJavaElementDelta delta) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.processDelta(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

