/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jdt.internal.corext.template.TemplateVariable;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.corext.template.java.GlobalVariables;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jface.text.IDocument;

public class JavaContextType
extends CompilationUnitContextType {
    public static final String NAME = "java";

    public JavaContextType() {
        super(NAME);
        this.addVariable(new GlobalVariables.Cursor());
        this.addVariable(new GlobalVariables.WordSelection());
        this.addVariable(new GlobalVariables.LineSelection());
        this.addVariable(new GlobalVariables.Dollar());
        this.addVariable(new GlobalVariables.Date());
        this.addVariable(new GlobalVariables.Year());
        this.addVariable(new GlobalVariables.Time());
        this.addVariable(new GlobalVariables.User());
        this.addVariable(new CompilationUnitContextType.File());
        this.addVariable(new CompilationUnitContextType.PrimaryTypeName());
        this.addVariable(new CompilationUnitContextType.ReturnType());
        this.addVariable(new CompilationUnitContextType.Method());
        this.addVariable(new CompilationUnitContextType.Type());
        this.addVariable(new CompilationUnitContextType.Package());
        this.addVariable(new CompilationUnitContextType.Project());
        this.addVariable(new CompilationUnitContextType.Arguments());
        this.addVariable(new Array());
        this.addVariable(new ArrayType());
        this.addVariable(new ArrayElement());
        this.addVariable(new Index());
        this.addVariable(new Iterator());
        this.addVariable(new Collection());
        this.addVariable(new Todo());
    }

    public CompilationUnitContext createContext(IDocument document, int offset, int length, ICompilationUnit compilationUnit) {
        return new JavaContext(this, document, offset, length, compilationUnit);
    }

    protected static class Array
    extends TemplateVariable {
        public Array() {
            super("array", JavaTemplateMessages.getString("JavaContextType.variable.description.array"));
        }

        public String evaluate(TemplateContext context) {
            return ((JavaContext)context).guessArray();
        }
    }

    protected static class ArrayType
    extends TemplateVariable {
        public ArrayType() {
            super("array_type", JavaTemplateMessages.getString("JavaContextType.variable.description.array.type"));
        }

        public String evaluate(TemplateContext context) {
            return ((JavaContext)context).guessArrayType();
        }
    }

    protected static class ArrayElement
    extends TemplateVariable {
        public ArrayElement() {
            super("array_element", JavaTemplateMessages.getString("JavaContextType.variable.description.array.element"));
        }

        public String evaluate(TemplateContext context) {
            return ((JavaContext)context).guessArrayElement();
        }
    }

    protected static class Index
    extends TemplateVariable {
        public Index() {
            super("index", JavaTemplateMessages.getString("JavaContextType.variable.description.index"));
        }

        public String evaluate(TemplateContext context) {
            return ((JavaContext)context).getIndex();
        }
    }

    protected static class Collection
    extends TemplateVariable {
        public Collection() {
            super("collection", JavaTemplateMessages.getString("JavaContextType.variable.description.collection"));
        }

        public String evaluate(TemplateContext context) {
            return ((JavaContext)context).guessCollection();
        }
    }

    protected static class Iterator
    extends TemplateVariable {
        public Iterator() {
            super("iterator", JavaTemplateMessages.getString("JavaContextType.variable.description.iterator"));
        }

        public String evaluate(TemplateContext context) {
            JavaContext javaContext = (JavaContext)context;
            if (!context.isReadOnly()) {
                javaContext.addIteratorImport();
            }
            return javaContext.getIterator();
        }
    }

    protected static class Todo
    extends TemplateVariable {
        public Todo() {
            super("todo", JavaTemplateMessages.getString("JavaContextType.variable.description.todo"));
        }

        public String evaluate(TemplateContext context) {
            JavaContext javaContext = (JavaContext)context;
            ICompilationUnit compilationUnit = javaContext.getCompilationUnit();
            if (compilationUnit == null) {
                return "XXX";
            }
            IJavaProject javaProject = compilationUnit.getJavaProject();
            String todoTaskTag = StubUtility.getTodoTaskTag(javaProject);
            if (todoTaskTag == null) {
                return "XXX";
            }
            return todoTaskTag;
        }
    }
}

