/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.text.DateFormat;
import java.util.Calendar;
import org.eclipse.jdt.internal.corext.template.SimpleTemplateVariable;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;

public class GlobalVariables {

    public static class Cursor
    extends SimpleTemplateVariable {
        public static final String NAME = "cursor";

        public Cursor() {
            super(NAME, JavaTemplateMessages.getString("GlobalVariables.variable.description.cursor"));
            this.setResolved(true);
            this.setEvaluationString("");
        }
    }

    public static class WordSelection
    extends SimpleTemplateVariable {
        public static final String NAME = "word_selection";

        public WordSelection() {
            super(NAME, JavaTemplateMessages.getString("GlobalVariables.variable.description.selectedWord"));
            this.setResolved(true);
        }

        public String evaluate(TemplateContext context) {
            String selection = context.getVariable("selection");
            if (selection == null) {
                return "";
            }
            return selection;
        }
    }

    public static class LineSelection
    extends SimpleTemplateVariable {
        public static final String NAME = "line_selection";

        public LineSelection() {
            super(NAME, JavaTemplateMessages.getString("GlobalVariables.variable.description.selectedLines"));
            this.setResolved(true);
        }

        public String evaluate(TemplateContext context) {
            String selection = context.getVariable("selection");
            if (selection == null) {
                return "";
            }
            return selection;
        }
    }

    static class Dollar
    extends SimpleTemplateVariable {
        public Dollar() {
            super("dollar", JavaTemplateMessages.getString("GlobalVariables.variable.description.dollar"));
            this.setEvaluationString("$");
            this.setResolved(true);
        }
    }

    static class Date
    extends SimpleTemplateVariable {
        public Date() {
            super("date", JavaTemplateMessages.getString("GlobalVariables.variable.description.date"));
            this.setResolved(true);
        }

        public String evaluate(TemplateContext context) {
            return DateFormat.getDateInstance().format(new java.util.Date());
        }
    }

    static class Year
    extends SimpleTemplateVariable {
        public Year() {
            super("year", JavaTemplateMessages.getString("GlobalVariables.variable.description.year"));
            this.setResolved(true);
        }

        public String evaluate(TemplateContext context) {
            return Integer.toString(Calendar.getInstance().get(1));
        }
    }

    static class Time
    extends SimpleTemplateVariable {
        public Time() {
            super("time", JavaTemplateMessages.getString("GlobalVariables.variable.description.time"));
            this.setResolved(true);
        }

        public String evaluate(TemplateContext context) {
            return DateFormat.getTimeInstance().format(new java.util.Date());
        }
    }

    static class User
    extends SimpleTemplateVariable {
        public User() {
            super("user", JavaTemplateMessages.getString("GlobalVariables.variable.description.user"));
            this.setResolved(true);
        }

        public String evaluate(TemplateContext context) {
            return System.getProperty("user.name");
        }
    }
}

