/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateBuffer;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jdt.internal.corext.template.TemplateTranslator;
import org.eclipse.jdt.internal.corext.template.TemplateVariable;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContextType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;

public class CodeTemplateContext
extends TemplateContext {
    private String fLineDelimiter;
    private IJavaProject fProject;

    public CodeTemplateContext(String contextTypeName, IJavaProject project, String lineDelim) {
        super(ContextTypeRegistry.getInstance().getContextType(contextTypeName));
        this.fLineDelimiter = lineDelim;
        this.fProject = project;
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public TemplateBuffer evaluate(Template template) throws CoreException {
        Iterator iterator = this.getContextType().variableIterator();
        while (iterator.hasNext()) {
            TemplateVariable var = (TemplateVariable)iterator.next();
            if (!(var instanceof CodeTemplateContextType.CodeTemplateVariable)) continue;
            Assert.isNotNull(this.getVariable(var.getName()), "Variable " + var.getName() + "not defined");
        }
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        String pattern = CodeTemplateContext.changeLineDelimiter(template.getPattern(), this.fLineDelimiter);
        TemplateBuffer buffer = translator.translate(pattern);
        if (buffer == null) {
            return null;
        }
        this.getContextType().edit(buffer, this);
        return buffer;
    }

    private static String changeLineDelimiter(String code, String lineDelim) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(code);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return code;
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < nLines) {
                if (i != 0) {
                    buf.append(lineDelim);
                }
                IRegion region = tracker.getLineInformation(i);
                String line = code.substring(region.getOffset(), region.getOffset() + region.getLength());
                buf.append(line);
                ++i;
            }
            return buf.toString();
        }
        catch (BadLocationException badLocationException) {
            return code;
        }
    }

    public boolean canEvaluate(Template template) {
        return true;
    }

    public void setCompilationUnitVariables(ICompilationUnit cu) {
        this.setVariable("file_name", cu.getElementName());
        this.setVariable("package_name", cu.getParent().getElementName());
        this.setVariable("project_name", cu.getJavaProject().getElementName());
    }
}

