/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.template.TemplateMessages;
import org.eclipse.jdt.internal.corext.template.TemplateSet;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;

public class Templates
extends TemplateSet {
    private static final String DEFAULT_FILE = "default-templates.xml";
    private static final String TEMPLATE_FILE = "templates.xml";
    private static Templates fgTemplates;
    static /* synthetic */ Class class$0;

    public static Templates getInstance() {
        if (fgTemplates == null) {
            fgTemplates = new Templates();
        }
        return fgTemplates;
    }

    public Templates() {
        super("template");
        this.create();
    }

    private void create() {
        try {
            File templateFile = Templates.getTemplateFile();
            if (templateFile.exists()) {
                this.addFromFile(templateFile, true);
            } else {
                this.addFromStream(Templates.getDefaultsAsStream(), true, true);
                this.saveToFile(templateFile);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            ErrorDialog.openError(null, (String)TemplateMessages.getString("Templates.error.title"), (String)e.getMessage(), (IStatus)e.getStatus());
            this.clear();
        }
    }

    public void reset() throws CoreException {
        this.clear();
        this.addFromFile(Templates.getTemplateFile(), true);
    }

    public void restoreDefaults() throws CoreException {
        this.clear();
        this.addFromStream(Templates.getDefaultsAsStream(), true, true);
    }

    public void save() throws CoreException {
        this.saveToFile(Templates.getTemplateFile());
    }

    private static InputStream getDefaultsAsStream() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.internal.corext.template.Templates;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getResourceAsStream(DEFAULT_FILE);
    }

    private static File getTemplateFile() {
        IPath path = JavaPlugin.getDefault().getStateLocation();
        path = path.append(TEMPLATE_FILE);
        return path.toFile();
    }
}

