/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIException;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TemplateSet {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String CONTEXT_ATTRIBUTE = "context";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private List fTemplates = new ArrayList();
    private String fTemplateTag;

    public TemplateSet(String templateTag) {
        this.fTemplateTag = templateTag;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFromFile(File file, boolean allowDuplicates) throws CoreException {
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(file);
                this.addFromStream(stream, allowDuplicates, false);
            }
            catch (IOException e) {
                TemplateSet.throwReadException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (stream == null) throw throwable;
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (stream == null) return;
        ((InputStream)stream).close();
    }

    public String getTemplateTag() {
        return this.fTemplateTag;
    }

    public void addFromStream(InputStream stream, boolean allowDuplicates, boolean doTranslations) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(new InputSource(stream));
            NodeList elements = document.getElementsByTagName(this.getTemplateTag());
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    Template template;
                    String message;
                    String name = this.getAttributeValue(attributes, NAME_ATTRIBUTE);
                    String description = this.getAttributeValue(attributes, DESCRIPTION_ATTRIBUTE);
                    if (doTranslations) {
                        description = this.translateString(description);
                    }
                    String context = this.getAttributeValue(attributes, CONTEXT_ATTRIBUTE);
                    Node enabledNode = attributes.getNamedItem(ENABLED_ATTRIBUTE);
                    if (name == null || description == null || context == null) {
                        throw new SAXException(TemplateMessages.getString("TemplateSet.error.missing.attribute"));
                    }
                    boolean enabled = enabledNode == null || enabledNode.getNodeValue().equals("true");
                    StringBuffer buffer = new StringBuffer();
                    NodeList children = node.getChildNodes();
                    int j = 0;
                    while (j != children.getLength()) {
                        String value = children.item(j).getNodeValue();
                        if (value != null) {
                            buffer.append(value);
                        }
                        ++j;
                    }
                    String pattern = buffer.toString().trim();
                    if (doTranslations) {
                        pattern = this.translateString(pattern);
                    }
                    if ((message = this.validateTemplate(template = new Template(name, description, context, pattern))) == null) {
                        template.setEnabled(enabled);
                        if (!allowDuplicates) {
                            Template[] templates = this.getTemplates(name);
                            int k = 0;
                            while (k < templates.length) {
                                this.remove(templates[k]);
                                ++k;
                            }
                        }
                        this.add(template);
                    } else {
                        JavaPlugin.logErrorMessage("Template " + name + " not added: " + message);
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            TemplateSet.throwReadException(e);
        }
        catch (IOException e) {
            TemplateSet.throwReadException(e);
        }
        catch (SAXException e) {
            TemplateSet.throwReadException(e);
        }
    }

    private String translateString(String str) {
        int idx = str.indexOf(37);
        if (idx == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        int k = 0;
        while (idx != -1) {
            buf.append(str.substring(k, idx));
            k = idx + 1;
            while (k < str.length() && !Character.isWhitespace(str.charAt(k))) {
                ++k;
            }
            String key = str.substring(idx + 1, k);
            buf.append(TemplateMessages.getString(key));
            idx = str.indexOf(37, k);
        }
        buf.append(str.substring(k));
        return buf.toString();
    }

    protected String validateTemplate(Template template) throws CoreException {
        ContextType type = ContextTypeRegistry.getInstance().getContextType(template.getContextTypeName());
        if (type == null) {
            return "Unknown context type: " + template.getContextTypeName();
        }
        return type.validate(template.getPattern());
    }

    private String getAttributeValue(NamedNodeMap attributes, String name) {
        Node node = attributes.getNamedItem(name);
        return node == null ? null : node.getNodeValue();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveToFile(File file) throws CoreException {
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(file);
                this.saveToStream(stream);
            }
            catch (IOException e) {
                TemplateSet.throwWriteException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (stream == null) throw throwable;
                ((OutputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (stream == null) return;
        ((OutputStream)stream).close();
    }

    public void saveToStream(OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("templates");
            document.appendChild(root);
            int i = 0;
            while (i != this.fTemplates.size()) {
                Template template = (Template)this.fTemplates.get(i);
                Element node = document.createElement(this.getTemplateTag());
                root.appendChild(node);
                NamedNodeMap attributes = node.getAttributes();
                Attr name = document.createAttribute(NAME_ATTRIBUTE);
                name.setValue(template.getName());
                attributes.setNamedItem(name);
                Attr description = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                description.setValue(template.getDescription());
                attributes.setNamedItem(description);
                Attr context = document.createAttribute(CONTEXT_ATTRIBUTE);
                context.setValue(template.getContextTypeName());
                attributes.setNamedItem(context);
                Attr enabled = document.createAttribute(ENABLED_ATTRIBUTE);
                enabled.setValue(template.isEnabled() ? "true" : "false");
                attributes.setNamedItem(enabled);
                Text pattern = document.createTextNode(template.getPattern());
                node.appendChild(pattern);
                ++i;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            TemplateSet.throwWriteException(e);
        }
        catch (TransformerException e) {
            TemplateSet.throwWriteException(e);
        }
    }

    private static void throwReadException(Throwable t) throws CoreException {
        int code = t instanceof SAXException ? 10005 : 10002;
        IStatus status = JavaUIStatus.createError(code, TemplateMessages.getString("TemplateSet.error.read"), t);
        throw new JavaUIException(status);
    }

    private static void throwWriteException(Throwable t) throws CoreException {
        IStatus status = JavaUIStatus.createError(10002, TemplateMessages.getString("TemplateSet.error.write"), t);
        throw new JavaUIException(status);
    }

    public void add(Template template) {
        if (this.exists(template)) {
            return;
        }
        this.fTemplates.add(template);
    }

    private boolean exists(Template template) {
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template anotherTemplate = (Template)iterator.next();
            if (!template.equals(anotherTemplate)) continue;
            return true;
        }
        return false;
    }

    public void remove(Template template) {
        this.fTemplates.remove(template);
    }

    public void clear() {
        this.fTemplates.clear();
    }

    public Template[] getTemplates() {
        return this.fTemplates.toArray(new Template[this.fTemplates.size()]);
    }

    public Template[] getTemplates(String name) {
        ArrayList<Template> res = new ArrayList<Template>();
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template curr = (Template)iterator.next();
            if (!curr.getName().equals(name)) continue;
            res.add(curr);
        }
        return res.toArray(new Template[res.size()]);
    }

    public Template getFirstTemplate(String name) {
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template curr = (Template)iterator.next();
            if (!curr.getName().equals(name)) continue;
            return curr;
        }
        return null;
    }
}

