/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateMessages;
import org.eclipse.jdt.internal.corext.template.TemplateSet;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;

public class CodeTemplates
extends TemplateSet {
    private static final String DEFAULT_FILE = "default-codetemplates.xml";
    private static final String TEMPLATE_FILE = "codetemplates.xml";
    public static final String COMMENT_SUFFIX = "comment";
    public static final String CATCHBLOCK = "catchblock";
    public static final String METHODSTUB = "methodbody";
    public static final String NEWTYPE = "newtype";
    public static final String CONSTRUCTORSTUB = "constructorbody";
    public static final String GETTERSTUB = "getterbody";
    public static final String SETTERSTUB = "setterbody";
    public static final String TYPECOMMENT = "typecomment";
    public static final String FIELDCOMMENT = "fieldcomment";
    public static final String METHODCOMMENT = "methodcomment";
    public static final String CONSTRUCTORCOMMENT = "constructorcomment";
    public static final String OVERRIDECOMMENT = "overridecomment";
    public static final String GETTERCOMMENT = "gettercomment";
    public static final String SETTERCOMMENT = "settercomment";
    private static CodeTemplates fgTemplates;
    static /* synthetic */ Class class$0;

    public static Template getCodeTemplate(String name) {
        return CodeTemplates.getInstance().getFirstTemplate(name);
    }

    public static CodeTemplates getInstance() {
        if (fgTemplates == null) {
            fgTemplates = new CodeTemplates();
        }
        return fgTemplates;
    }

    private CodeTemplates() {
        super("codetemplate");
        this.create();
    }

    private void create() {
        try {
            this.addFromStream(CodeTemplates.getDefaultsAsStream(), false, true);
            File templateFile = CodeTemplates.getTemplateFile();
            if (templateFile.exists()) {
                this.addFromFile(templateFile, false);
            }
            this.saveToFile(templateFile);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            ErrorDialog.openError(null, (String)TemplateMessages.getString("CodeTemplates.error.title"), (String)e.getMessage(), (IStatus)e.getStatus());
            this.clear();
        }
    }

    public void reset() throws CoreException {
        this.clear();
        this.addFromFile(CodeTemplates.getTemplateFile(), false);
    }

    public void restoreDefaults() throws CoreException {
        this.clear();
        this.addFromStream(CodeTemplates.getDefaultsAsStream(), false, true);
    }

    public void save() throws CoreException {
        this.saveToFile(CodeTemplates.getTemplateFile());
    }

    private static InputStream getDefaultsAsStream() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.internal.corext.template.CodeTemplates;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getResourceAsStream(DEFAULT_FILE);
    }

    private static File getTemplateFile() {
        IPath path = JavaPlugin.getDefault().getStateLocation();
        path = path.append(TEMPLATE_FILE);
        return path.toFile();
    }
}

