/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;

public class TextChangeManager {
    private Map fMap = new HashMap(10);
    private final boolean fKeepExecutedTextEdits;

    public TextChangeManager() {
        this(false);
    }

    public TextChangeManager(boolean keepExecutedTextEdits) {
        this.fKeepExecutedTextEdits = keepExecutedTextEdits;
    }

    public void manage(ICompilationUnit cu, TextChange change) {
        this.fMap.put(cu, change);
    }

    public TextChange get(ICompilationUnit cu) throws CoreException {
        TextChange result = (TextChange)this.fMap.get(cu);
        if (result == null) {
            result = new CompilationUnitChange(cu.getElementName(), cu);
            result.setKeepExecutedTextEdits(this.fKeepExecutedTextEdits);
            this.fMap.put(cu, result);
        }
        return result;
    }

    public TextChange remove(ICompilationUnit unit) {
        return (TextChange)this.fMap.remove(unit);
    }

    public TextChange[] getAllChanges() {
        return this.fMap.values().toArray(new TextChange[this.fMap.values().size()]);
    }

    public ICompilationUnit[] getAllCompilationUnits() {
        return this.fMap.keySet().toArray(new ICompilationUnit[this.fMap.keySet().size()]);
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean containsChangesIn(ICompilationUnit cu) {
        return this.fMap.containsKey(cu);
    }
}

