/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintOperator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;

public final class SimpleTypeConstraint
implements ITypeConstraint {
    private final ConstraintVariable fLeft;
    private final ConstraintVariable fRight;
    private final ConstraintOperator fOperator;

    private SimpleTypeConstraint(ConstraintVariable left, ConstraintVariable right, ConstraintOperator operator) {
        Assert.isNotNull(left);
        Assert.isNotNull(right);
        Assert.isNotNull(operator);
        this.fLeft = left;
        this.fRight = right;
        this.fOperator = operator;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleTypeConstraint)) {
            return false;
        }
        SimpleTypeConstraint other = (SimpleTypeConstraint)obj;
        return this.getLeft().equals(other.getLeft()) && this.fOperator.equals(other.fOperator) && this.getRight().equals(other.getRight());
    }

    public int hashCode() {
        return this.getLeft().hashCode() ^ this.fOperator.hashCode() ^ this.getRight().hashCode();
    }

    public ConstraintVariable getLeft() {
        return this.fLeft;
    }

    public ConstraintVariable getRight() {
        return this.fRight;
    }

    public ConstraintOperator getOperator() {
        return this.fOperator;
    }

    public String toString() {
        return String.valueOf(this.getLeft().toString()) + " " + this.fOperator.toString() + " " + this.getRight().toString();
    }

    public String toResolvedString() {
        return String.valueOf(this.getLeft().toResolvedString()) + " " + this.fOperator.toString() + " " + this.getRight().toResolvedString();
    }

    public boolean isSimpleTypeConstraint() {
        return true;
    }

    public boolean isSubtypeConstraint() {
        return this.fOperator.isSubtypeOperator();
    }

    public boolean isStrictSubtypeConstraint() {
        return this.fOperator.isStrictSubtypeOperator();
    }

    public boolean isEqualsConstraint() {
        return this.fOperator.isEqualsOperator();
    }

    public boolean isDefinesConstraint() {
        return this.fOperator.isDefinesOperator();
    }

    public static SimpleTypeConstraint createConstraint(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator operator) {
        return new SimpleTypeConstraint(v1, v2, operator);
    }

    public static SimpleTypeConstraint createStrictSubtypeConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return SimpleTypeConstraint.createConstraint(v1, v2, ConstraintOperator.createStrictSubtypeOperator());
    }

    public static SimpleTypeConstraint createSubtypeConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return SimpleTypeConstraint.createConstraint(v1, v2, ConstraintOperator.createSubTypeOperator());
    }

    public static SimpleTypeConstraint createEqualsConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return SimpleTypeConstraint.createConstraint(v1, v2, ConstraintOperator.createEqualsOperator());
    }

    public static SimpleTypeConstraint createDefinesConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return SimpleTypeConstraint.createConstraint(v1, v2, ConstraintOperator.createDefinesOperator());
    }
}

