/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;

public class ParameterTypeVariable
extends ConstraintVariable {
    private final IMethodBinding fMethodBinding;
    private final int fParameterIndex;

    public ParameterTypeVariable(IMethodBinding methodBinding, int parameterIndex) {
        super(methodBinding.getParameterTypes()[parameterIndex]);
        Assert.isNotNull(methodBinding);
        Assert.isTrue(parameterIndex >= 0);
        Assert.isTrue(parameterIndex < methodBinding.getParameterTypes().length);
        this.fMethodBinding = methodBinding;
        this.fParameterIndex = parameterIndex;
    }

    public String toString() {
        return "[Parameter(" + this.fParameterIndex + "," + Bindings.asString((IBinding)this.fMethodBinding) + ")]";
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ParameterTypeVariable)) {
            return false;
        }
        ParameterTypeVariable other = (ParameterTypeVariable)obj;
        return Bindings.equals((IBinding)this.fMethodBinding, (IBinding)other.fMethodBinding) && this.fParameterIndex == other.fParameterIndex;
    }

    public int hashCode() {
        return super.hashCode() ^ Bindings.hashCode((IBinding)this.fMethodBinding) ^ this.fParameterIndex;
    }

    public IMethodBinding getMethodBinding() {
        return this.fMethodBinding;
    }

    public int getParameterIndex() {
        return this.fParameterIndex;
    }
}

